/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.CharSequenceBodyWriter;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.HttpHeaderNames;
import jakarta.inject.Singleton;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Singleton
@Replaces(value=CharSequenceBodyWriter.class)
@Internal
public final class NettyCharSequenceBodyWriter
implements ResponseBodyWriter<CharSequence> {
    private final CharSequenceBodyWriter defaultHandler = new CharSequenceBodyWriter(StandardCharsets.UTF_8);

    public ByteBodyHttpResponse<?> write(ByteBufferFactory<?, ?> bufferFactory, HttpRequest<?> request, MutableHttpResponse<CharSequence> outgoingResponse, Argument<CharSequence> type, MediaType mediaType, CharSequence object) throws CodecException {
        MutableHttpHeaders headers = outgoingResponse.getHeaders();
        ByteBuf byteBuf = ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(object), (Charset)MessageBodyWriter.getCharset((MediaType)mediaType, (Headers)headers));
        NettyHttpHeaders nettyHttpHeaders = (NettyHttpHeaders)headers;
        if (!nettyHttpHeaders.contains("Content-Type")) {
            nettyHttpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)mediaType);
        }
        return ByteBodyHttpResponseWrapper.wrap(outgoingResponse, (CloseableByteBody)new AvailableNettyByteBody(byteBuf));
    }

    public void writeTo(Argument<CharSequence> type, MediaType mediaType, CharSequence object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.defaultHandler.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }
}

