/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel.loom;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.netty.util.internal.PlatformDependent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

@Internal
public final class PrivateLoomSupport {
    private static final MethodHandle DEFAULT_SCHEDULER;
    private static final MethodHandle BUILDER_SCHEDULER;
    private static final MethodHandle CARRIER_THREAD;
    private static final MethodHandle THREAD_SCHEDULER;
    private static final Throwable FAILURE;

    @NonNull
    static ForkJoinPool getDefaultScheduler() {
        try {
            return DEFAULT_SCHEDULER.invokeExact();
        }
        catch (Throwable e) {
            PlatformDependent.throwException((Throwable)e);
            throw new AssertionError();
        }
    }

    public static void setScheduler(Object builder, Executor executor) {
        try {
            BUILDER_SCHEDULER.invokeExact(builder, executor);
        }
        catch (Throwable e) {
            PlatformDependent.throwException((Throwable)e);
        }
    }

    public static Thread getCarrierThread(Thread t) {
        try {
            return CARRIER_THREAD.invokeExact(t);
        }
        catch (Throwable e) {
            PlatformDependent.throwException((Throwable)e);
            throw new AssertionError();
        }
    }

    public static Executor getScheduler(Thread t) {
        try {
            return THREAD_SCHEDULER.invokeExact(t);
        }
        catch (Throwable e) {
            PlatformDependent.throwException((Throwable)e);
            throw new AssertionError();
        }
    }

    public static boolean isSupported() {
        return CARRIER_THREAD != null;
    }

    static {
        Exception failure;
        MethodHandle carrierThread;
        MethodHandle threadScheduler;
        MethodHandle builderScheduler;
        MethodHandle defaultScheduler;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field defaultSchedulerField = Class.forName("java.lang.VirtualThread").getDeclaredField("DEFAULT_SCHEDULER");
            defaultSchedulerField.setAccessible(true);
            defaultScheduler = lookup.unreflectGetter(defaultSchedulerField);
            Field schedulerField = Class.forName("java.lang.ThreadBuilders$VirtualThreadBuilder").getDeclaredField("scheduler");
            schedulerField.setAccessible(true);
            builderScheduler = lookup.unreflectSetter(schedulerField).asType(MethodType.methodType(Void.TYPE, Object.class, Executor.class));
            Field threadSchedulerField = Class.forName("java.lang.VirtualThread").getDeclaredField("scheduler");
            threadSchedulerField.setAccessible(true);
            threadScheduler = lookup.unreflectGetter(threadSchedulerField).asType(MethodType.methodType(Executor.class, Thread.class));
            Field carrierThreadField = Class.forName("java.lang.VirtualThread").getDeclaredField("carrierThread");
            carrierThreadField.setAccessible(true);
            carrierThread = lookup.unreflectGetter(carrierThreadField).asType(MethodType.methodType(Thread.class, Thread.class));
            failure = null;
        }
        catch (ReflectiveOperationException | InaccessibleObjectException roe) {
            defaultScheduler = null;
            builderScheduler = null;
            threadScheduler = null;
            carrierThread = null;
            failure = roe;
        }
        DEFAULT_SCHEDULER = defaultScheduler;
        BUILDER_SCHEDULER = builderScheduler;
        THREAD_SCHEDULER = threadScheduler;
        CARRIER_THREAD = carrierThread;
        FAILURE = failure;
    }

    static final class PrivateLoomCondition
    implements Condition {
        PrivateLoomCondition() {
        }

        public boolean matches(ConditionContext context) {
            if (BUILDER_SCHEDULER == null) {
                context.fail("Failed to access loom internals. Please make sure to add the `--add-opens=java.base/java.lang=ALL-UNNAMED` JVM argument. (" + String.valueOf(FAILURE) + ")");
                return false;
            }
            return true;
        }
    }
}

