/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.processor.SingleSubscriberProcessor;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.netty.stream.StreamedHttpMessage;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.netty.buffer.ByteBufHolder;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

@Internal
public abstract class AbstractHttpContentProcessor<T>
extends SingleSubscriberProcessor<ByteBufHolder, T>
implements HttpContentProcessor<T> {
    protected final NettyHttpRequest<?> nettyHttpRequest;
    protected final long advertisedLength;
    protected final long requestMaxSize;
    protected final AtomicLong receivedLength = new AtomicLong();
    protected final HttpServerConfiguration configuration;

    public AbstractHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration) {
        this.nettyHttpRequest = nettyHttpRequest;
        this.advertisedLength = nettyHttpRequest.getContentLength();
        this.requestMaxSize = configuration.getMaxRequestSize();
        this.configuration = configuration;
    }

    protected abstract void onData(ByteBufHolder var1);

    protected final void doSubscribe(Subscriber<? super T> subscriber) {
        StreamedHttpMessage message = (StreamedHttpMessage)this.nettyHttpRequest.getNativeRequest();
        message.subscribe((Subscriber)this);
    }

    protected final void doOnNext(ByteBufHolder message) {
        long receivedLength = this.receivedLength.addAndGet(message.content().readableBytes());
        if (this.advertisedLength != -1L && receivedLength > this.advertisedLength || receivedLength > this.requestMaxSize) {
            this.fireExceedsLength(receivedLength, this.advertisedLength == -1L ? this.requestMaxSize : this.advertisedLength);
        } else {
            long serverMax = this.configuration.getMultipart().getMaxFileSize();
            if (receivedLength > serverMax) {
                this.fireExceedsLength(receivedLength, serverMax);
            } else {
                this.onData(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireExceedsLength(long receivedLength, long expected) {
        try {
            this.onError((Throwable)new ContentLengthExceededException(expected, receivedLength));
        }
        finally {
            this.parentSubscription.cancel();
        }
    }
}

