/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.processor.SingleThreadedBufferingProcessor;
import io.micronaut.core.async.subscriber.SingleThreadedBufferingSubscriber;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.netty.stream.StreamedHttpMessage;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.HttpData;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

@Internal
public class DefaultHttpContentProcessor
extends SingleThreadedBufferingProcessor<ByteBufHolder, ByteBufHolder>
implements HttpContentProcessor<ByteBufHolder> {
    protected final NettyHttpRequest nettyHttpRequest;
    protected final ChannelHandlerContext ctx;
    protected final HttpServerConfiguration configuration;
    protected final long advertisedLength;
    protected final long requestMaxSize;
    protected final StreamedHttpMessage streamedHttpMessage;
    protected final AtomicLong receivedLength = new AtomicLong();
    private final long partMaxSize;

    public DefaultHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration) {
        this.nettyHttpRequest = nettyHttpRequest;
        HttpRequest nativeRequest = nettyHttpRequest.getNativeRequest();
        if (!(nativeRequest instanceof StreamedHttpMessage)) {
            throw new IllegalStateException("Streamed HTTP message expected");
        }
        this.streamedHttpMessage = (StreamedHttpMessage)nativeRequest;
        this.configuration = configuration;
        this.requestMaxSize = configuration.getMaxRequestSize();
        this.ctx = nettyHttpRequest.getChannelHandlerContext();
        this.advertisedLength = nettyHttpRequest.getContentLength();
        this.partMaxSize = configuration.getMultipart().getMaxFileSize();
    }

    public final void subscribe(Subscriber<? super ByteBufHolder> downstreamSubscriber) {
        StreamedHttpMessage message = (StreamedHttpMessage)this.nettyHttpRequest.getNativeRequest();
        message.subscribe((Subscriber)this);
        super.subscribe(downstreamSubscriber);
    }

    protected void onUpstreamMessage(ByteBufHolder message) {
        long receivedLength = this.receivedLength.addAndGet(this.resolveLength(message));
        if (this.advertisedLength != -1L && receivedLength > this.advertisedLength || receivedLength > this.requestMaxSize) {
            this.fireExceedsLength(this.advertisedLength == -1L ? receivedLength : this.advertisedLength, this.requestMaxSize);
        } else if (this.verifyPartDefinedSize(message)) {
            this.publishVerifiedContent(message);
        }
    }

    private boolean verifyPartDefinedSize(ByteBufHolder message) {
        boolean validPart;
        long partLength = message instanceof HttpData ? ((HttpData)message).definedLength() : -1L;
        boolean bl = validPart = partLength > this.partMaxSize;
        if (validPart) {
            this.fireExceedsLength(partLength, this.partMaxSize);
            return false;
        }
        return true;
    }

    private long resolveLength(ByteBufHolder message) {
        if (message instanceof HttpData) {
            return ((HttpData)message).length();
        }
        return message.content().readableBytes();
    }

    private void fireExceedsLength(long receivedLength, long expected) {
        this.upstreamState = SingleThreadedBufferingSubscriber.BackPressureState.DONE;
        this.upstreamSubscription.cancel();
        this.currentDownstreamSubscriber().ifPresent(subscriber -> subscriber.onError((Throwable)new ContentLengthExceededException(expected, receivedLength)));
    }

    private void publishVerifiedContent(ByteBufHolder message) {
        this.currentDownstreamSubscriber().ifPresent(subscriber -> subscriber.onNext((Object)message));
    }
}

