/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.SupplierUtil;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.web.router.RouteMatch;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Internal
public class NettyHttpRequest<T>
extends AbstractNettyHttpRequest<T>
implements HttpRequest<T> {
    private static final AttributeKey<NettyHttpRequest> KEY = AttributeKey.valueOf((String)NettyHttpRequest.class.getSimpleName());
    private final NettyHttpHeaders headers;
    private final ChannelHandlerContext channelHandlerContext;
    private final HttpServerConfiguration serverConfiguration;
    private final Map<Class, Optional> convertedBodies = new LinkedHashMap<Class, Optional>(1);
    private final MutableConvertibleValues<Object> attributes;
    private NettyCookies nettyCookies;
    private List<ByteBufHolder> receivedContent = new ArrayList<ByteBufHolder>();
    private Map<Integer, AbstractHttpData> receivedData = new LinkedHashMap<Integer, AbstractHttpData>();
    private Supplier<Optional<T>> body;
    private RouteMatch<?> matchedRoute;
    private boolean bodyRequired;

    public NettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, ChannelHandlerContext ctx, ConversionService environment, HttpServerConfiguration serverConfiguration) {
        super(nettyRequest, environment);
        Objects.requireNonNull(nettyRequest, "Netty request cannot be null");
        Objects.requireNonNull(ctx, "ChannelHandlerContext cannot be null");
        Objects.requireNonNull(environment, "Environment cannot be null");
        Channel channel = ctx.channel();
        if (channel != null) {
            channel.attr(KEY).set((Object)this);
        }
        this.serverConfiguration = serverConfiguration;
        this.attributes = new MutableConvertibleValuesMap(new ConcurrentHashMap(4), this.conversionService);
        this.channelHandlerContext = ctx;
        this.headers = new NettyHttpHeaders(nettyRequest.headers(), this.conversionService);
        this.body = SupplierUtil.memoizedNonEmpty(() -> Optional.ofNullable(this.buildBody()));
    }

    public String toString() {
        return this.getMethod() + " " + this.getUri();
    }

    public io.netty.handler.codec.http.HttpRequest getNativeRequest() {
        return this.nettyRequest;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookies getCookies() {
        NettyCookies cookies = this.nettyCookies;
        if (cookies == null) {
            NettyHttpRequest nettyHttpRequest = this;
            synchronized (nettyHttpRequest) {
                cookies = this.nettyCookies;
                if (cookies == null) {
                    this.nettyCookies = cookies = new NettyCookies(this.getPath(), this.headers.getNettyHeaders(), this.conversionService);
                }
            }
        }
        return cookies;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().remoteAddress();
    }

    public InetSocketAddress getServerAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().localAddress();
    }

    public String getServerName() {
        return this.getServerAddress().getHostName();
    }

    public boolean isSecure() {
        ChannelHandlerContext channelHandlerContext = this.getChannelHandlerContext();
        return channelHandlerContext.pipeline().get(SslHandler.class) != null;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public Optional<T> getBody() {
        return this.body.get();
    }

    protected Object buildBody() {
        if (!this.receivedData.isEmpty()) {
            LinkedHashMap<Object, Object> body = new LinkedHashMap<Object, Object>(this.receivedData.size());
            for (AbstractHttpData data : this.receivedData.values()) {
                String newValue = this.getContent(data);
                body.compute(data.getName(), (key, oldValue) -> {
                    if (oldValue == null) {
                        return newValue;
                    }
                    if (oldValue instanceof Collection) {
                        ((Collection)oldValue).add(newValue);
                        return oldValue;
                    }
                    ArrayList<Object> values = new ArrayList<Object>(2);
                    values.add(oldValue);
                    values.add(newValue);
                    return values;
                });
                data.release();
            }
            return body;
        }
        if (!this.receivedContent.isEmpty()) {
            int size = this.receivedContent.size();
            CompositeByteBuf byteBufs = this.channelHandlerContext.alloc().compositeBuffer(size);
            for (ByteBufHolder holder : this.receivedContent) {
                ByteBuf content = holder.content();
                if (content == null) continue;
                byteBufs.addComponent(true, content);
            }
            return byteBufs;
        }
        return null;
    }

    private String getContent(AbstractHttpData data) {
        String newValue;
        try {
            newValue = data.getString(this.serverConfiguration.getDefaultCharset());
        }
        catch (IOException e) {
            throw new InternalServerException("Error retrieving or decoding the value for: " + data.getName());
        }
        return newValue;
    }

    public <T1> Optional<T1> getBody(Class<T1> type) {
        Optional<Object> body = this.getBody();
        return body.flatMap(t -> this.convertedBodies.computeIfAbsent(type, aClass -> this.conversionService.convert(t, aClass)));
    }

    public <T1> Optional<T1> getBody(Argument<T1> type) {
        Optional<Object> body = this.getBody();
        return body.flatMap(t -> this.convertedBodies.computeIfAbsent(type.getType(), aClass -> this.conversionService.convert(t, ConversionContext.of((Argument)type))));
    }

    @Internal
    public void release() {
        Object body = this.getBody().orElse(null);
        this.releaseIfNecessary(body);
        for (ByteBufHolder byteBufHolder : this.receivedContent) {
            this.releaseIfNecessary(byteBufHolder);
        }
        for (ByteBufHolder byteBufHolder : this.receivedData.values()) {
            this.releaseIfNecessary(byteBufHolder);
        }
        if (this.body != null && this.body instanceof ReferenceCounted) {
            ReferenceCounted referenceCounted = (ReferenceCounted)this.body;
            this.releaseIfNecessary(referenceCounted);
        }
        for (Map.Entry entry : this.attributes) {
            Object value = entry.getValue();
            this.releaseIfNecessary(value);
        }
    }

    protected void releaseIfNecessary(Object value) {
        ReferenceCounted referenceCounted;
        int i;
        if (value instanceof ReferenceCounted && (i = (referenceCounted = (ReferenceCounted)value).refCnt()) != 0) {
            referenceCounted.release();
        }
    }

    @Internal
    public void setBody(T body) {
        this.body = () -> Optional.ofNullable(body);
        this.convertedBodies.clear();
    }

    @Internal
    public RouteMatch<?> getMatchedRoute() {
        return this.matchedRoute;
    }

    @Internal
    void addContent(ByteBufHolder httpContent) {
        if (httpContent instanceof AbstractHttpData) {
            this.receivedData.computeIfAbsent(System.identityHashCode(httpContent), key -> {
                httpContent.retain();
                return (AbstractHttpData)httpContent;
            });
        } else {
            this.receivedContent.add(httpContent);
        }
    }

    @Internal
    void setMatchedRoute(RouteMatch<?> matchedRoute) {
        this.matchedRoute = matchedRoute;
    }

    @Internal
    void setBodyRequired(boolean bodyRequired) {
        this.bodyRequired = bodyRequired;
    }

    @Internal
    boolean isBodyRequired() {
        return this.bodyRequired || HttpMethod.requiresRequestBody((HttpMethod)this.getMethod());
    }

    protected Charset initCharset(Charset characterEncoding) {
        return characterEncoding == null ? this.serverConfiguration.getDefaultCharset() : characterEncoding;
    }

    static NettyHttpRequest get(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(KEY);
        return (NettyHttpRequest)((Object)attr.get());
    }

    static NettyHttpRequest remove(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(KEY);
        return (NettyHttpRequest)((Object)attr.getAndSet(null));
    }
}

