/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.event.ServiceShutdownEvent;
import io.micronaut.discovery.event.ServiceStartedEvent;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.http.netty.stream.HttpStreamsServerHandler;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.server.netty.EventLoopGroupFactory;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.NettyEmbeddedServerInstance;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.decoders.HttpRequestDecoder;
import io.micronaut.http.server.netty.encoders.HttpResponseEncoder;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.EmbeddedServerInstance;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
public class NettyHttpServer
implements EmbeddedServer,
WebSocketSessionRepository {
    public static final String HTTP_STREAMS_CODEC = "http-streams-codec";
    public static final String HTTP_CHUNKED_HANDLER = "http-chunked-handler";
    public static final String HTTP_CODEC = "http-codec";
    public static final String HTTP_COMPRESSOR = "http-compressor";
    public static final String HTTP_DECOMPRESSOR = "http-decompressor";
    public static final String HTTP_KEEP_ALIVE_HANDLER = "http-keep-alive-handler";
    public static final String MICRONAUT_HANDLER = "micronaut-inbound-handler";
    public static final String OUTBOUND_KEY = "-outbound-";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final ExecutorService ioExecutor;
    private final ExecutorSelector executorSelector;
    private final List<ChannelOutboundHandler> outboundHandlers;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final ServerSslConfiguration sslConfiguration;
    private final StaticResourceResolver staticResourceResolver;
    private final Environment environment;
    private final Router router;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final BeanLocator beanLocator;
    private final ThreadFactory threadFactory;
    private final WebSocketBeanRegistry webSocketBeanRegistry;
    private final int specifiedPort;
    private final HttpCompressionStrategy httpCompressionStrategy;
    private volatile int serverPort;
    private final ApplicationContext applicationContext;
    private final SslContext sslContext;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ChannelGroup webSocketSessions = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private EventLoopGroup workerGroup;
    private EventLoopGroup parentGroup;
    private EmbeddedServerInstance serviceInstance;
    private EventLoopGroupFactory eventLoopGroupFactory;

    @Inject
    public NettyHttpServer(NettyHttpServerConfiguration serverConfiguration, ApplicationContext applicationContext, Router router, RequestArgumentSatisfier requestArgumentSatisfier, MediaTypeCodecRegistry mediaTypeCodecRegistry, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, StaticResourceResolver resourceResolver, @javax.inject.Named(value="io") ExecutorService ioExecutor, @javax.inject.Named(value="netty") ThreadFactory threadFactory, ExecutorSelector executorSelector, Optional<ServerSslBuilder> serverSslBuilder, List<ChannelOutboundHandler> outboundHandlers, EventLoopGroupFactory eventLoopGroupFactory, HttpCompressionStrategy httpCompressionStrategy) {
        this.httpCompressionStrategy = httpCompressionStrategy;
        Optional location = serverConfiguration.getMultipart().getLocation();
        location.ifPresent(dir -> {
            DiskFileUpload.baseDirectory = dir.getAbsolutePath();
        });
        this.applicationContext = applicationContext;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.customizableResponseTypeHandlerRegistry = customizableResponseTypeHandlerRegistry;
        this.beanLocator = applicationContext;
        this.environment = applicationContext.getEnvironment();
        this.serverConfiguration = serverConfiguration;
        this.router = router;
        this.ioExecutor = ioExecutor;
        Optional configPort = serverConfiguration.getPort();
        this.specifiedPort = configPort.isPresent() ? (Integer)configPort.get() : (this.environment.getActiveNames().contains("test") ? -1 : 8080);
        int port = this.specifiedPort;
        if (serverSslBuilder.isPresent()) {
            ServerSslBuilder sslBuilder = serverSslBuilder.get();
            this.sslConfiguration = sslBuilder.getSslConfiguration();
            this.sslContext = sslBuilder.build().orElse(null);
            if (this.sslConfiguration.isEnabled()) {
                port = this.sslConfiguration.getPort();
            }
        } else {
            this.sslConfiguration = null;
            this.sslContext = null;
        }
        this.serverPort = port == -1 ? SocketUtils.findAvailableTcpPort() : port;
        this.executorSelector = executorSelector;
        OrderUtil.sort(outboundHandlers);
        this.outboundHandlers = outboundHandlers;
        this.requestArgumentSatisfier = requestArgumentSatisfier;
        this.staticResourceResolver = resourceResolver;
        this.threadFactory = threadFactory;
        this.webSocketBeanRegistry = WebSocketBeanRegistry.forServer((BeanContext)applicationContext);
        this.eventLoopGroupFactory = eventLoopGroupFactory;
    }

    public boolean isKeepAlive() {
        return false;
    }

    public NettyHttpServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public boolean isRunning() {
        return this.running.get() && !SocketUtils.isTcpPortAvailable((int)this.serverPort);
    }

    public synchronized EmbeddedServer start() {
        if (!this.isRunning()) {
            this.workerGroup = this.createWorkerEventLoopGroup();
            this.parentGroup = this.createParentEventLoopGroup();
            ServerBootstrap serverBootstrap = this.createServerBootstrap();
            this.processOptions(this.serverConfiguration.getOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).option(arg_0, arg_1));
            this.processOptions(this.serverConfiguration.getChildOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).childOption(arg_0, arg_1));
            serverBootstrap = ((ServerBootstrap)serverBootstrap.group(this.parentGroup, this.workerGroup).channel(this.eventLoopGroupFactory.serverSocketChannelClass())).childHandler((ChannelHandler)new ChannelInitializer(){
                final HttpRequestDecoder requestDecoder;
                final HttpResponseEncoder responseDecoder;
                final RoutingInBoundHandler routingHandler;
                final LoggingHandler loggingHandler;
                {
                    this.requestDecoder = new HttpRequestDecoder(NettyHttpServer.this, (ConversionService<?>)NettyHttpServer.this.environment, NettyHttpServer.this.serverConfiguration);
                    this.responseDecoder = new HttpResponseEncoder(NettyHttpServer.this.mediaTypeCodecRegistry, NettyHttpServer.this.serverConfiguration);
                    this.routingHandler = new RoutingInBoundHandler(NettyHttpServer.this.beanLocator, NettyHttpServer.this.router, NettyHttpServer.this.mediaTypeCodecRegistry, NettyHttpServer.this.customizableResponseTypeHandlerRegistry, NettyHttpServer.this.staticResourceResolver, NettyHttpServer.this.serverConfiguration, NettyHttpServer.this.requestArgumentSatisfier, NettyHttpServer.this.executorSelector, NettyHttpServer.this.ioExecutor);
                    this.loggingHandler = NettyHttpServer.this.serverConfiguration.getLogLevel().isPresent() ? new LoggingHandler(NettyHttpServer.this.serverConfiguration.getLogLevel().get()) : null;
                }

                protected void initChannel(Channel ch) {
                    Duration idleTime;
                    ChannelPipeline pipeline = ch.pipeline();
                    if (NettyHttpServer.this.sslContext != null) {
                        pipeline.addLast(new ChannelHandler[]{NettyHttpServer.this.sslContext.newHandler(ch.alloc())});
                    }
                    if (this.loggingHandler != null) {
                        pipeline.addLast(new ChannelHandler[]{this.loggingHandler});
                    }
                    if (!(idleTime = NettyHttpServer.this.serverConfiguration.getIdleTimeout()).isNegative()) {
                        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((int)NettyHttpServer.this.serverConfiguration.getReadIdleTimeout().getSeconds(), (int)NettyHttpServer.this.serverConfiguration.getWriteIdleTimeout().getSeconds(), (int)idleTime.getSeconds())});
                    }
                    pipeline.addLast(NettyHttpServer.HTTP_CODEC, (ChannelHandler)new HttpServerCodec(NettyHttpServer.this.serverConfiguration.getMaxInitialLineLength(), NettyHttpServer.this.serverConfiguration.getMaxHeaderSize(), NettyHttpServer.this.serverConfiguration.getMaxChunkSize(), NettyHttpServer.this.serverConfiguration.isValidateHeaders(), NettyHttpServer.this.serverConfiguration.getInitialBufferSize()));
                    pipeline.addLast(new ChannelHandler[]{new FlowControlHandler()});
                    pipeline.addLast(NettyHttpServer.HTTP_KEEP_ALIVE_HANDLER, (ChannelHandler)new HttpServerKeepAliveHandler());
                    pipeline.addLast(NettyHttpServer.HTTP_COMPRESSOR, (ChannelHandler)new SmartHttpContentCompressor(NettyHttpServer.this.httpCompressionStrategy));
                    pipeline.addLast(NettyHttpServer.HTTP_DECOMPRESSOR, (ChannelHandler)new HttpContentDecompressor());
                    pipeline.addLast(NettyHttpServer.HTTP_STREAMS_CODEC, (ChannelHandler)new HttpStreamsServerHandler());
                    pipeline.addLast(NettyHttpServer.HTTP_CHUNKED_HANDLER, (ChannelHandler)new ChunkedWriteHandler());
                    pipeline.addLast("micronaut-http-decoder", (ChannelHandler)this.requestDecoder);
                    pipeline.addLast("micronaut-http-encoder", (ChannelHandler)this.responseDecoder);
                    pipeline.addLast("websocket-upgrade-handler", (ChannelHandler)new NettyServerWebSocketUpgradeHandler(NettyHttpServer.this.getWebSocketSessionRepository(), NettyHttpServer.this.router, NettyHttpServer.this.requestArgumentSatisfier.getBinderRegistry(), NettyHttpServer.this.webSocketBeanRegistry, NettyHttpServer.this.mediaTypeCodecRegistry, (ApplicationEventPublisher)NettyHttpServer.this.applicationContext));
                    pipeline.addLast(NettyHttpServer.MICRONAUT_HANDLER, (ChannelHandler)this.routingHandler);
                    NettyHttpServer.this.registerMicronautChannelHandlers(pipeline);
                }
            });
            Optional host = this.serverConfiguration.getHost();
            this.bindServerToHost(serverBootstrap, host.orElse(null), new AtomicInteger(0));
            this.running.set(true);
        }
        return this;
    }

    public synchronized EmbeddedServer stop() {
        if (this.isRunning() && this.workerGroup != null && this.running.compareAndSet(true, false)) {
            this.stopInternal();
        }
        return this;
    }

    public int getPort() {
        return this.serverPort;
    }

    public String getHost() {
        return this.serverConfiguration.getHost().orElseGet(() -> Optional.ofNullable(System.getenv("HOSTNAME")).orElse("localhost"));
    }

    public String getScheme() {
        return this.sslConfiguration != null && this.sslConfiguration.isEnabled() ? "https" : "http";
    }

    public URL getURL() {
        try {
            return new URL(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        try {
            return new URI(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.serverConfiguration.getApplicationConfiguration();
    }

    protected EventLoopGroup createParentEventLoopGroup() {
        return this.newEventLoopGroup(this.serverConfiguration.getParent());
    }

    protected EventLoopGroup createWorkerEventLoopGroup() {
        return this.newEventLoopGroup(this.serverConfiguration.getWorker());
    }

    protected ServerBootstrap createServerBootstrap() {
        return new ServerBootstrap();
    }

    private void bindServerToHost(ServerBootstrap serverBootstrap, @Nullable String host, AtomicInteger attempts) {
        boolean isRandomPort = this.specifiedPort == -1;
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        if (applicationName.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Binding {} server to {}:{}", new Object[]{applicationName.get(), host != null ? host : "*", this.serverPort});
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Binding server to {}:{}", (Object)(host != null ? host : "*"), (Object)this.serverPort);
        }
        try {
            if (host != null) {
                serverBootstrap.bind(host, this.serverPort).sync();
            } else {
                serverBootstrap.bind(this.serverPort).sync();
            }
            this.applicationContext.publishEvent((Object)new ServerStartupEvent((EmbeddedServer)this));
            applicationName.ifPresent(id -> {
                this.serviceInstance = (EmbeddedServerInstance)this.applicationContext.createBean(NettyEmbeddedServerInstance.class, new Object[]{id, this});
                this.applicationContext.publishEvent((Object)new ServiceStartedEvent((ServiceInstance)this.serviceInstance));
            });
        }
        catch (Throwable e) {
            boolean isBindError = e instanceof BindException;
            if (LOG.isErrorEnabled()) {
                if (isBindError) {
                    LOG.error("Unable to start server. Port already {} in use.", (Object)this.serverPort);
                } else {
                    LOG.error("Error starting Micronaut server: " + e.getMessage(), e);
                }
            }
            int attemptCount = attempts.getAndIncrement();
            if (isRandomPort && attemptCount < 3) {
                this.serverPort = SocketUtils.findAvailableTcpPort();
                this.bindServerToHost(serverBootstrap, host, attempts);
            }
            this.stopInternal();
            throw new ServerStartupException("Unable to start Micronaut server on port: " + this.serverPort, e);
        }
    }

    private void logShutdownErrorIfNecessary(Future<?> future) {
        if (!future.isSuccess() && LOG.isWarnEnabled()) {
            Throwable e = future.cause();
            LOG.warn("Error stopping Micronaut server: " + e.getMessage(), e);
        }
    }

    private void stopInternal() {
        block4: {
            try {
                this.workerGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                this.parentGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                this.webSocketSessions.close();
                this.applicationContext.publishEvent((Object)new ServerShutdownEvent((EmbeddedServer)this));
                if (this.serviceInstance != null) {
                    this.applicationContext.publishEvent((Object)new ServiceShutdownEvent((ServiceInstance)this.serviceInstance));
                }
                if (this.applicationContext.isRunning()) {
                    this.applicationContext.stop();
                }
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("Error stopping Micronaut server: " + e.getMessage(), e);
            }
        }
    }

    private EventLoopGroup newEventLoopGroup(NettyHttpServerConfiguration.EventLoopConfig config) {
        if (config != null) {
            Optional<EventLoopGroup> executorService = config.getExecutorName().flatMap(name -> this.beanLocator.findBean(ExecutorService.class, Qualifiers.byName((String)name)));
            int threads = config.getNumOfThreads();
            Integer ioRatio = config.getIoRatio().orElse(null);
            return executorService.map(service -> this.eventLoopGroupFactory.createEventLoopGroup(threads, (Executor)service, ioRatio)).orElseGet(() -> {
                if (this.threadFactory != null) {
                    return this.eventLoopGroupFactory.createEventLoopGroup(threads, this.threadFactory, ioRatio);
                }
                return this.eventLoopGroupFactory.createEventLoopGroup(threads, ioRatio);
            });
        }
        if (this.threadFactory != null) {
            return this.eventLoopGroupFactory.createEventLoopGroup(NettyThreadFactory.DEFAULT_EVENT_LOOP_THREADS, this.threadFactory, null);
        }
        return this.eventLoopGroupFactory.createEventLoopGroup(null);
    }

    private void registerMicronautChannelHandlers(ChannelPipeline pipeline) {
        int i = 0;
        for (ChannelHandler channelHandler : this.outboundHandlers) {
            String name = channelHandler instanceof Named ? ((Named)channelHandler).getName() : "micronaut-inbound-handler-outbound-" + ++i;
            pipeline.addAfter(HTTP_CODEC, name, channelHandler);
        }
    }

    private void processOptions(Map<ChannelOption, Object> options, BiConsumer<ChannelOption, Object> biConsumer) {
        for (ChannelOption channelOption : options.keySet()) {
            String name = channelOption.name();
            Object value = options.get(channelOption);
            Optional declaredField = ReflectionUtils.findDeclaredField(ChannelOption.class, (String)name);
            declaredField.ifPresent(field -> {
                Optional typeArg = GenericTypeUtils.resolveGenericTypeArgument((Field)field);
                typeArg.ifPresent(arg -> {
                    Optional converted = this.environment.convert(value, arg);
                    converted.ifPresent(convertedValue -> biConsumer.accept(channelOption, convertedValue));
                });
            });
            if (declaredField.isPresent()) continue;
            biConsumer.accept(channelOption, value);
        }
    }

    public void addChannel(Channel channel) {
        this.webSocketSessions.add((Object)channel);
    }

    public void removeChannel(Channel channel) {
        this.webSocketSessions.remove((Object)channel);
    }

    public ChannelGroup getChannelGroup() {
        return this.webSocketSessions;
    }

    public WebSocketSessionRepository getWebSocketSessionRepository() {
        return this;
    }
}

