/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import javax.inject.Singleton;

@Factory
@Internal
public class ByteBufConverters {
    @Singleton
    TypeConverter<ByteBuf, CharSequence> byteBufCharSequenceTypeConverter() {
        return (object, targetType, context) -> Optional.of(object.toString(context.getCharset()));
    }

    @Singleton
    TypeConverter<CompositeByteBuf, CharSequence> compositeByteBufCharSequenceTypeConverter() {
        return (object, targetType, context) -> Optional.of(object.toString(context.getCharset()));
    }

    @Singleton
    TypeConverter<ByteBuf, byte[]> byteBufToArrayTypeConverter() {
        return (object, targetType, context) -> Optional.of(ByteBufUtil.getBytes((ByteBuf)object));
    }

    @Singleton
    TypeConverter<byte[], ByteBuf> byteArrayToByteBuffTypeConverter() {
        return (object, targetType, context) -> Optional.of(Unpooled.wrappedBuffer((byte[])object));
    }

    @Singleton
    TypeConverter<CompositeByteBuf, byte[]> compositeByteBufTypeConverter() {
        return (object, targetType, context) -> Optional.of(ByteBufUtil.getBytes((ByteBuf)object));
    }

    @Singleton
    TypeConverter<CompositeByteBuf, Object> compositeByteBufToObjectTypeConverter(ConversionService conversionService) {
        return (object, targetType, context) -> conversionService.convert(object, String.class, context).flatMap(val -> conversionService.convert(val, targetType, context));
    }
}

