/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.DefaultHttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.web.router.qualifier.ConsumesMediaTypeQualifier;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Singleton;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Singleton
@Internal
public class CompletableFutureBodyBinder
extends DefaultBodyAnnotationBinder<CompletableFuture>
implements NonBlockingBodyArgumentBinder<CompletableFuture> {
    private final BeanLocator beanLocator;
    private final HttpServerConfiguration httpServerConfiguration;

    public CompletableFutureBodyBinder(BeanLocator beanLocator, HttpServerConfiguration httpServerConfiguration, ConversionService conversionService) {
        super(conversionService);
        this.beanLocator = beanLocator;
        this.httpServerConfiguration = httpServerConfiguration;
    }

    public Argument<CompletableFuture> argumentType() {
        return Argument.of(CompletableFuture.class);
    }

    public ArgumentBinder.BindingResult<CompletableFuture> bind(final ArgumentConversionContext<CompletableFuture> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            final NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)source;
            io.netty.handler.codec.http.HttpRequest nativeRequest = ((NettyHttpRequest)source).getNativeRequest();
            if (nativeRequest instanceof StreamedHttpRequest) {
                final CompletableFuture future = new CompletableFuture();
                Optional contentType = source.getContentType();
                HttpContentProcessor processor = contentType.flatMap(type -> this.beanLocator.findBean(HttpContentSubscriberFactory.class, (Qualifier)new ConsumesMediaTypeQualifier(type))).map(factory -> factory.build(nettyHttpRequest)).orElse(new DefaultHttpContentProcessor(nettyHttpRequest, this.httpServerConfiguration));
                processor.subscribe((Subscriber)new CompletionAwareSubscriber<Object>(){

                    protected void doOnSubscribe(Subscription subscription) {
                        subscription.request(1L);
                    }

                    protected void doOnNext(Object message) {
                        nettyHttpRequest.setBody(message);
                        this.subscription.request(1L);
                    }

                    protected void doOnError(Throwable t) {
                        future.completeExceptionally(t);
                    }

                    protected void doOnComplete() {
                        Optional firstTypeParameter = context.getFirstTypeVariable();
                        Optional body = nettyHttpRequest.getBody();
                        if (body.isPresent()) {
                            if (firstTypeParameter.isPresent()) {
                                Argument arg = (Argument)firstTypeParameter.get();
                                Class targetType = arg.getType();
                                Optional converted = CompletableFutureBodyBinder.this.conversionService.convert(body.get(), context.with(arg));
                                if (converted.isPresent()) {
                                    future.complete(converted.get());
                                } else {
                                    future.completeExceptionally(new IllegalArgumentException("Cannot bind JSON to argument type: " + targetType.getName()));
                                }
                            } else {
                                future.complete(body.get());
                            }
                        } else {
                            future.complete(null);
                        }
                    }
                });
                return () -> Optional.of(future);
            }
            return ArgumentBinder.BindingResult.EMPTY;
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

