/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.server.netty.ByteBufDelegate;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.reactivex.subjects.ReplaySubject;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HttpDataReference {
    private static final Logger LOG = LoggerFactory.getLogger(HttpDataReference.class);
    final AtomicReference<ReplaySubject> subject = new AtomicReference();
    final AtomicReference<StreamingFileUpload> upload = new AtomicReference();
    private final HttpData data;
    private final AtomicReference<RandomAccessFile> fileAccess = new AtomicReference();
    private final AtomicLong position = new AtomicLong(0L);
    private final List<Component> components = new ArrayList<Component>();

    HttpDataReference(HttpData data) {
        this.data = data;
        data.retain();
    }

    public Optional<MediaType> getContentType() {
        if (this.data instanceof FileUpload) {
            return Optional.of(MediaType.of((CharSequence)((FileUpload)this.data).getContentType()));
        }
        return Optional.empty();
    }

    Component addComponent(Consumer<IOException> onError) {
        Component component;
        try {
            long readable = this.readableBytes(this.data);
            long offset = this.position.getAndUpdate(p -> readable);
            int length = new Long(readable - offset).intValue();
            component = new Component(length, offset);
            this.components.add(component);
        }
        catch (IOException e) {
            onError.accept(e);
            return null;
        }
        if (!this.data.isInMemory()) {
            this.fileAccess.getAndUpdate(channel -> {
                if (channel == null) {
                    try {
                        return new RandomAccessFile(this.data.getFile(), "r");
                    }
                    catch (IOException e) {
                        onError.accept(e);
                    }
                }
                return channel;
            });
        }
        return component;
    }

    void removeComponent(int index) {
        Component component = this.components.get(index);
        this.components.remove(index);
        this.updateComponentOffsets(index);
        this.position.getAndUpdate(offset -> offset - (long)component.length);
    }

    private long readableBytes(HttpData httpData) throws IOException {
        if (httpData.isInMemory()) {
            return httpData.getByteBuf().readableBytes();
        }
        return httpData.length();
    }

    private ByteBuf createDelegate(final ByteBuf byteBuf, final BiFunction<ByteBuf, Integer, Boolean> onRelease) {
        return new ByteBufDelegate(byteBuf){

            @Override
            public boolean release() {
                return (Boolean)onRelease.apply(byteBuf, 1);
            }

            @Override
            public boolean release(int decrement) {
                return (Boolean)onRelease.apply(byteBuf, decrement);
            }
        };
    }

    private void updateComponentOffsets(int index) {
        int size = this.components.size();
        if (size <= index) {
            return;
        }
        Component c = this.components.get(index);
        if (index == 0) {
            c.offset = 0L;
            ++index;
        }
        for (int i = index; i < size; ++i) {
            Component prev = this.components.get(i - 1);
            Component cur = this.components.get(i);
            cur.offset = prev.length;
        }
    }

    void destroy() {
        this.fileAccess.getAndUpdate(channel -> {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    LOG.warn("Error closing file channel for disk file upload", (Throwable)e);
                }
            }
            return null;
        });
        this.data.release();
    }

    public final class Component {
        private final int length;
        private long offset;

        private Component(int length, long offset) {
            this.length = length;
            this.offset = offset;
        }

        public ByteBuf getByteBuf() throws IOException {
            if (this.length == 0) {
                return Unpooled.EMPTY_BUFFER;
            }
            if (HttpDataReference.this.data.isInMemory()) {
                ByteBuf byteBuf = HttpDataReference.this.data.getByteBuf();
                int index = HttpDataReference.this.components.indexOf(this);
                if (byteBuf instanceof CompositeByteBuf) {
                    CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                    return HttpDataReference.this.createDelegate(compositeByteBuf.component(index), (buf, count) -> {
                        compositeByteBuf.removeComponent(index);
                        HttpDataReference.this.removeComponent(index);
                        return true;
                    });
                }
                return HttpDataReference.this.createDelegate(byteBuf, (buf, count) -> {
                    try {
                        ByteBuf currentBuffer = HttpDataReference.this.data.getByteBuf();
                        if (currentBuffer instanceof CompositeByteBuf) {
                            ((CompositeByteBuf)currentBuffer).removeComponent(index);
                        } else {
                            HttpDataReference.this.data.delete();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    HttpDataReference.this.removeComponent(index);
                    return true;
                });
            }
            byte[] data = new byte[this.length];
            ((RandomAccessFile)HttpDataReference.this.fileAccess.get()).getChannel().read(ByteBuffer.wrap(data), this.offset);
            return Unpooled.wrappedBuffer((byte[])data);
        }
    }
}

