/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class FileUploadToCompletedFileUploadConverter
implements TypeConverter<FileUpload, CompletedFileUpload> {
    public Optional<CompletedFileUpload> convert(FileUpload upload, Class<CompletedFileUpload> targetType, ConversionContext context) {
        try {
            if (!upload.isCompleted()) {
                return Optional.empty();
            }
            return Optional.of(new NettyCompletedFileUpload(upload));
        }
        catch (Exception e) {
            context.reject(e);
            return Optional.empty();
        }
    }
}

