/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.configuration;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import io.netty.channel.ChannelOption;
import io.netty.handler.logging.LogLevel;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

@ConfigurationProperties(value="netty")
@Replaces(value=HttpServerConfiguration.class)
public class NettyHttpServerConfiguration
extends HttpServerConfiguration {
    public static final boolean DEFAULT_USE_NATIVE_TRANSPORT = false;
    public static final int DEFAULT_MAXINITIALLINELENGTH = 4096;
    public static final int DEFAULT_MAXHEADERSIZE = 8192;
    public static final int DEFAULT_MAXCHUNKSIZE = 8192;
    public static final boolean DEFAULT_CHUNKSUPPORTED = true;
    public static final boolean DEFAULT_VALIDATEHEADERS = true;
    public static final int DEFAULT_INITIALBUFFERSIZE = 128;
    public static final int DEFAULT_COMPRESSIONTHRESHOLD = 1024;
    public static final int DEFAULT_COMPRESSIONLEVEL = 6;
    private Map<ChannelOption, Object> childOptions = Collections.emptyMap();
    private Map<ChannelOption, Object> options = Collections.emptyMap();
    private Worker worker;
    private Parent parent;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int maxChunkSize = 8192;
    private boolean chunkedSupported = true;
    private boolean validateHeaders = true;
    private int initialBufferSize = 128;
    private LogLevel logLevel;
    private int compressionThreshold = 1024;
    private int compressionLevel = 6;
    private boolean useNativeTransport = false;

    public NettyHttpServerConfiguration() {
    }

    @Inject
    public NettyHttpServerConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
    }

    public Optional<LogLevel> getLogLevel() {
        return Optional.ofNullable(this.logLevel);
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public boolean isChunkedSupported() {
        return this.chunkedSupported;
    }

    public boolean isUseNativeTransport() {
        return this.useNativeTransport;
    }

    public boolean isValidateHeaders() {
        return this.validateHeaders;
    }

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public Map<ChannelOption, Object> getChildOptions() {
        return this.childOptions;
    }

    public Map<ChannelOption, Object> getOptions() {
        return this.options;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public Parent getParent() {
        return this.parent;
    }

    public void setChildOptions(Map<ChannelOption, Object> childOptions) {
        this.childOptions = childOptions;
    }

    public void setOptions(Map<ChannelOption, Object> options) {
        this.options = options;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public void setMaxInitialLineLength(@ReadableBytes int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public void setMaxHeaderSize(@ReadableBytes int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public void setMaxChunkSize(@ReadableBytes int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public void setChunkedSupported(boolean chunkedSupported) {
        this.chunkedSupported = chunkedSupported;
    }

    public void setUseNativeTransport(boolean useNativeTransport) {
        this.useNativeTransport = useNativeTransport;
    }

    public void setValidateHeaders(boolean validateHeaders) {
        this.validateHeaders = validateHeaders;
    }

    public void setInitialBufferSize(int initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setCompressionThreshold(@ReadableBytes int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    public void setCompressionLevel(@ReadableBytes int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public static abstract class EventLoopConfig {
        private int threads;
        private Integer ioRatio;
        private String executor;

        public void setThreads(int threads) {
            this.threads = threads;
        }

        public void setIoRatio(Integer ioRatio) {
            this.ioRatio = ioRatio;
        }

        public void setExecutor(String executor) {
            this.executor = executor;
        }

        public int getNumOfThreads() {
            return this.threads;
        }

        public Optional<Integer> getIoRatio() {
            if (this.ioRatio != null) {
                return Optional.of(this.ioRatio);
            }
            return Optional.empty();
        }

        public Optional<String> getExecutorName() {
            if (this.executor != null) {
                return Optional.of(this.executor);
            }
            return Optional.empty();
        }
    }

    @ConfigurationProperties(value="parent")
    public static class Parent
    extends EventLoopConfig {
    }

    @ConfigurationProperties(value="worker")
    public static class Worker
    extends EventLoopConfig {
    }
}

