/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.EventLoopGroupFactory;
import io.micronaut.http.server.netty.KQueueAvailabilityCondition;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(property="micronaut.server.netty.use-native-transport", value="true", defaultValue="false"), @Requires(classes={KQueue.class}, condition=KQueueAvailabilityCondition.class)})
@Internal
public class KQueueEventLoopGroupFactory
implements EventLoopGroupFactory {
    private static KQueueEventLoopGroup withIoRatio(KQueueEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio.intValue());
        }
        return group;
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(threads), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(threads, threadFactory), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(threads, executor), ioRatio);
    }

    @Override
    public EventLoopGroup createEventLoopGroup(@Nullable Integer ioRatio) {
        return KQueueEventLoopGroupFactory.withIoRatio(new KQueueEventLoopGroup(), ioRatio);
    }

    @Override
    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return KQueueServerSocketChannel.class;
    }
}

