/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.netty.jackson.JsonViewCodecResolver;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={JacksonConfiguration.class}), @Requires(property="jackson.json-view.enabled")})
@Filter(value={"/**"})
public class JsonViewServerFilter
implements HttpServerFilter {
    public static final String PROPERTY_JSON_VIEW_ENABLED = "jackson.json-view.enabled";
    private final JsonViewCodecResolver codecFactory;
    private final ExecutorService executorService;

    public JsonViewServerFilter(JsonViewCodecResolver jsonViewCodecResolver, @Named(value="io") ExecutorService executorService) {
        this.codecFactory = jsonViewCodecResolver;
        this.executorService = executorService;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Optional viewClass = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, AnnotationMetadata.class).flatMap(ann -> ann.classValue(JsonView.class));
        Publisher responsePublisher = chain.proceed(request);
        if (viewClass.isPresent()) {
            return Flowable.fromPublisher((Publisher)responsePublisher).switchMap(response -> {
                Optional optionalBody = response.getBody();
                if (optionalBody.isPresent()) {
                    Object body = optionalBody.get();
                    JsonMediaTypeCodec codec = this.codecFactory.resolveJsonViewCodec((Class)viewClass.get());
                    if (Publishers.isConvertibleToPublisher(body)) {
                        response.body((Object)((Flowable)Publishers.convertPublisher(body, Flowable.class)).map(arg_0 -> JsonViewServerFilter.lambda$null$1((MediaTypeCodec)codec, arg_0)).subscribeOn(Schedulers.from((Executor)this.executorService)));
                    } else {
                        return Flowable.fromCallable(() -> JsonViewServerFilter.lambda$null$2((MediaTypeCodec)codec, body, response)).subscribeOn(Schedulers.from((Executor)this.executorService));
                    }
                }
                return Flowable.just((Object)response);
            });
        }
        return responsePublisher;
    }

    public int getOrder() {
        return ServerFilterPhase.RENDERING.order();
    }

    private static /* synthetic */ MutableHttpResponse lambda$null$2(MediaTypeCodec codec, Object body, MutableHttpResponse response) throws Exception {
        byte[] encoded = codec.encode(body);
        response.body((Object)encoded);
        return response;
    }

    private static /* synthetic */ Object lambda$null$1(MediaTypeCodec codec, Object item) throws Exception {
        return codec.encode(item);
    }
}

