/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.BeanCreationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.KotlinUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.content.HttpContentUtil;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpDataReference;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.async.ContextCompletionAwareSubscriber;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.netty.types.files.NettyStreamedFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.util.KotlinExecutableMethodUtils;
import io.micronaut.runtime.http.codec.TextPlainCodec;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.BasicObjectRouteMatch;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.DuplicateRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.LongConsumer;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@ChannelHandler.Sharable
class RoutingInBoundHandler
extends SimpleChannelInboundHandler<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final Argument ARGUMENT_PART_DATA = Argument.of(PartData.class);
    private static final Object NOT_FOUND = new Object();
    private static final Single<Object> NOT_FOUND_SINGLE = Single.just((Object)NOT_FOUND);
    private final Router router;
    private final ExecutorSelector executorSelector;
    private final StaticResourceResolver staticResourceResolver;
    private final BeanContext beanContext;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry;
    private final Supplier<ExecutorService> ioExecutorSupplier;
    private final String serverHeader;
    private ExecutorService ioExecutor;

    RoutingInBoundHandler(BeanContext beanContext, Router router, MediaTypeCodecRegistry mediaTypeCodecRegistry, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, StaticResourceResolver staticResourceResolver, NettyHttpServerConfiguration serverConfiguration, RequestArgumentSatisfier requestArgumentSatisfier, ExecutorSelector executorSelector, Supplier<ExecutorService> ioExecutor, HttpContentProcessorResolver httpContentProcessorResolver) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.customizableResponseTypeHandlerRegistry = customizableResponseTypeHandlerRegistry;
        this.beanContext = beanContext;
        this.staticResourceResolver = staticResourceResolver;
        this.ioExecutorSupplier = ioExecutor;
        this.executorSelector = executorSelector;
        this.router = router;
        this.requestArgumentSatisfier = requestArgumentSatisfier;
        this.serverConfiguration = serverConfiguration;
        this.serverHeader = serverConfiguration.getServerHeader().orElse(null);
        this.httpContentProcessorResolver = httpContentProcessorResolver;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.cleanupIfNecessary(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (ctx.channel().isWritable()) {
            ctx.flush();
        }
        this.cleanupIfNecessary(ctx);
    }

    private void cleanupIfNecessary(ChannelHandlerContext ctx) {
        NettyHttpRequest.remove(ctx);
    }

    private void cleanupRequest(ChannelHandlerContext ctx, NettyHttpRequest request) {
        try {
            request.release();
        }
        finally {
            ctx.executor().execute(() -> {
                block2: {
                    try {
                        this.beanContext.publishEvent((Object)new HttpRequestTerminatedEvent((HttpRequest)request));
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block2;
                        LOG.error("Error publishing request terminated event: " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            IdleStateEvent idleStateEvent;
            IdleState state;
            if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        NettyHttpRequest nettyHttpRequest = NettyHttpRequest.remove(ctx);
        if (nettyHttpRequest == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
            }
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            return;
        }
        this.exceptionCaughtInternal(ctx, cause, nettyHttpRequest, true);
    }

    private void exceptionCaughtInternal(ChannelHandlerContext ctx, Throwable t, NettyHttpRequest nettyHttpRequest, boolean nettyException) {
        Optional<Class> rootBeanType;
        Throwable cause;
        RouteMatch errorRoute = null;
        RouteMatch<?> originalRoute = nettyHttpRequest.getMatchedRoute();
        Class declaringType = null;
        if (originalRoute instanceof MethodExecutionHandle) {
            declaringType = ((MethodExecutionHandle)originalRoute).getDeclaringType();
        }
        if ((cause = (t instanceof CompletionException || t instanceof ExecutionException) && t.getCause() != null ? t.getCause() : t) instanceof UnsatisfiedRouteException) {
            if (declaringType != null) {
                errorRoute = this.router.findStatusRoute(declaringType, HttpStatus.BAD_REQUEST, (HttpRequest)nettyHttpRequest).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.findStatusRoute(HttpStatus.BAD_REQUEST, (HttpRequest)nettyHttpRequest).orElse(null);
            }
        } else if (cause instanceof HttpStatusException) {
            HttpStatusException statusException = (HttpStatusException)cause;
            if (declaringType != null) {
                errorRoute = this.router.findStatusRoute(declaringType, statusException.getStatus(), (HttpRequest)nettyHttpRequest).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.findStatusRoute(statusException.getStatus(), (HttpRequest)nettyHttpRequest).orElse(null);
            }
        } else if (cause instanceof BeanCreationException && declaringType != null && (rootBeanType = ((BeanCreationException)cause).getRootBeanType().map(BeanType::getBeanType)).isPresent() && declaringType == rootBeanType.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to instantiate [{}]. Skipping lookup of a local error route", (Object)declaringType.getName());
            }
            declaringType = null;
        }
        if (errorRoute == null) {
            if (declaringType != null) {
                errorRoute = this.router.findErrorRoute(declaringType, cause, (HttpRequest)nettyHttpRequest).orElse(null);
            }
            if (errorRoute == null) {
                errorRoute = this.router.findErrorRoute(cause, (HttpRequest)nettyHttpRequest).orElse(null);
            }
        }
        if (errorRoute != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found matching exception handler for exception [{}]: {}", (Object)cause.getMessage(), (Object)errorRoute);
            }
            errorRoute = this.requestArgumentSatisfier.fulfillArgumentRequirements(errorRoute, (HttpRequest)nettyHttpRequest, false);
            try {
                this.buildExecutableRoute(errorRoute, nettyHttpRequest, ctx, (ExecutorService)ctx.executor(), true, nettyException).execute();
            }
            catch (Throwable e) {
                this.writeDefaultErrorResponse(ctx, nettyHttpRequest, e, nettyException);
            }
        } else {
            Optional exceptionHandler = this.beanContext.findBean(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest((Class[])new Class[]{cause.getClass(), Object.class}));
            if (exceptionHandler.isPresent()) {
                ExceptionHandler handler = (ExceptionHandler)exceptionHandler.get();
                MediaType defaultResponseMediaType = MediaType.fromType(handler.getClass()).orElse(MediaType.APPLICATION_JSON_TYPE);
                try {
                    Flowable routePublisher = Flowable.fromCallable(() -> {
                        Object result = handler.handle((HttpRequest)nettyHttpRequest, cause);
                        return this.errorResultToResponse(result);
                    });
                    this.filterPublisher(new AtomicReference(nettyHttpRequest), (Publisher<MutableHttpResponse<?>>)routePublisher, (ExecutorService)ctx.executor(), nettyException).firstOrError().subscribe((mutableHttpResponse, throwable) -> {
                        if (throwable != null) {
                            this.writeDefaultErrorResponse(ctx, nettyHttpRequest, (Throwable)throwable, nettyException);
                        } else {
                            this.encodeHttpResponse(ctx, nettyHttpRequest, (MutableHttpResponse<?>)mutableHttpResponse, mutableHttpResponse.body(), defaultResponseMediaType);
                        }
                    });
                    if (this.serverConfiguration.isLogHandledExceptions()) {
                        this.logException(cause);
                    }
                }
                catch (Throwable e) {
                    this.writeDefaultErrorResponse(ctx, nettyHttpRequest, e, nettyException);
                }
            } else {
                this.writeDefaultErrorResponse(ctx, nettyHttpRequest, cause, nettyException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest<?> request) {
        UriRouteMatch route;
        NettyHttpRequest nettyHttpRequest;
        io.netty.handler.codec.http.HttpRequest nativeRequest;
        DecoderResult decoderResult;
        ctx.channel().config().setAutoRead(false);
        HttpMethod httpMethod = request.getMethod();
        String requestPath = request.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matching route {} - {}", (Object)httpMethod, (Object)requestPath);
        }
        if ((decoderResult = (nativeRequest = (nettyHttpRequest = (NettyHttpRequest)request).getNativeRequest()).decoderResult()).isFailure()) {
            Throwable cause = decoderResult.cause();
            HttpStatus status = cause instanceof TooLongFrameException ? HttpStatus.REQUEST_ENTITY_TOO_LARGE : HttpStatus.BAD_REQUEST;
            this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.status((HttpStatus)status), status.getReason());
            return;
        }
        UriRouteMatch routeMatch = null;
        List uriRoutes = this.router.findAllClosest(request);
        if (uriRoutes.size() > 1) {
            throw new DuplicateRouteException(requestPath, uriRoutes);
        }
        if (uriRoutes.size() == 1) {
            UriRouteMatch establishedRoute = (UriRouteMatch)uriRoutes.get(0);
            request.setAttribute((CharSequence)HttpAttributes.ROUTE, (Object)establishedRoute.getRoute());
            request.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)establishedRoute);
            request.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, (Object)establishedRoute.getRoute().getUriMatchTemplate().toString());
            routeMatch = establishedRoute;
        }
        String requestMethodName = request.getMethodName();
        if (routeMatch == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No matching route found for URI {} and method {}", (Object)request.getUri(), (Object)httpMethod);
            }
            List anyMatchingRoutes = this.router.findAny((CharSequence)request.getUri().toString(), request).collect(Collectors.toList());
            MediaType contentType = request.getContentType().orElse(null);
            Collection acceptedTypes = request.accept();
            boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)acceptedTypes);
            HashSet acceptableContentTypes = contentType != null ? new HashSet(5) : null;
            HashSet<String> allowedMethods = new HashSet<String>(5);
            HashSet produceableContentTypes = hasAcceptHeader ? new HashSet(5) : null;
            for (UriRouteMatch anyRoute : anyMatchingRoutes) {
                String routeMethod = anyRoute.getRoute().getHttpMethodName();
                if (!requestMethodName.equals(routeMethod)) {
                    allowedMethods.add(routeMethod);
                }
                if (contentType != null && !anyRoute.doesConsume(contentType)) {
                    acceptableContentTypes.addAll(anyRoute.getRoute().getConsumes());
                }
                if (!hasAcceptHeader || anyRoute.doesProduce(acceptedTypes)) continue;
                produceableContentTypes.addAll(anyRoute.getRoute().getProduces());
            }
            if (CollectionUtils.isNotEmpty(acceptableContentTypes)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{request.getUri(), requestMethodName, contentType});
                }
                this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.status((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE), "Content Type [" + contentType + "] not allowed. Allowed types: " + acceptableContentTypes);
                return;
            }
            if (CollectionUtils.isNotEmpty(produceableContentTypes)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content type not allowed for URI {}, method {}, and content type {}", new Object[]{request.getUri(), requestMethodName, contentType});
                }
                this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE), "Specified Accept Types " + acceptedTypes + " not supported. Supported types: " + produceableContentTypes);
                return;
            }
            if (!allowedMethods.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Method not allowed for URI {} and method {}", (Object)request.getUri(), (Object)requestMethodName);
                }
                this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.notAllowedGeneric(allowedMethods), "Method [" + requestMethodName + "] not allowed for URI [" + request.getUri() + "]. Allowed methods: " + allowedMethods);
                return;
            }
            Optional<? extends FileCustomizableResponseType> optionalFile = this.matchFile(requestPath);
            if (optionalFile.isPresent()) {
                route = new BasicObjectRouteMatch((Object)optionalFile.get());
            } else {
                Optional statusRoute = this.router.findStatusRoute(HttpStatus.NOT_FOUND, request);
                if (!statusRoute.isPresent()) {
                    this.emitDefaultNotFoundResponse(ctx, request, false);
                    return;
                }
                route = (RouteMatch)statusRoute.get();
            }
        } else {
            route = routeMatch;
        }
        if (LOG.isDebugEnabled()) {
            if (route instanceof MethodBasedRouteMatch) {
                LOG.debug("Matched route {} - {} to controller {}", new Object[]{requestMethodName, requestPath, route.getDeclaringType()});
            } else {
                LOG.debug("Matched route {} - {}", (Object)requestMethodName, (Object)requestPath);
            }
        }
        if (!route.isAnnotationPresent(OnMessage.class) && !route.isAnnotationPresent(OnOpen.class)) {
            this.handleRouteMatch((RouteMatch<?>)route, nettyHttpRequest, ctx, false);
            return;
        }
        this.handleStatusError(ctx, request, nettyHttpRequest, (MutableHttpResponse<Object>)HttpResponse.status((HttpStatus)HttpStatus.BAD_REQUEST), "Not a WebSocket request");
    }

    private void handleStatusError(ChannelHandlerContext ctx, HttpRequest<?> request, NettyHttpRequest nettyHttpRequest, MutableHttpResponse<Object> defaultResponse, String message) {
        Optional statusRoute = this.router.findStatusRoute(defaultResponse.status(), request);
        if (statusRoute.isPresent()) {
            RouteMatch routeMatch = (RouteMatch)statusRoute.get();
            this.handleRouteMatch(routeMatch, nettyHttpRequest, ctx, false);
        } else {
            if (request.getMethod() != HttpMethod.HEAD) {
                JsonError error = this.newError(request, message);
                defaultResponse.body((Object)error);
            }
            this.filterAndEncodeResponse(ctx, request, nettyHttpRequest, defaultResponse, MediaType.APPLICATION_JSON_TYPE, false);
        }
    }

    private void filterAndEncodeResponse(ChannelHandlerContext ctx, HttpRequest<?> request, NettyHttpRequest nettyHttpRequest, MutableHttpResponse<Object> finalResponse, MediaType defaultResponseMediaType, boolean skipOncePerRequest) {
        AtomicReference requestReference = new AtomicReference(request);
        this.filterPublisher(requestReference, (Publisher<MutableHttpResponse<?>>)Flowable.just(finalResponse), (ExecutorService)ctx.channel().eventLoop(), skipOncePerRequest).singleOrError().subscribe(mutableHttpResponse -> this.encodeHttpResponse(ctx, nettyHttpRequest, (MutableHttpResponse<?>)mutableHttpResponse, mutableHttpResponse.body(), defaultResponseMediaType), throwable -> this.exceptionCaughtInternal(ctx, (Throwable)throwable, nettyHttpRequest, false));
    }

    private Optional<? extends FileCustomizableResponseType> matchFile(String path) {
        Optional optionalUrl = this.staticResourceResolver.resolve(path);
        if (optionalUrl.isPresent()) {
            try {
                File file;
                URL url = (URL)optionalUrl.get();
                if (url.getProtocol().equals("file") && (file = Paths.get(url.toURI()).toFile()).exists() && !file.isDirectory() && file.canRead()) {
                    return Optional.of(new NettySystemFileCustomizableResponseType(file));
                }
                return Optional.of(new NettyStreamedFileCustomizableResponseType(url));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private void emitDefaultNotFoundResponse(ChannelHandlerContext ctx, HttpRequest<?> request, boolean skipOncePerRequest) {
        MutableHttpResponse<Object> res = this.newNotFoundError(request);
        this.filterAndEncodeResponse(ctx, request, (NettyHttpRequest)request, res, MediaType.APPLICATION_JSON_TYPE, skipOncePerRequest);
    }

    private MutableHttpResponse<Object> newNotFoundError(HttpRequest<?> request) {
        JsonError error = this.newError(request, "Page Not Found");
        return HttpResponse.notFound().body((Object)error);
    }

    private JsonError newError(HttpRequest<?> request, String message) {
        URI uri = request.getUri();
        return (JsonError)new JsonError(message).link(Link.SELF, Link.of((URI)uri));
    }

    private MutableHttpResponse errorResultToResponse(Object result) {
        if (result instanceof HttpResponse) {
            return this.toNettyResponse((HttpResponse)result);
        }
        MutableHttpResponse response = result instanceof HttpStatus ? HttpResponse.status((HttpStatus)((HttpStatus)result)) : HttpResponse.serverError().body(result);
        return response;
    }

    private void handleRouteMatch(RouteMatch<?> route, NettyHttpRequest<?> request, ChannelHandlerContext context, boolean skipOncePerRequest) {
        request.setMatchedRoute(route);
        route = this.requestArgumentSatisfier.fulfillArgumentRequirements(route, request, false);
        request.setMatchedRoute(route);
        Optional<Argument> bodyArgument = route.getBodyArgument().filter(argument -> argument.getAnnotationMetadata().hasAnnotation(Body.class));
        io.netty.handler.codec.http.HttpRequest nativeRequest = request.getNativeRequest();
        if (!(route.isExecutable() || !HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) || !(nativeRequest instanceof StreamedHttpRequest) || bodyArgument.isPresent() && route.isSatisfied(bodyArgument.get().getName()))) {
            this.httpContentProcessorResolver.resolve(request, route).subscribe(this.buildSubscriber(request, context, route));
        } else {
            if (nativeRequest instanceof StreamedHttpRequest) {
                context.read();
            }
            route = this.prepareRouteForExecution(route, request, skipOncePerRequest);
            route.execute();
        }
    }

    private boolean isJsonFormattable(Argument<?> argument) {
        Class javaType = argument.getType();
        if (Publishers.isConvertibleToPublisher((Class)javaType)) {
            javaType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getType();
        }
        return javaType != byte[].class && !ByteBuffer.class.isAssignableFrom(javaType) && !ByteBuf.class.isAssignableFrom(javaType);
    }

    private Subscriber<Object> buildSubscriber(final NettyHttpRequest<?> request, final ChannelHandlerContext context, final RouteMatch<?> finalRoute) {
        boolean isFormData = request.isFormOrMultipartData();
        if (isFormData) {
            return new CompletionAwareSubscriber<Object>(){
                final boolean alwaysAddContent;
                RouteMatch<?> routeMatch;
                final AtomicBoolean executed;
                final AtomicLong pressureRequested;
                final ConcurrentHashMap<String, UnicastProcessor> subjects;
                final ConcurrentHashMap<Integer, HttpDataReference> dataReferences;
                final ConversionService conversionService;
                Subscription s;
                final LongConsumer onRequest;
                {
                    this.alwaysAddContent = request.isFormData();
                    this.routeMatch = finalRoute;
                    this.executed = new AtomicBoolean(false);
                    this.pressureRequested = new AtomicLong(0L);
                    this.subjects = new ConcurrentHashMap();
                    this.dataReferences = new ConcurrentHashMap();
                    this.conversionService = ConversionService.SHARED;
                    this.onRequest = num -> this.pressureRequested.updateAndGet(p -> {
                        long newVal = p - num;
                        if (newVal < 0L) {
                            this.s.request(num - p);
                            return 0L;
                        }
                        return newVal;
                    });
                }

                Flowable processFlowable(Flowable flowable, Integer dataKey, boolean controlsFlow) {
                    if (controlsFlow) {
                        flowable = flowable.doOnRequest(this.onRequest);
                    }
                    return flowable.doAfterTerminate(() -> {
                        if (controlsFlow) {
                            HttpDataReference dataReference = this.dataReferences.get(dataKey);
                            dataReference.destroy();
                        }
                    });
                }

                protected void doOnSubscribe(Subscription subscription) {
                    this.s = subscription;
                    subscription.request(1L);
                }

                protected void doOnNext(Object message) {
                    boolean executed = this.executed.get();
                    if (message instanceof ByteBufHolder) {
                        if (message instanceof HttpData) {
                            String name;
                            Optional requiredInput;
                            HttpData data = (HttpData)message;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Received HTTP Data for request [{}]: {}", (Object)request, message);
                            }
                            if ((requiredInput = this.routeMatch.getRequiredInput(name = data.getName())).isPresent()) {
                                Supplier<Object> value;
                                Argument argument = (Argument)requiredInput.get();
                                boolean isPublisher = Publishers.isConvertibleToPublisher((Class)argument.getType());
                                boolean chunkedProcessing = false;
                                if (isPublisher) {
                                    UnicastProcessor ds;
                                    Integer dataKey = System.identityHashCode(data);
                                    HttpDataReference dataReference = this.dataReferences.computeIfAbsent(dataKey, key -> new HttpDataReference(data));
                                    Argument typeVariable = StreamingFileUpload.class.isAssignableFrom(argument.getType()) ? ARGUMENT_PART_DATA : argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                    Class typeVariableType = typeVariable.getType();
                                    UnicastProcessor namedSubject = this.subjects.computeIfAbsent(name, key -> UnicastProcessor.create());
                                    boolean bl = chunkedProcessing = PartData.class.equals((Object)typeVariableType) || Publishers.isConvertibleToPublisher((Class)typeVariableType) || ClassUtils.isJavaLangType((Class)typeVariableType);
                                    if (Publishers.isConvertibleToPublisher((Class)typeVariableType)) {
                                        boolean streamingFileUpload = StreamingFileUpload.class.isAssignableFrom(typeVariableType);
                                        typeVariable = streamingFileUpload ? ARGUMENT_PART_DATA : typeVariable.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                        dataReference.subject.getAndUpdate(subject -> {
                                            if (subject == null) {
                                                UnicastProcessor childSubject = UnicastProcessor.create();
                                                Flowable flowable = this.processFlowable((Flowable)childSubject, dataKey, true);
                                                if (streamingFileUpload && data instanceof FileUpload) {
                                                    namedSubject.onNext((Object)new NettyStreamingFileUpload((FileUpload)data, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.getIoExecutor(), (Flowable<PartData>)flowable));
                                                } else {
                                                    namedSubject.onNext((Object)flowable);
                                                }
                                                return childSubject;
                                            }
                                            return subject;
                                        });
                                    }
                                    UnicastProcessor subject2 = (ds = dataReference.subject.get()) != null ? ds : namedSubject;
                                    Object part = data;
                                    if (chunkedProcessing) {
                                        HttpDataReference.Component component = dataReference.addComponent(e -> {
                                            subject2.onError((Throwable)e);
                                            this.s.cancel();
                                        });
                                        if (component == null) {
                                            return;
                                        }
                                        part = new NettyPartData(dataReference, component);
                                    }
                                    if (data instanceof FileUpload && StreamingFileUpload.class.isAssignableFrom(argument.getType())) {
                                        dataReference.upload.getAndUpdate(upload -> {
                                            if (upload == null) {
                                                return new NettyStreamingFileUpload((FileUpload)data, RoutingInBoundHandler.this.serverConfiguration.getMultipart(), RoutingInBoundHandler.this.getIoExecutor(), (Flowable<PartData>)this.processFlowable((Flowable)subject2, dataKey, true));
                                            }
                                            return upload;
                                        });
                                    }
                                    Optional converted = this.conversionService.convert(part, typeVariable);
                                    converted.ifPresent(arg_0 -> ((UnicastProcessor)subject2).onNext(arg_0));
                                    if (data.isCompleted() && chunkedProcessing) {
                                        subject2.onComplete();
                                    }
                                    value = () -> {
                                        StreamingFileUpload upload = dataReference.upload.get();
                                        if (upload != null) {
                                            return upload;
                                        }
                                        return this.processFlowable((Flowable)namedSubject, dataKey, dataReference.subject.get() == null);
                                    };
                                } else {
                                    if (data instanceof Attribute && !data.isCompleted()) {
                                        request.addContent((ByteBufHolder)data);
                                        this.s.request(1L);
                                        return;
                                    }
                                    value = () -> {
                                        if (data.refCnt() > 0) {
                                            return data;
                                        }
                                        return null;
                                    };
                                }
                                if (!executed) {
                                    String argumentName = argument.getName();
                                    if (!this.routeMatch.isSatisfied(argumentName)) {
                                        this.routeMatch = this.routeMatch.fulfill(Collections.singletonMap(argumentName, value.get()));
                                    }
                                    if (isPublisher && chunkedProcessing) {
                                        this.pressureRequested.incrementAndGet();
                                    }
                                    if (this.routeMatch.isExecutable() || message instanceof LastHttpContent) {
                                        this.executeRoute();
                                        executed = true;
                                    }
                                }
                                if (this.alwaysAddContent) {
                                    request.addContent((ByteBufHolder)data);
                                }
                                if (!executed || !chunkedProcessing) {
                                    this.s.request(1L);
                                }
                            } else {
                                request.addContent((ByteBufHolder)data);
                                this.s.request(1L);
                            }
                        } else {
                            request.addContent((ByteBufHolder)message);
                            this.s.request(1L);
                        }
                    } else {
                        request.setBody(message);
                        this.s.request(1L);
                    }
                }

                protected void doOnError(Throwable t) {
                    try {
                        this.s.cancel();
                        RoutingInBoundHandler.this.exceptionCaught(context, t);
                    }
                    catch (Exception e) {
                        RoutingInBoundHandler.this.writeDefaultErrorResponse(context, request, e, false);
                    }
                }

                protected void doOnComplete() {
                    for (UnicastProcessor subject : this.subjects.values()) {
                        if (subject.hasComplete()) continue;
                        subject.onComplete();
                    }
                    this.executeRoute();
                }

                private void executeRoute() {
                    if (this.executed.compareAndSet(false, true)) {
                        try {
                            this.routeMatch = RoutingInBoundHandler.this.prepareRouteForExecution(this.routeMatch, request, false);
                            this.routeMatch.execute();
                        }
                        catch (Exception e) {
                            context.pipeline().fireExceptionCaught((Throwable)e);
                        }
                    }
                }
            };
        }
        return new CompletionAwareSubscriber<Object>(){
            private Subscription s;
            private RouteMatch<?> routeMatch;
            private AtomicBoolean executed;
            {
                this.routeMatch = finalRoute;
                this.executed = new AtomicBoolean(false);
            }

            protected void doOnSubscribe(Subscription subscription) {
                this.s = subscription;
                subscription.request(1L);
            }

            protected void doOnNext(Object message) {
                if (message instanceof ByteBufHolder) {
                    request.addContent((ByteBufHolder)message);
                    this.s.request(1L);
                } else {
                    request.setBody(message);
                    this.s.request(1L);
                }
            }

            protected void doOnError(Throwable t) {
                try {
                    this.s.cancel();
                    RoutingInBoundHandler.this.exceptionCaught(context, t);
                }
                catch (Exception e) {
                    RoutingInBoundHandler.this.writeDefaultErrorResponse(context, request, e, false);
                }
            }

            protected void doOnComplete() {
                if (this.executed.compareAndSet(false, true)) {
                    try {
                        this.routeMatch = RoutingInBoundHandler.this.prepareRouteForExecution(this.routeMatch, request, false);
                        this.routeMatch.execute();
                    }
                    catch (Exception e) {
                        context.pipeline().fireExceptionCaught((Throwable)e);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private RouteMatch<?> prepareRouteForExecution(RouteMatch<?> route, NettyHttpRequest<?> request, boolean skipOncePerRequest) {
        ChannelHandlerContext context = request.getChannelHandlerContext();
        ExecutorService executor = route instanceof MethodReference ? (ExecutorService)this.executorSelector.select((MethodReference)route, this.serverConfiguration.getThreadSelection()).orElse(null) : null;
        boolean isErrorRoute = false;
        route = this.buildExecutableRoute(route, request, context, executor, isErrorRoute, skipOncePerRequest);
        return route;
    }

    private boolean isSingle(RouteMatch<?> finalRoute, Class<?> bodyClass) {
        return finalRoute.isSpecifiedSingle() || finalRoute.isSingleResult() && (finalRoute.isAsync() || finalRoute.isSuspended() || Publishers.isSingle(bodyClass));
    }

    private RouteMatch<?> buildExecutableRoute(RouteMatch<?> route, NettyHttpRequest<?> request, ChannelHandlerContext context, ExecutorService executor, final boolean isErrorRoute, boolean skipOncePerRequest) {
        route = route.decorate(finalRoute -> {
            final MediaType defaultResponseMediaType = this.resolveDefaultResponseContentType(request, (RouteMatch<?>)finalRoute);
            final AtomicReference requestReference = new AtomicReference(request);
            Flowable<? extends MutableHttpResponse<?>> filteredPublisher = this.buildResultEmitter(request, requestReference, (RouteMatch<?>)finalRoute, executor, isErrorRoute, skipOncePerRequest);
            filteredPublisher.subscribe((Subscriber)new ContextCompletionAwareSubscriber<MutableHttpResponse<?>>(context, (RouteMatch)finalRoute, request, context, executor, skipOncePerRequest){
                final /* synthetic */ RouteMatch val$finalRoute;
                final /* synthetic */ NettyHttpRequest val$request;
                final /* synthetic */ ChannelHandlerContext val$context;
                final /* synthetic */ ExecutorService val$executor;
                final /* synthetic */ boolean val$skipOncePerRequest;
                {
                    this.val$finalRoute = routeMatch;
                    this.val$request = nettyHttpRequest;
                    this.val$context = channelHandlerContext;
                    this.val$executor = executorService;
                    this.val$skipOncePerRequest = bl2;
                    super(context);
                }

                @Override
                protected void onComplete(MutableHttpResponse<?> message) {
                    HttpRequest incomingRequest = (HttpRequest)requestReference.get();
                    RoutingInBoundHandler.this.applyConfiguredHeaders(message.getHeaders());
                    MediaType specifiedMediaType = message.getContentType().orElse(null);
                    final MediaType mediaType = specifiedMediaType != null ? specifiedMediaType : defaultResponseMediaType;
                    Object body = message.body();
                    HttpStatus status = message.status();
                    if (status.getCode() >= 400 && !isErrorRoute) {
                        RouteMatch statusRoute = RoutingInBoundHandler.this.findStatusRoute(incomingRequest, status, this.val$finalRoute);
                        if (statusRoute != null) {
                            incomingRequest.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)statusRoute);
                            RoutingInBoundHandler.this.buildExecutableRoute(statusRoute, this.val$request, this.val$context, this.val$executor, true, true).execute();
                        } else {
                            MutableHttpResponse<?> mutableHttpResponse = message;
                            RoutingInBoundHandler.this.encodeHttpResponse(this.val$context, this.val$request, mutableHttpResponse, mutableHttpResponse.body(), defaultResponseMediaType);
                        }
                    } else if (body != null) {
                        boolean isReactive;
                        boolean bl = isReactive = this.val$finalRoute.isAsyncOrReactive() || Publishers.isConvertibleToPublisher((Object)body);
                        if (isReactive && Publishers.isConvertibleToPublisher((Object)body)) {
                            boolean isCompletable;
                            Class<?> bodyClass = body.getClass();
                            boolean isSingle = RoutingInBoundHandler.this.isSingle(this.val$finalRoute, bodyClass);
                            boolean bl2 = isCompletable = !isSingle && this.val$finalRoute.isVoid() && Publishers.isCompletable(bodyClass);
                            if (isSingle || isCompletable) {
                                Single single = ((Maybe)Publishers.convertPublisher((Object)body, Maybe.class)).switchIfEmpty((SingleSource)NOT_FOUND_SINGLE);
                                single.subscribe((o, throwable) -> {
                                    if (o == NOT_FOUND) {
                                        if (isCompletable || this.val$finalRoute.isVoid() || this.val$finalRoute.isSuspended()) {
                                            message.body(null);
                                            message.header((CharSequence)"Content-Length", (CharSequence)HttpHeaderValues.ZERO);
                                            RoutingInBoundHandler.this.writeFinalNettyResponse(message, this.val$request, this.val$context);
                                        } else if (!isErrorRoute) {
                                            RouteMatch statusRoute = RoutingInBoundHandler.this.findStatusRoute(incomingRequest, HttpStatus.NOT_FOUND, this.val$finalRoute);
                                            if (statusRoute != null) {
                                                RoutingInBoundHandler.this.buildExecutableRoute(statusRoute, this.val$request, this.val$context, this.val$executor, true, true).execute();
                                            } else {
                                                RoutingInBoundHandler.this.emitDefaultNotFoundResponse(this.val$context, (HttpRequest)requestReference.get(), this.val$skipOncePerRequest);
                                            }
                                        } else {
                                            RoutingInBoundHandler.this.emitDefaultNotFoundResponse(this.val$context, (HttpRequest)requestReference.get(), this.val$skipOncePerRequest);
                                        }
                                    } else if (throwable != null) {
                                        RoutingInBoundHandler.this.exceptionCaughtInternal(this.val$context, throwable, this.val$request, false);
                                    } else {
                                        MutableHttpResponse finalResponse;
                                        if (o instanceof HttpResponse) {
                                            finalResponse = RoutingInBoundHandler.this.toMutableResponse((HttpResponse)o);
                                            o = finalResponse.body();
                                        } else {
                                            finalResponse = message;
                                        }
                                        RoutingInBoundHandler.this.encodeHttpResponse(this.val$context, this.val$request, finalResponse, o, defaultResponseMediaType);
                                    }
                                });
                            } else {
                                boolean isHttp2;
                                Argument typeArgument = this.val$finalRoute.getReturnType().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                                boolean bl3 = isHttp2 = this.val$request.getHttpVersion() == HttpVersion.HTTP_2_0;
                                if (HttpResponse.class.isAssignableFrom(typeArgument.getType()) && !typeArgument.getFirstTypeVariable().map(Argument::isAsyncOrReactive).orElse(false).booleanValue()) {
                                    Flowable bodyFlowable = (Flowable)Publishers.convertPublisher((Object)body, Flowable.class);
                                    if (isHttp2) {
                                        bodyFlowable.subscribe(httpResponse -> RoutingInBoundHandler.this.encodeHttpResponse(this.val$context, this.val$request, (MutableHttpResponse)RoutingInBoundHandler.this.toNettyResponse(httpResponse), httpResponse.body(), defaultResponseMediaType), throwable -> RoutingInBoundHandler.this.exceptionCaughtInternal(this.val$context, throwable, this.val$request, false));
                                    } else {
                                        bodyFlowable.firstOrError().subscribe((httpResponse, throwable) -> {
                                            if (throwable == null) {
                                                RoutingInBoundHandler.this.encodeHttpResponse(this.val$context, this.val$request, (MutableHttpResponse)RoutingInBoundHandler.this.toNettyResponse(httpResponse), httpResponse.body(), defaultResponseMediaType);
                                            } else {
                                                RoutingInBoundHandler.this.exceptionCaughtInternal(this.val$context, throwable, this.val$request, false);
                                            }
                                        });
                                    }
                                } else {
                                    final boolean isJson = mediaType.getExtension().equals("json") && RoutingInBoundHandler.this.isJsonFormattable(typeArgument);
                                    Flowable bodyFlowable = (Flowable)Publishers.convertPublisher((Object)body, Flowable.class);
                                    final NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(this.val$context.alloc());
                                    Publisher httpContentPublisher = Publishers.map((Publisher)bodyFlowable, (Function)new Function<Object, HttpContent>(){
                                        boolean first = true;

                                        @Override
                                        public HttpContent apply(Object message) {
                                            DefaultHttpContent httpContent;
                                            if (message instanceof ByteBuf) {
                                                httpContent = new DefaultHttpContent((ByteBuf)message);
                                            } else if (message instanceof ByteBuffer) {
                                                ByteBuffer byteBuffer = (ByteBuffer)message;
                                                Object nativeBuffer = byteBuffer.asNativeBuffer();
                                                httpContent = nativeBuffer instanceof ByteBuf ? new DefaultHttpContent((ByteBuf)nativeBuffer) : new DefaultHttpContent(Unpooled.copiedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer()));
                                            } else if (message instanceof byte[]) {
                                                httpContent = new DefaultHttpContent(Unpooled.copiedBuffer((byte[])((byte[])message)));
                                            } else if (message instanceof HttpContent) {
                                                httpContent = (HttpContent)message;
                                            } else {
                                                MediaTypeCodec codec = (MediaTypeCodec)RoutingInBoundHandler.this.mediaTypeCodecRegistry.findCodec(mediaType, message.getClass()).orElse(new TextPlainCodec(RoutingInBoundHandler.this.serverConfiguration.getDefaultCharset()));
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug("Encoding emitted response object [{}] using codec: {}", message, (Object)codec);
                                                }
                                                ByteBuffer encoded = codec.encode(message, (ByteBufferFactory)byteBufferFactory);
                                                httpContent = new DefaultHttpContent((ByteBuf)encoded.asNativeBuffer());
                                            }
                                            if (!isJson || this.first) {
                                                this.first = false;
                                                return httpContent;
                                            }
                                            return HttpContentUtil.prefixComma((HttpContent)httpContent);
                                        }
                                    });
                                    if (isJson) {
                                        httpContentPublisher = Flowable.concat((Publisher)Flowable.fromCallable(HttpContentUtil::openBracket), (Publisher)httpContentPublisher, (Publisher)Flowable.fromCallable(HttpContentUtil::closeBracket));
                                    }
                                    if (mediaType.equals((Object)MediaType.TEXT_EVENT_STREAM_TYPE)) {
                                        httpContentPublisher = Publishers.onComplete((Publisher)httpContentPublisher, () -> {
                                            CompletableFuture future = new CompletableFuture();
                                            if (!this.val$request.getHeaders().isKeepAlive() && this.val$context.channel().isOpen()) {
                                                this.val$context.pipeline().writeAndFlush((Object)new DefaultLastHttpContent()).addListener(f -> {
                                                    if (f.isSuccess()) {
                                                        future.complete(null);
                                                    } else {
                                                        future.completeExceptionally(f.cause());
                                                    }
                                                });
                                            }
                                            return future;
                                        });
                                    }
                                    httpContentPublisher = Publishers.then((Publisher)httpContentPublisher, httpContent -> this.val$context.read());
                                    httpContentPublisher = Flowable.fromPublisher((Publisher)httpContentPublisher).doAfterTerminate(() -> RoutingInBoundHandler.this.cleanupRequest(this.val$context, this.val$request));
                                    DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse((io.netty.handler.codec.http.HttpResponse)RoutingInBoundHandler.this.toNettyResponse(message).getNativeResponse(), (Publisher<HttpContent>)httpContentPublisher);
                                    HttpHeaders headers = streamedResponse.headers();
                                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                                    headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
                                    if (isHttp2) {
                                        RoutingInBoundHandler.this.addHttp2StreamHeader(this.val$request, streamedResponse);
                                    }
                                    this.val$context.writeAndFlush((Object)streamedResponse);
                                    this.val$context.read();
                                }
                            }
                        } else {
                            RoutingInBoundHandler.this.encodeHttpResponse(this.val$context, this.val$request, message, body, defaultResponseMediaType);
                        }
                    } else {
                        RoutingInBoundHandler.this.writeFinalNettyResponse(message, (HttpRequest)requestReference.get(), this.val$context);
                    }
                }

                @Override
                protected void doOnError(Throwable t) {
                    NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)((Object)requestReference.get());
                    RoutingInBoundHandler.this.exceptionCaughtInternal(this.val$context, t, nettyHttpRequest, false);
                }
            });
            return null;
        });
        return route;
    }

    private Flowable<? extends MutableHttpResponse<?>> buildResultEmitter(NettyHttpRequest<?> request, AtomicReference<HttpRequest<?>> requestReference, RouteMatch<?> finalRoute, ExecutorService executor, boolean isErrorRoute, boolean skipOncePerRequest) {
        Flowable resultEmitter = Flowable.defer(() -> {
            MutableHttpResponse outgoingResponse;
            RouteMatch routeMatch = !finalRoute.isExecutable() ? this.requestArgumentSatisfier.fulfillArgumentRequirements(finalRoute, (HttpRequest)requestReference.get(), true) : finalRoute;
            boolean isSuspended = routeMatch.isSuspended();
            Object body = routeMatch.execute();
            if (body instanceof Optional) {
                body = ((Optional)body).orElse(null);
            }
            HttpRequest incomingRequest = (HttpRequest)requestReference.get();
            if (body == null) {
                if (routeMatch.isVoid()) {
                    outgoingResponse = this.forStatus(routeMatch.getAnnotationMetadata());
                    if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod())) {
                        outgoingResponse.header((CharSequence)"Content-Length", (CharSequence)HttpHeaderValues.ZERO);
                    }
                } else {
                    outgoingResponse = this.newNotFoundError(request);
                }
            } else {
                boolean isReactive;
                HttpStatus defaultHttpStatus = isErrorRoute ? HttpStatus.INTERNAL_SERVER_ERROR : HttpStatus.OK;
                boolean bl = isReactive = finalRoute.isAsyncOrReactive() || Publishers.isConvertibleToPublisher((Object)body);
                if (isReactive) {
                    boolean isCompletable;
                    Class<?> bodyClass = body.getClass();
                    boolean isSingle = this.isSingle(finalRoute, bodyClass);
                    boolean bl2 = isCompletable = !isSingle && finalRoute.isVoid() && Publishers.isCompletable(bodyClass);
                    if (isSingle || isCompletable) {
                        Single single = ((Maybe)Publishers.convertPublisher((Object)body, Maybe.class)).switchIfEmpty(NOT_FOUND_SINGLE);
                        return single.map(o -> {
                            if (o instanceof Optional) {
                                o = ((Optional)o).orElse(NOT_FOUND);
                            }
                            Object singleResponse = o == NOT_FOUND ? (isCompletable || finalRoute.isVoid() ? this.forStatus(routeMatch.getAnnotationMetadata(), HttpStatus.OK).header((CharSequence)"Content-Length", (CharSequence)HttpHeaderValues.ZERO) : this.newNotFoundError(request)) : (o instanceof HttpResponse ? this.toMutableResponse((HttpResponse)o) : this.forStatus(routeMatch.getAnnotationMetadata(), defaultHttpStatus).body(o));
                            singleResponse.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)finalRoute);
                            return singleResponse;
                        }).toFlowable();
                    }
                }
                if (body instanceof HttpStatus) {
                    outgoingResponse = HttpResponse.status((HttpStatus)((HttpStatus)body));
                } else if (isSuspended) {
                    boolean isKotlinFunctionReturnTypeUnit = routeMatch instanceof MethodBasedRouteMatch && KotlinExecutableMethodUtils.isKotlinFunctionReturnTypeUnit((ExecutableMethod)((MethodBasedRouteMatch)routeMatch).getExecutableMethod());
                    Supplier supplier = ContinuationArgumentBinder.extractContinuationCompletableFutureSupplier((HttpRequest)incomingRequest);
                    if (KotlinUtils.isKotlinCoroutineSuspended((Object)body)) {
                        return Flowable.create(arg_0 -> this.lambda$null$9((Supplier)supplier, routeMatch, defaultHttpStatus, isKotlinFunctionReturnTypeUnit, finalRoute, arg_0), (BackpressureStrategy)BackpressureStrategy.ERROR);
                    }
                    Object suspendedBody = isKotlinFunctionReturnTypeUnit ? Completable.complete() : body;
                    outgoingResponse = suspendedBody instanceof HttpResponse ? this.toMutableResponse((HttpResponse)suspendedBody) : this.forStatus(routeMatch.getAnnotationMetadata(), defaultHttpStatus).body(suspendedBody);
                } else {
                    outgoingResponse = body instanceof HttpResponse ? this.toMutableResponse((HttpResponse)body) : this.forStatus(routeMatch.getAnnotationMetadata(), defaultHttpStatus).body(body);
                }
                if (incomingRequest != null && incomingRequest.getMethod().equals((Object)HttpMethod.HEAD)) {
                    Object o2 = outgoingResponse.getBody().orElse(null);
                    if (o2 instanceof ReferenceCounted) {
                        ((ReferenceCounted)o2).release();
                    }
                    outgoingResponse.body(null);
                }
            }
            outgoingResponse.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)finalRoute);
            return Flowable.just(outgoingResponse);
        });
        return this.filterPublisher(requestReference, (Publisher<MutableHttpResponse<?>>)resultEmitter, executor, skipOncePerRequest);
    }

    private void encodeHttpResponse(ChannelHandlerContext context, NettyHttpRequest<?> nettyRequest, MutableHttpResponse<?> response, Object body, MediaType defaultResponseMediaType) {
        boolean isNotHead;
        boolean bl = isNotHead = nettyRequest.getMethod() != HttpMethod.HEAD;
        if (isNotHead && body instanceof Writable) {
            Writable writable = (Writable)body;
            this.getIoExecutor().execute(() -> {
                ByteBuf byteBuf = context.alloc().ioBuffer(128);
                ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
                try {
                    writable.writeTo((OutputStream)outputStream, nettyRequest.getCharacterEncoding());
                    response.body((Object)byteBuf);
                    if (!response.getHeaders().contains("Content-Type")) {
                        response.header((CharSequence)"Content-Type", (CharSequence)defaultResponseMediaType);
                    }
                    this.writeFinalNettyResponse(response, nettyRequest, context);
                }
                catch (IOException e) {
                    this.exceptionCaughtInternal(context, e, nettyRequest, false);
                }
            });
        } else {
            try {
                if (isNotHead) {
                    this.encodeResponseBody(context, nettyRequest, response, body, defaultResponseMediaType);
                }
                this.writeFinalNettyResponse(response, nettyRequest, context);
            }
            catch (Exception e) {
                this.exceptionCaughtInternal(context, e, nettyRequest, false);
            }
        }
    }

    @Nullable
    private RouteMatch<Object> findStatusRoute(HttpRequest<?> incomingRequest, HttpStatus status, RouteMatch<?> finalRoute) {
        Class<?> declaringType = this.getDeclaringType(finalRoute);
        RouteMatch statusRoute = null;
        if (declaringType != null) {
            statusRoute = this.router.findStatusRoute(declaringType, status, incomingRequest).orElseGet(() -> this.router.findStatusRoute(status, incomingRequest).orElse(null));
        }
        return statusRoute;
    }

    private void encodeResponseBody(ChannelHandlerContext context, HttpRequest<?> request, MutableHttpResponse<?> message, Object body, MediaType defaultResponseMediaType) {
        MediaType responseMediaType;
        if (body == null) {
            return;
        }
        MediaType specifiedMediaType = message.getContentType().orElse(null);
        MediaType mediaType = responseMediaType = specifiedMediaType != null ? specifiedMediaType : defaultResponseMediaType;
        if (body instanceof CharSequence) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])body.toString().getBytes(message.getCharacterEncoding()));
            this.setResponseBody(message, responseMediaType, byteBuf);
        } else if (body instanceof byte[]) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])body));
            this.setResponseBody(message, responseMediaType, byteBuf);
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            if (nativeBuffer instanceof ByteBuf) {
                this.setResponseBody(message, responseMediaType, (ByteBuf)nativeBuffer);
            } else if (nativeBuffer instanceof java.nio.ByteBuffer) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer((java.nio.ByteBuffer)((java.nio.ByteBuffer)nativeBuffer));
                this.setResponseBody(message, responseMediaType, byteBuf);
            }
        } else if (body instanceof ByteBuf) {
            this.setResponseBody(message, responseMediaType, (ByteBuf)body);
        } else {
            Optional<NettyCustomizableResponseTypeHandler> typeHandler = this.customizableResponseTypeHandlerRegistry.findTypeHandler(body.getClass());
            if (typeHandler.isPresent()) {
                NettyCustomizableResponseTypeHandler th = typeHandler.get();
                this.setBodyContent(message, new NettyCustomizableResponseTypeHandlerInvoker(th, body));
            } else if (specifiedMediaType != null) {
                Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(responseMediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = (MediaTypeCodec)registeredCodec.get();
                    if (!message.getHeaders().contains("Content-Type")) {
                        message.header((CharSequence)"Content-Type", (CharSequence)responseMediaType);
                    }
                    this.encodeBodyWithCodec(message, body, codec, responseMediaType, context, request);
                }
            } else {
                Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(defaultResponseMediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = (MediaTypeCodec)registeredCodec.get();
                    if (!message.getHeaders().contains("Content-Type")) {
                        message.header((CharSequence)"Content-Type", (CharSequence)responseMediaType);
                    }
                    this.encodeBodyWithCodec(message, body, codec, responseMediaType, context, request);
                } else {
                    if (!message.getHeaders().contains("Content-Type")) {
                        message.header((CharSequence)"Content-Type", (CharSequence)responseMediaType);
                    }
                    TextPlainCodec defaultCodec = new TextPlainCodec(this.serverConfiguration.getDefaultCharset());
                    this.encodeBodyWithCodec(message, body, (MediaTypeCodec)defaultCodec, responseMediaType, context, request);
                }
            }
        }
    }

    @Nullable
    private Class<?> getDeclaringType(RouteMatch<?> route) {
        if (route instanceof MethodBasedRouteMatch) {
            return ((MethodBasedRouteMatch)route).getDeclaringType();
        }
        return null;
    }

    private MediaType resolveDefaultResponseContentType(NettyHttpRequest<?> request, RouteMatch<?> finalRoute) {
        MediaType mt;
        List producesList = finalRoute.getProduces();
        Iterator i = request.accept().iterator();
        if (i.hasNext() && producesList.contains(mt = (MediaType)i.next())) {
            return mt;
        }
        Iterator produces = producesList.iterator();
        MediaType defaultResponseMediaType = produces.hasNext() ? (MediaType)produces.next() : MediaType.APPLICATION_JSON_TYPE;
        return defaultResponseMediaType;
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, HttpRequest<?> request, ChannelHandlerContext context) {
        Object body;
        boolean isHttp2;
        io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
        HttpHeaders nettyHeaders = nettyResponse.headers();
        HttpStatus httpStatus = message.status();
        HttpVersion httpVersion = request.getHttpVersion();
        boolean bl = isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        if (!isHttp2 && !nettyHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            boolean expectKeepAlive;
            boolean bl2 = expectKeepAlive = nettyResponse.protocolVersion().isKeepAliveDefault() || request.getHeaders().isKeepAlive();
            if (!expectKeepAlive || httpStatus.getCode() > 499) {
                nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else {
                nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
        }
        if ((body = message.body()) instanceof NettyCustomizableResponseTypeHandlerInvoker) {
            NettyCustomizableResponseTypeHandlerInvoker handler = (NettyCustomizableResponseTypeHandlerInvoker)body;
            handler.invoke(request, message, context);
        } else {
            if (!nettyHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !nettyHeaders.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                nettyHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            NettyHttpRequest nettyHttpRequest = (NettyHttpRequest)request;
            if (isHttp2) {
                this.addHttp2StreamHeader(request, nettyResponse);
            }
            context.writeAndFlush((Object)nettyResponse).addListener(future -> {
                try {
                    Throwable throwable;
                    if (!future.isSuccess() && !((throwable = future.cause()) instanceof ClosedChannelException)) {
                        Http2Exception.StreamException se;
                        if (throwable instanceof Http2Exception.StreamException && (se = (Http2Exception.StreamException)throwable).error() == Http2Error.STREAM_CLOSED) {
                            return;
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error writing final response: " + throwable.getMessage(), throwable);
                        }
                    }
                }
                finally {
                    this.cleanupRequest(context, nettyHttpRequest);
                    context.read();
                }
            });
        }
    }

    private void addHttp2StreamHeader(HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse) {
        String streamId = (String)request.getHeaders().get((CharSequence)AbstractNettyHttpRequest.STREAM_ID);
        if (streamId != null) {
            nettyResponse.headers().set((CharSequence)AbstractNettyHttpRequest.STREAM_ID, (Object)streamId);
        }
    }

    private MutableHttpResponse<?> toMutableResponse(HttpResponse<?> message) {
        MutableHttpResponse mutableHttpResponse;
        if (message instanceof MutableHttpResponse) {
            mutableHttpResponse = (MutableHttpResponse)message;
        } else {
            HttpStatus httpStatus = message.status();
            mutableHttpResponse = HttpResponse.status((HttpStatus)httpStatus, (String)httpStatus.getReason());
            mutableHttpResponse.body(message.body());
            message.getHeaders().forEach((name, value) -> {
                for (String val : value) {
                    mutableHttpResponse.header((CharSequence)name, (CharSequence)val);
                }
            });
            mutableHttpResponse.getAttributes().putAll((ConvertibleValues)message.getAttributes());
        }
        return mutableHttpResponse;
    }

    @NotNull
    private NettyMutableHttpResponse<?> toNettyResponse(HttpResponse<?> message) {
        NettyMutableHttpResponse nettyHttpResponse;
        if (message instanceof NettyMutableHttpResponse) {
            nettyHttpResponse = (NettyMutableHttpResponse)message;
        } else {
            HttpStatus httpStatus = message.status();
            HttpResponseStatus nettyStatus = HttpResponseStatus.valueOf((int)httpStatus.getCode(), (String)httpStatus.getReason());
            Object body = message.body();
            DefaultFullHttpResponse nettyResponse = body instanceof ByteBuf ? new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, nettyStatus, (ByteBuf)body) : new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, nettyStatus);
            HttpHeaders nettyHeaders = nettyResponse.headers();
            message.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)nettyHeaders).set(arg_0, arg_1));
            nettyHttpResponse = new NettyMutableHttpResponse((FullHttpResponse)nettyResponse, ConversionService.SHARED);
        }
        return nettyHttpResponse;
    }

    private MutableHttpResponse<?> encodeBodyWithCodec(MutableHttpResponse<?> response, Object body, MediaTypeCodec codec, MediaType mediaType, ChannelHandlerContext context, HttpRequest<?> request) {
        try {
            ByteBuf byteBuf = this.encodeBodyAsByteBuf(body, codec, context, request);
            this.setResponseBody(response, mediaType, byteBuf);
            return response;
        }
        catch (LinkageError e) {
            throw new InternalServerException("Fatal error encoding bytebuf: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setResponseBody(MutableHttpResponse<?> response, MediaType mediaType, ByteBuf byteBuf) {
        int len = byteBuf.readableBytes();
        MutableHttpHeaders headers = response.getHeaders();
        if (!headers.contains("Content-Type")) {
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)mediaType);
        }
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(len));
        this.setBodyContent(response, byteBuf);
    }

    private MutableHttpResponse<?> setBodyContent(MutableHttpResponse response, Object bodyContent) {
        MutableHttpResponse res = response.body(bodyContent);
        return res;
    }

    private ByteBuf encodeBodyAsByteBuf(Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        ByteBuf byteBuf;
        if (body instanceof ByteBuf) {
            byteBuf = (ByteBuf)body;
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            byteBuf = nativeBuffer instanceof ByteBuf ? (ByteBuf)nativeBuffer : Unpooled.wrappedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer());
        } else if (body instanceof byte[]) {
            byteBuf = Unpooled.wrappedBuffer((byte[])((byte[])body));
        } else if (body instanceof Writable) {
            byteBuf = context.alloc().ioBuffer(128);
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            Writable writable = (Writable)body;
            try {
                writable.writeTo((OutputStream)outputStream, request.getCharacterEncoding());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Encoding emitted response object [{}] using codec: {}", body, (Object)codec);
            }
            byteBuf = (ByteBuf)codec.encode(body, (ByteBufferFactory)new NettyByteBufferFactory(context.alloc())).asNativeBuffer();
        }
        return byteBuf;
    }

    private MutableHttpResponse<Object> forStatus(AnnotationMetadata annotationMetadata) {
        return this.forStatus(annotationMetadata, HttpStatus.OK);
    }

    private MutableHttpResponse<Object> forStatus(AnnotationMetadata annotationMetadata, HttpStatus defaultStatus) {
        return HttpResponse.status((HttpStatus)annotationMetadata.enumValue(Status.class, HttpStatus.class).orElse(defaultStatus));
    }

    private Flowable<? extends MutableHttpResponse<?>> filterPublisher(final AtomicReference<HttpRequest<?>> requestReference, Publisher<MutableHttpResponse<?>> routePublisher, @Nullable ExecutorService executor, boolean skipOncePerRequest) {
        Publisher finalPublisher;
        final ArrayList<Object> filters = new ArrayList<Object>(this.router.findFilters(requestReference.get()));
        if (skipOncePerRequest) {
            filters.removeIf(filter -> filter instanceof OncePerRequestHttpServerFilter);
        }
        if (!filters.isEmpty()) {
            Publisher resultingPublisher;
            filters.add((req, chain) -> {
                if (executor != null) {
                    if (routePublisher instanceof Flowable) {
                        return ((Flowable)routePublisher).subscribeOn(Schedulers.from((Executor)executor));
                    }
                    return Flowable.fromPublisher((Publisher)routePublisher).subscribeOn(Schedulers.from((Executor)executor));
                }
                return routePublisher;
            });
            final AtomicInteger integer = new AtomicInteger();
            final int len = filters.size();
            ServerFilterChain filterChain = new ServerFilterChain(){

                public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
                    int pos = integer.incrementAndGet();
                    if (pos > len) {
                        throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                    }
                    HttpFilter httpFilter = (HttpFilter)filters.get(pos);
                    return httpFilter.doFilter(requestReference.getAndSet(request), (FilterChain)this);
                }
            };
            HttpFilter httpFilter = (HttpFilter)filters.get(0);
            finalPublisher = resultingPublisher = httpFilter.doFilter(requestReference.get(), (FilterChain)filterChain);
        } else {
            finalPublisher = routePublisher;
        }
        if (finalPublisher instanceof Flowable) {
            return (Flowable)finalPublisher;
        }
        return Flowable.fromPublisher(finalPublisher);
    }

    private void writeDefaultErrorResponse(ChannelHandlerContext ctx, NettyHttpRequest nettyHttpRequest, Throwable cause, boolean skipOncePerRequest) {
        this.logException(cause);
        JsonError body = new JsonError("Internal Server Error: " + cause.getMessage());
        MutableHttpResponse error = HttpResponse.serverError().body((Object)body);
        this.filterAndEncodeResponse(ctx, nettyHttpRequest, nettyHttpRequest, (MutableHttpResponse<Object>)error, MediaType.APPLICATION_JSON_TYPE, skipOncePerRequest);
    }

    private void logException(Throwable cause) {
        String message = cause.getMessage();
        if (cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
            }
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Unexpected error occurred: " + cause.getMessage(), cause);
        }
    }

    private void applyConfiguredHeaders(MutableHttpHeaders headers) {
        if (this.serverConfiguration.isDateHeader() && !headers.contains("Date")) {
            headers.date(LocalDateTime.now());
        }
        if (this.serverHeader != null && !headers.contains("Server")) {
            headers.add((CharSequence)"Server", (CharSequence)this.serverHeader);
        }
    }

    private /* synthetic */ void lambda$null$9(Supplier supplier, RouteMatch routeMatch, HttpStatus defaultHttpStatus, boolean isKotlinFunctionReturnTypeUnit, RouteMatch finalRoute, FlowableEmitter emitter) throws Exception {
        CompletableFuture f = (CompletableFuture)supplier.get();
        f.whenComplete((o, throwable) -> {
            if (throwable != null) {
                emitter.onError(throwable);
            } else {
                MutableHttpResponse response;
                if (o instanceof HttpResponse) {
                    response = this.toMutableResponse((HttpResponse)o);
                } else {
                    response = this.forStatus(routeMatch.getAnnotationMetadata(), defaultHttpStatus);
                    if (!isKotlinFunctionReturnTypeUnit) {
                        response = response.body(o);
                    }
                }
                response.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, (Object)finalRoute);
                emitter.onNext((Object)response);
                emitter.onComplete();
            }
        });
    }

    private static class NettyCustomizableResponseTypeHandlerInvoker {
        final NettyCustomizableResponseTypeHandler handler;
        final Object body;

        NettyCustomizableResponseTypeHandlerInvoker(NettyCustomizableResponseTypeHandler handler, Object body) {
            this.handler = handler;
            this.body = body;
        }

        void invoke(HttpRequest<?> request, MutableHttpResponse response, ChannelHandlerContext channelHandlerContext) {
            this.handler.handle(this.body, request, response, channelHandlerContext);
        }
    }
}

