/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.server.netty.multipart.NettyFileUploadInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;

@Internal
public class NettyCompletedFileUpload
implements CompletedFileUpload {
    private final FileUpload fileUpload;
    private final boolean controlRelease;

    public NettyCompletedFileUpload(FileUpload fileUpload) {
        this(fileUpload, true);
    }

    public NettyCompletedFileUpload(FileUpload fileUpload, boolean controlRelease) {
        this.fileUpload = fileUpload;
        this.controlRelease = controlRelease;
        if (controlRelease) {
            fileUpload.retain();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.fileUpload.isInMemory()) {
            ByteBuf byteBuf = this.fileUpload.getByteBuf();
            if (byteBuf == null) {
                throw new IOException("The input stream has already been released");
            }
            return new ByteBufInputStream(byteBuf, this.controlRelease);
        }
        File file = this.fileUpload.getFile();
        if (file == null) {
            throw new IOException("The input stream has already been released");
        }
        return new NettyFileUploadInputStream(this.fileUpload, this.controlRelease);
    }

    public byte[] getBytes() throws IOException {
        ByteBuf byteBuf = this.fileUpload.getByteBuf();
        if (byteBuf == null) {
            throw new IOException("The bytes have already been released");
        }
        try {
            byte[] byArray = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            return byArray;
        }
        finally {
            if (this.controlRelease) {
                byteBuf.release();
            }
        }
    }

    public ByteBuffer getByteBuffer() throws IOException {
        ByteBuf byteBuf = this.fileUpload.getByteBuf();
        if (byteBuf == null) {
            throw new IOException("The byte buffer has already been released");
        }
        try {
            ByteBuffer byteBuffer = byteBuf.nioBuffer();
            return byteBuffer;
        }
        finally {
            if (this.controlRelease) {
                byteBuf.release();
            }
        }
    }

    public Optional<MediaType> getContentType() {
        return Optional.of(MediaType.of((CharSequence)this.fileUpload.getContentType()));
    }

    public String getName() {
        return this.fileUpload.getName();
    }

    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    public long getSize() {
        return this.fileUpload.length();
    }

    public long getDefinedSize() {
        return this.fileUpload.definedLength();
    }

    public boolean isComplete() {
        return this.fileUpload.isCompleted();
    }

    public void discard() {
        this.fileUpload.release();
    }
}

