/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.binders.BasicAuthArgumentBinder;
import io.micronaut.http.server.netty.binders.CompletableFutureBodyBinder;
import io.micronaut.http.server.netty.binders.MaybeBodyBinder;
import io.micronaut.http.server.netty.binders.ObservableBodyBinder;
import io.micronaut.http.server.netty.binders.PublisherBodyBinder;
import io.micronaut.http.server.netty.binders.SingleBodyBinder;
import io.micronaut.http.server.netty.multipart.MultipartBodyArgumentBinder;
import io.reactivex.Flowable;
import javax.inject.Singleton;

@Singleton
@Internal
@Requires(classes={Flowable.class})
class NettyBinderRegistrar
implements BeanCreatedEventListener<RequestBinderRegistry> {
    private final ConversionService<?> conversionService;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final BeanLocator beanLocator;
    private final BeanProvider<HttpServerConfiguration> httpServerConfiguration;

    NettyBinderRegistrar(@Nullable ConversionService<?> conversionService, HttpContentProcessorResolver httpContentProcessorResolver, BeanLocator beanLocator, BeanProvider<HttpServerConfiguration> httpServerConfiguration) {
        this.conversionService = conversionService == null ? ConversionService.SHARED : conversionService;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.beanLocator = beanLocator;
        this.httpServerConfiguration = httpServerConfiguration;
    }

    public RequestBinderRegistry onCreated(BeanCreatedEvent<RequestBinderRegistry> event) {
        RequestBinderRegistry registry = (RequestBinderRegistry)event.getBean();
        registry.addRequestArgumentBinder((ArgumentBinder)new BasicAuthArgumentBinder());
        registry.addRequestArgumentBinder((ArgumentBinder)new MaybeBodyBinder(this.conversionService, this.httpContentProcessorResolver));
        registry.addRequestArgumentBinder((ArgumentBinder)new ObservableBodyBinder(this.conversionService, this.httpContentProcessorResolver));
        registry.addRequestArgumentBinder((ArgumentBinder)new PublisherBodyBinder(this.conversionService, this.httpContentProcessorResolver));
        registry.addRequestArgumentBinder((ArgumentBinder)new SingleBodyBinder(this.conversionService, this.httpContentProcessorResolver));
        registry.addRequestArgumentBinder((ArgumentBinder)new CompletableFutureBodyBinder(this.httpContentProcessorResolver, this.conversionService));
        registry.addRequestArgumentBinder((ArgumentBinder)new MultipartBodyArgumentBinder(this.beanLocator, this.httpServerConfiguration));
        return registry;
    }
}

