/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.websocket;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketHandler;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.micronaut.websocket.annotation.ServerWebSocket;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NettyServerWebSocketUpgradeHandler
extends SimpleChannelInboundHandler<NettyHttpRequest<?>> {
    public static final String ID = "websocket-upgrade-handler";
    public static final String SCHEME_WEBSOCKET = "ws://";
    public static final String SCHEME_SECURE_WEBSOCKET = "wss://";
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerWebSocketUpgradeHandler.class);
    private static final AsciiString WEB_SOCKET_HEADER_VALUE = AsciiString.cached((String)"websocket");
    private final Router router;
    private final RequestBinderRegistry binderRegistry;
    private final WebSocketBeanRegistry webSocketBeanRegistry;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final WebSocketSessionRepository webSocketSessionRepository;
    private final ApplicationEventPublisher eventPublisher;
    private WebSocketServerHandshaker handshaker;

    public NettyServerWebSocketUpgradeHandler(WebSocketSessionRepository webSocketSessionRepository, Router router, RequestBinderRegistry binderRegistry, WebSocketBeanRegistry webSocketBeanRegistry, MediaTypeCodecRegistry mediaTypeCodecRegistry, ApplicationEventPublisher eventPublisher) {
        this.router = router;
        this.binderRegistry = binderRegistry;
        this.webSocketBeanRegistry = webSocketBeanRegistry;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.webSocketSessionRepository = webSocketSessionRepository;
        this.eventPublisher = eventPublisher;
    }

    public boolean acceptInboundMessage(Object msg) {
        return msg instanceof NettyHttpRequest && this.isWebSocketUpgrade((NettyHttpRequest)((Object)msg));
    }

    private boolean isWebSocketUpgrade(@NonNull NettyHttpRequest<?> request) {
        HttpHeaders headers = request.getHeaders();
        String connectValue = headers.get((CharSequence)HttpHeaderNames.CONNECTION, String.class).orElse("").toLowerCase(Locale.ENGLISH);
        return connectValue.contains((CharSequence)HttpHeaderValues.UPGRADE) && WEB_SOCKET_HEADER_VALUE.toString().equalsIgnoreCase((String)headers.get((CharSequence)HttpHeaderNames.UPGRADE));
    }

    protected final void channelRead0(ChannelHandlerContext ctx, NettyHttpRequest<?> msg) {
        Optional<UriRouteMatch> routeMatch = this.router.find(HttpMethod.GET, (CharSequence)msg.getUri().toString(), msg).filter(rm -> rm.isAnnotationPresent(OnMessage.class) || rm.isAnnotationPresent(OnOpen.class)).findFirst();
        if (routeMatch.isPresent()) {
            Flowable finalPublisher;
            UriRouteMatch rm2 = routeMatch.get();
            msg.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, rm2);
            ArrayList<HttpServerFilter> filters = this.router.findFilters(msg);
            final AtomicReference requestReference = new AtomicReference(msg);
            MutableHttpResponse proceed = HttpResponse.ok();
            Flowable routePublisher = Flowable.create(emitter -> {
                emitter.onNext((Object)proceed);
                emitter.onComplete();
            }, (BackpressureStrategy)BackpressureStrategy.ERROR);
            if (!filters.isEmpty()) {
                filters = new ArrayList<HttpServerFilter>(filters);
                filters.add((arg_0, arg_1) -> NettyServerWebSocketUpgradeHandler.lambda$channelRead0$2((Publisher)routePublisher, arg_0, arg_1));
                final AtomicInteger integer = new AtomicInteger();
                final int len = filters.size();
                final ArrayList<HttpServerFilter> finalFilters = filters;
                ServerFilterChain filterChain = new ServerFilterChain(){

                    public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
                        int pos = integer.incrementAndGet();
                        if (pos > len) {
                            throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                        }
                        HttpFilter httpFilter = (HttpFilter)finalFilters.get(pos);
                        return httpFilter.doFilter(requestReference.getAndSet(request), (FilterChain)this);
                    }
                };
                HttpFilter httpFilter = (HttpFilter)filters.get(0);
                Publisher resultingPublisher = httpFilter.doFilter((HttpRequest)requestReference.get(), (FilterChain)filterChain);
                finalPublisher = resultingPublisher;
            } else {
                finalPublisher = routePublisher;
            }
            Channel channel = ctx.channel();
            Single.fromPublisher((Publisher)finalPublisher).subscribeOn(Schedulers.from((Executor)channel.eventLoop())).subscribe((actualResponse, throwable) -> {
                if (throwable != null) {
                    ctx.fireExceptionCaught(throwable);
                } else if (actualResponse == proceed) {
                    WebSocketBean webSocketBean = this.webSocketBeanRegistry.getWebSocket(rm2.getTarget().getClass());
                    this.handleHandshake(ctx, msg, (WebSocketBean<?>)webSocketBean, (MutableHttpResponse<?>)actualResponse);
                    ChannelPipeline pipeline = ctx.pipeline();
                    try {
                        pipeline.remove("http-streams-codec");
                        pipeline.remove((ChannelHandler)this);
                        ChannelHandler accessLoggerHandler = pipeline.get("http-access-logger");
                        if (accessLoggerHandler != null) {
                            pipeline.remove(accessLoggerHandler);
                        }
                        NettyServerWebSocketHandler webSocketHandler = new NettyServerWebSocketHandler(this.webSocketSessionRepository, this.handshaker, msg, (UriRouteMatch<Object, Object>)rm2, webSocketBean, this.binderRegistry, this.mediaTypeCodecRegistry, this.eventPublisher, ctx);
                        pipeline.addAfter("wsdecoder", "websocket-handler", (ChannelHandler)webSocketHandler);
                    }
                    catch (Throwable e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error opening WebSocket: " + e.getMessage(), e);
                        }
                        ctx.writeAndFlush((Object)new CloseWebSocketFrame(CloseReason.INTERNAL_ERROR.getCode(), CloseReason.INTERNAL_ERROR.getReason()));
                    }
                } else {
                    ctx.writeAndFlush(actualResponse);
                }
            });
        } else {
            ctx.fireExceptionCaught((Throwable)new HttpStatusException(HttpStatus.NOT_FOUND, "WebSocket Not Found"));
        }
    }

    protected ChannelFuture handleHandshake(ChannelHandlerContext ctx, NettyHttpRequest req, WebSocketBean<?> webSocketBean, MutableHttpResponse<?> response) {
        io.netty.handler.codec.http.HttpHeaders nettyHeaders;
        int maxFramePayloadLength = webSocketBean.messageMethod().map(m -> m.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
        String subprotocols = webSocketBean.getBeanDefinition().stringValue(ServerWebSocket.class, "subprotocols").filter(s -> !StringUtils.isEmpty((CharSequence)s)).orElse(null);
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(ctx, req), subprotocols, true, maxFramePayloadLength);
        this.handshaker = wsFactory.newHandshaker(req.getNativeRequest());
        MutableHttpHeaders headers = response.getHeaders();
        if (headers instanceof NettyHttpHeaders) {
            nettyHeaders = ((NettyHttpHeaders)headers).getNettyHeaders();
        } else {
            nettyHeaders = new DefaultHttpHeaders();
            for (Map.Entry entry : headers) {
                nettyHeaders.add((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        Channel channel = ctx.channel();
        if (this.handshaker == null) {
            return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channel);
        }
        return this.handshaker.handshake(channel, req.getNativeRequest(), nettyHeaders, channel.newPromise());
    }

    protected String getWebSocketURL(ChannelHandlerContext ctx, HttpRequest req) {
        boolean isSecure = ctx.pipeline().get(SslHandler.class) != null;
        return (isSecure ? SCHEME_SECURE_WEBSOCKET : SCHEME_WEBSOCKET) + (String)req.getHeaders().get((CharSequence)HttpHeaderNames.HOST) + req.getUri();
    }

    private static /* synthetic */ Publisher lambda$channelRead0$2(Publisher routePublisher, HttpRequest req, ServerFilterChain chain) {
        return routePublisher;
    }
}

