/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.websocket;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.netty.websocket.AbstractNettyWebSocketHandler;
import io.micronaut.http.netty.websocket.NettyWebSocketSession;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.event.WebSocketMessageProcessedEvent;
import io.micronaut.websocket.event.WebSocketSessionClosedEvent;
import io.micronaut.websocket.event.WebSocketSessionOpenEvent;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Internal
public class NettyServerWebSocketHandler
extends AbstractNettyWebSocketHandler {
    public static final String ID = "websocket-handler";
    private final NettyEmbeddedServices nettyEmbeddedServices;

    NettyServerWebSocketHandler(NettyEmbeddedServices nettyEmbeddedServices, WebSocketSessionRepository webSocketSessionRepository, WebSocketServerHandshaker handshaker, WebSocketBean<?> webSocketBean, HttpRequest<?> request, UriRouteMatch<Object, Object> routeMatch, ChannelHandlerContext ctx) {
        block2: {
            super(ctx, nettyEmbeddedServices.getRequestArgumentSatisfier().getBinderRegistry(), nettyEmbeddedServices.getMediaTypeCodecRegistry(), webSocketBean, request, routeMatch.getVariableValues(), handshaker.version(), handshaker.selectedSubprotocol(), webSocketSessionRepository);
            this.nettyEmbeddedServices = nettyEmbeddedServices;
            request.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, routeMatch);
            request.setAttribute((CharSequence)HttpAttributes.ROUTE, (Object)routeMatch.getRoute());
            ApplicationEventPublisher<WebSocketSessionOpenEvent> eventPublisher = nettyEmbeddedServices.getEventPublisher(WebSocketSessionOpenEvent.class);
            try {
                eventPublisher.publishEvent((Object)new WebSocketSessionOpenEvent((WebSocketSession)this.session));
            }
            catch (Exception e) {
                if (!this.LOG.isErrorEnabled()) break block2;
                this.LOG.error("Error publishing WebSocket opened event: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.writeCloseFrameAndTerminate(ctx, CloseReason.GOING_AWAY);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public boolean acceptInboundMessage(Object msg) {
        return msg instanceof WebSocketFrame;
    }

    protected NettyWebSocketSession createWebSocketSession(final ChannelHandlerContext ctx) {
        String id = (String)this.originatingRequest.getHeaders().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY);
        Channel channel = ctx.channel();
        NettyWebSocketSession session = new NettyWebSocketSession(id, channel, this.originatingRequest, this.mediaTypeCodecRegistry, this.webSocketVersion.toHttpHeaderValue(), ctx.pipeline().get(SslHandler.class) != null){
            private final ConvertibleValues<Object> uriVars;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.uriVars = ConvertibleValues.of((Map)NettyServerWebSocketHandler.this.uriVariables);
            }

            public Optional<String> getSubprotocol() {
                return Optional.ofNullable(NettyServerWebSocketHandler.this.subProtocol);
            }

            public Set<? extends WebSocketSession> getOpenSessions() {
                return NettyServerWebSocketHandler.this.webSocketSessionRepository.getChannelGroup().stream().flatMap(ch -> {
                    NettyWebSocketSession s = (NettyWebSocketSession)ch.attr(NettyWebSocketSession.WEB_SOCKET_SESSION_KEY).get();
                    if (s != null && s.isOpen()) {
                        return Stream.of(s);
                    }
                    return Stream.empty();
                }).collect(Collectors.toSet());
            }

            public void close(CloseReason closeReason) {
                super.close(closeReason);
                NettyServerWebSocketHandler.this.webSocketSessionRepository.removeChannel(ctx.channel());
            }

            public Optional<Principal> getUserPrincipal() {
                return NettyServerWebSocketHandler.this.originatingRequest.getAttribute((CharSequence)HttpAttributes.PRINCIPAL, Principal.class);
            }

            public ConvertibleValues<Object> getUriVariables() {
                return this.uriVars;
            }
        };
        this.webSocketSessionRepository.addChannel(channel);
        return session;
    }

    protected Publisher<?> instrumentPublisher(ChannelHandlerContext ctx, Object result) {
        Publisher actual = (Publisher)Publishers.convertPublisher((Object)result, Publisher.class);
        Publisher traced = subscriber -> ServerRequestContext.with((HttpRequest)this.originatingRequest, () -> actual.subscribe((Subscriber)new Subscriber<Object>(){

            public void onSubscribe(Subscription s) {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> subscriber.onSubscribe(s));
            }

            public void onNext(Object object) {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> subscriber.onNext(object));
            }

            public void onError(Throwable t) {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> subscriber.onError(t));
            }

            public void onComplete() {
                ServerRequestContext.with((HttpRequest)NettyServerWebSocketHandler.this.originatingRequest, () -> ((Subscriber)subscriber).onComplete());
            }
        }));
        return Flux.from((Publisher)traced).subscribeOn(Schedulers.fromExecutorService((ExecutorService)ctx.channel().eventLoop()));
    }

    protected Object invokeExecutable(BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> messageHandler) {
        return ServerRequestContext.with((HttpRequest)this.originatingRequest, () -> boundExecutable.invoke(messageHandler.getTarget()));
    }

    protected void messageHandled(ChannelHandlerContext ctx, NettyWebSocketSession session, Object message) {
        ctx.executor().execute(() -> {
            block2: {
                try {
                    this.nettyEmbeddedServices.getEventPublisher(WebSocketMessageProcessedEvent.class).publishEvent((Object)new WebSocketMessageProcessedEvent((WebSocketSession)session, message));
                }
                catch (Exception e) {
                    if (!this.LOG.isErrorEnabled()) break block2;
                    this.LOG.error("Error publishing WebSocket message processed event: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        block3: {
            Channel channel = ctx.channel();
            channel.attr(NettyWebSocketSession.WEB_SOCKET_SESSION_KEY).set(null);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Removing WebSocket Server session: " + this.session);
            }
            this.webSocketSessionRepository.removeChannel(channel);
            try {
                this.nettyEmbeddedServices.getEventPublisher(WebSocketSessionClosedEvent.class).publishEvent((Object)new WebSocketSessionClosedEvent((WebSocketSession)this.session));
            }
            catch (Exception e) {
                if (!this.LOG.isErrorEnabled()) break block3;
                this.LOG.error("Error publishing WebSocket closed event: " + e.getMessage(), (Throwable)e);
            }
        }
        super.handlerRemoved(ctx);
    }
}

