/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.PushCapableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.netty.IdentityWrapper;
import io.micronaut.http.server.netty.ServerAttributeKeys;
import io.micronaut.web.router.RouteMatch;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@Internal
public class NettyHttpRequest<T>
extends AbstractNettyHttpRequest<T>
implements HttpRequest<T>,
PushCapableHttpRequest<T> {
    private static final io.netty.handler.codec.http.HttpHeaders SERVER_PUSH_EXCLUDE_HEADERS = new DefaultHttpHeaders();
    private final NettyHttpHeaders headers;
    private final ChannelHandlerContext channelHandlerContext;
    private final HttpServerConfiguration serverConfiguration;
    private MutableConvertibleValues<Object> attributes;
    private NettyCookies nettyCookies;
    private List<ByteBufHolder> receivedContent = new ArrayList<ByteBufHolder>();
    private Map<IdentityWrapper, AbstractHttpData> receivedData = new LinkedHashMap<IdentityWrapper, AbstractHttpData>();
    private Supplier<Optional<T>> body;
    private RouteMatch<?> matchedRoute;
    private boolean bodyRequired;
    private final BodyConvertor bodyConvertor = this.newBodyConvertor();

    public NettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, ChannelHandlerContext ctx, ConversionService environment, HttpServerConfiguration serverConfiguration) {
        super(nettyRequest, environment);
        Objects.requireNonNull(nettyRequest, "Netty request cannot be null");
        Objects.requireNonNull(ctx, "ChannelHandlerContext cannot be null");
        Objects.requireNonNull(environment, "Environment cannot be null");
        Channel channel = ctx.channel();
        if (channel != null) {
            channel.attr(ServerAttributeKeys.REQUEST_KEY).set((Object)this);
        }
        this.serverConfiguration = serverConfiguration;
        this.channelHandlerContext = ctx;
        this.headers = new NettyHttpHeaders(nettyRequest.headers(), this.conversionService);
        this.body = SupplierUtil.memoizedNonEmpty(() -> Optional.ofNullable(this.buildBody()));
    }

    @Internal
    public final void prepareHttp2ResponseIfNecessary(@NonNull HttpResponse finalResponse) {
        io.netty.handler.codec.http.HttpHeaders nativeHeaders;
        String streamId;
        boolean isHttp2;
        HttpVersion httpVersion = this.getHttpVersion();
        boolean bl = isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        if (isHttp2 && (streamId = (nativeHeaders = this.nettyRequest.headers()).get((CharSequence)STREAM_ID)) != null) {
            finalResponse.headers().set((CharSequence)STREAM_ID, (Object)streamId);
        }
    }

    public MutableHttpRequest<T> mutate() {
        return new NettyMutableHttpRequest();
    }

    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        return Optional.ofNullable(this.getAttributes().getValue((CharSequence)Objects.requireNonNull(name, "Name cannot be null").toString()));
    }

    public String toString() {
        return this.getMethodName() + " " + this.getUri();
    }

    public io.netty.handler.codec.http.HttpRequest getNativeRequest() {
        return this.nettyRequest;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookies getCookies() {
        NettyCookies cookies = this.nettyCookies;
        if (cookies == null) {
            NettyHttpRequest nettyHttpRequest = this;
            synchronized (nettyHttpRequest) {
                cookies = this.nettyCookies;
                if (cookies == null) {
                    this.nettyCookies = cookies = new NettyCookies(this.getPath(), this.headers.getNettyHeaders(), this.conversionService);
                }
            }
        }
        return cookies;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().remoteAddress();
    }

    public InetSocketAddress getServerAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().localAddress();
    }

    public String getServerName() {
        return this.getServerAddress().getHostName();
    }

    public boolean isSecure() {
        ChannelHandlerContext channelHandlerContext = this.getChannelHandlerContext();
        return channelHandlerContext.pipeline().get(SslHandler.class) != null;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            NettyHttpRequest nettyHttpRequest = this;
            synchronized (nettyHttpRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap(new HashMap(4));
                }
            }
        }
        return attributes;
    }

    public Optional<T> getBody() {
        return this.body.get();
    }

    protected Object buildBody() {
        if (!this.receivedData.isEmpty()) {
            LinkedHashMap<Object, Object> body = new LinkedHashMap<Object, Object>(this.receivedData.size());
            for (AbstractHttpData data : this.receivedData.values()) {
                String newValue = this.getContent(data);
                body.compute(data.getName(), (key, oldValue) -> {
                    if (oldValue == null) {
                        return newValue;
                    }
                    if (oldValue instanceof Collection) {
                        ((Collection)oldValue).add(newValue);
                        return oldValue;
                    }
                    ArrayList<Object> values = new ArrayList<Object>(2);
                    values.add(oldValue);
                    values.add(newValue);
                    return values;
                });
                data.release();
            }
            return body;
        }
        if (!this.receivedContent.isEmpty()) {
            int size = this.receivedContent.size();
            CompositeByteBuf byteBufs = this.channelHandlerContext.alloc().compositeBuffer(size);
            for (ByteBufHolder holder : this.receivedContent) {
                ByteBuf content = holder.content();
                if (content == null) continue;
                byteBufs.addComponent(true, content);
            }
            return byteBufs;
        }
        return null;
    }

    private String getContent(AbstractHttpData data) {
        String newValue;
        try {
            newValue = data.getString(this.serverConfiguration.getDefaultCharset());
        }
        catch (IOException e) {
            throw new InternalServerException("Error retrieving or decoding the value for: " + data.getName());
        }
        return newValue;
    }

    public <T1> Optional<T1> getBody(Class<T1> type) {
        return this.getBody(Argument.of(type));
    }

    public <T1> Optional<T1> getBody(Argument<T1> type) {
        return this.getBody().flatMap(t -> this.bodyConvertor.convert(type, t));
    }

    @Internal
    public void release() {
        Consumer<Object> releaseIfNecessary = this::releaseIfNecessary;
        this.getBody().ifPresent(releaseIfNecessary);
        this.receivedContent.forEach(releaseIfNecessary);
        this.receivedData.values().forEach(releaseIfNecessary);
        if (this.body instanceof ReferenceCounted) {
            ReferenceCounted referenceCounted = (ReferenceCounted)this.body;
            this.releaseIfNecessary(referenceCounted);
        }
        if (this.attributes != null) {
            this.attributes.values().forEach(releaseIfNecessary);
        }
        if (this.nettyRequest instanceof StreamedHttpRequest) {
            ((StreamedHttpRequest)this.nettyRequest).closeIfNoSubscriber();
        }
    }

    protected void releaseIfNecessary(Object value) {
        ReferenceCounted referenceCounted;
        int i;
        if (value instanceof ReferenceCounted && (i = (referenceCounted = (ReferenceCounted)value).refCnt()) != 0) {
            referenceCounted.release();
        }
    }

    @Internal
    public void setBody(T body) {
        this.body = () -> Optional.ofNullable(body);
        this.bodyConvertor.cleanup();
    }

    @Internal
    public RouteMatch<?> getMatchedRoute() {
        return this.matchedRoute;
    }

    @Internal
    public void addContent(ByteBufHolder httpContent) {
        if (httpContent instanceof AbstractHttpData) {
            this.receivedData.computeIfAbsent(new IdentityWrapper(httpContent), key -> {
                httpContent.retain();
                return (AbstractHttpData)httpContent;
            });
        } else {
            this.receivedContent.add(httpContent.retain());
        }
    }

    @Internal
    void setMatchedRoute(RouteMatch<?> matchedRoute) {
        this.matchedRoute = matchedRoute;
    }

    @Internal
    void setBodyRequired(boolean bodyRequired) {
        this.bodyRequired = bodyRequired;
    }

    @Internal
    boolean isBodyRequired() {
        return this.bodyRequired || HttpMethod.requiresRequestBody((HttpMethod)this.getMethod());
    }

    public boolean isServerPushSupported() {
        Http2ConnectionHandler http2ConnectionHandler = (Http2ConnectionHandler)this.channelHandlerContext.pipeline().get(Http2ConnectionHandler.class);
        return http2ConnectionHandler != null && http2ConnectionHandler.connection().remote().allowPushTo();
    }

    public PushCapableHttpRequest<T> serverPush(@NotNull HttpRequest<?> request) {
        ChannelHandlerContext connectionHandlerContext = this.channelHandlerContext.pipeline().context(Http2ConnectionHandler.class);
        if (connectionHandlerContext != null) {
            URI fixedUri;
            String path;
            String authority;
            Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)connectionHandlerContext.handler();
            if (!connectionHandler.connection().remote().allowPushTo()) {
                throw new UnsupportedOperationException("Server push not supported by this client: Client is HTTP2 but does not report support for this feature");
            }
            URI configuredUri = request.getUri();
            String scheme = configuredUri.getScheme();
            if (scheme == null) {
                String string = scheme = this.channelHandlerContext.pipeline().get(SslHandler.class) == null ? "http" : "https";
            }
            if ((authority = configuredUri.getAuthority()) == null) {
                authority = (String)this.getHeaders().get((CharSequence)"Host");
            }
            if ((path = configuredUri.getPath()) == null || !path.startsWith("/")) {
                throw new IllegalArgumentException("Request must have an absolute path");
            }
            String query = configuredUri.getQuery();
            String fragment = configuredUri.getFragment();
            try {
                fixedUri = new URI(scheme, authority, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Illegal URI", e);
            }
            io.netty.handler.codec.http.HttpRequest inboundRequest = NettyHttpRequestBuilder.toHttpRequest(request);
            Iterator itr = this.headers.getNettyHeaders().iteratorCharSequence();
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                if (inboundRequest.headers().contains((CharSequence)entry.getKey()) || SERVER_PUSH_EXCLUDE_HEADERS.contains((CharSequence)entry.getKey())) continue;
                inboundRequest.headers().add((CharSequence)entry.getKey(), entry.getValue());
            }
            if (!inboundRequest.headers().contains((CharSequence)HttpHeaderNames.REFERER)) {
                inboundRequest.headers().add((CharSequence)HttpHeaderNames.REFERER, (Object)this.getUri().toString());
            }
            DefaultHttpRequest outboundRequest = new DefaultHttpRequest(inboundRequest.protocolVersion(), inboundRequest.method(), fixedUri.toString(), inboundRequest.headers());
            int ourStream = this.nettyRequest.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            int newStream = connectionHandler.connection().local().incrementAndGetNextStreamId();
            connectionHandler.encoder().frameWriter().writePushPromise(connectionHandlerContext, ourStream, newStream, HttpConversionUtil.toHttp2Headers((HttpMessage)outboundRequest, (boolean)false), 0, connectionHandlerContext.voidPromise());
            inboundRequest.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), newStream);
            inboundRequest.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), ourStream);
            connectionHandlerContext.executor().execute(() -> connectionHandlerContext.fireChannelRead((Object)inboundRequest));
            return this;
        }
        throw new UnsupportedOperationException("Server push not supported by this client: Not a HTTP2 client");
    }

    protected Charset initCharset(Charset characterEncoding) {
        return characterEncoding == null ? this.serverConfiguration.getDefaultCharset() : characterEncoding;
    }

    @Internal
    final boolean isFormOrMultipartData() {
        MediaType ct = this.headers.contentType().orElse(null);
        return ct != null && (ct.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) || ct.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE));
    }

    @Internal
    final boolean isFormData() {
        MediaType ct = this.headers.contentType().orElse(null);
        return ct != null && ct.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    static NettyHttpRequest get(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(ServerAttributeKeys.REQUEST_KEY);
        return (NettyHttpRequest)((Object)attr.get());
    }

    static NettyHttpRequest remove(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Attribute attr = channel.attr(ServerAttributeKeys.REQUEST_KEY);
        return (NettyHttpRequest)((Object)attr.getAndSet(null));
    }

    private BodyConvertor newBodyConvertor() {
        return new BodyConvertor(){

            public Optional convert(Argument valueType, Object value) {
                if (value == null) {
                    return Optional.empty();
                }
                if (Argument.OBJECT_ARGUMENT.equalsType(valueType)) {
                    return Optional.of(value);
                }
                return this.convertFromNext(NettyHttpRequest.this.conversionService, valueType, value);
            }
        };
    }

    static {
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.ETAG, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_MATCH, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_NONE_MATCH, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_UNMODIFIED_SINCE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.EXPECT, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.REFERER, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), (Object)"");
    }

    private static abstract class BodyConvertor<T> {
        private BodyConvertor<T> nextConvertor;

        private BodyConvertor() {
        }

        public abstract Optional<T> convert(Argument<T> var1, T var2);

        protected synchronized Optional<T> convertFromNext(final ConversionService conversionService, final Argument<T> conversionValueType, T value) {
            if (this.nextConvertor == null) {
                final Optional conversion = conversionService.convert(value, ConversionContext.of(conversionValueType));
                this.nextConvertor = new BodyConvertor<T>(){

                    @Override
                    public Optional<T> convert(Argument<T> valueType, T value) {
                        if (conversionValueType.equalsType(valueType)) {
                            return conversion;
                        }
                        return this.convertFromNext(conversionService, valueType, value);
                    }
                };
                return conversion;
            }
            return this.nextConvertor.convert(conversionValueType, value);
        }

        public void cleanup() {
            this.nextConvertor = null;
        }
    }

    private class NettyMutableHttpRequest
    implements MutableHttpRequest<T>,
    NettyHttpRequestBuilder {
        private URI uri;
        private MutableHttpParameters httpParameters;
        private Object body;

        private NettyMutableHttpRequest() {
            this.uri = NettyHttpRequest.this.uri;
        }

        public MutableHttpRequest<T> cookie(Cookie cookie) {
            if (cookie instanceof NettyCookie) {
                NettyCookie nettyCookie = (NettyCookie)cookie;
                String value = ClientCookieEncoder.LAX.encode(nettyCookie.getNettyCookie());
                NettyHttpRequest.this.headers.add((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)value);
            }
            return this;
        }

        public MutableHttpRequest<T> uri(URI uri) {
            this.uri = uri;
            if (uri.getQuery() != null) {
                this.httpParameters = null;
            }
            return this;
        }

        public <T1> MutableHttpRequest<T1> body(T1 body) {
            this.body = body;
            return this;
        }

        public MutableHttpHeaders getHeaders() {
            return NettyHttpRequest.this.headers;
        }

        @NonNull
        public MutableConvertibleValues<Object> getAttributes() {
            return NettyHttpRequest.this.getAttributes();
        }

        @NonNull
        public Optional<T> getBody() {
            if (this.body != null) {
                return Optional.of(this.body);
            }
            return NettyHttpRequest.this.getBody();
        }

        @NonNull
        public Cookies getCookies() {
            return NettyHttpRequest.this.getCookies();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MutableHttpParameters getParameters() {
            MutableHttpParameters httpParameters = this.httpParameters;
            if (httpParameters == null) {
                NettyMutableHttpRequest nettyMutableHttpRequest = this;
                synchronized (nettyMutableHttpRequest) {
                    httpParameters = this.httpParameters;
                    if (httpParameters == null) {
                        QueryStringDecoder queryStringDecoder = NettyHttpRequest.this.createDecoder(this.uri.toString());
                        this.httpParameters = httpParameters = new NettyHttpParameters(queryStringDecoder.parameters(), NettyHttpRequest.this.conversionService, null);
                    }
                }
            }
            return httpParameters;
        }

        @NonNull
        public HttpMethod getMethod() {
            return NettyHttpRequest.this.getMethod();
        }

        @NonNull
        public URI getUri() {
            if (this.uri != null) {
                return this.uri;
            }
            return NettyHttpRequest.this.getUri();
        }

        @NonNull
        public FullHttpRequest toFullHttpRequest() {
            io.netty.handler.codec.http.HttpRequest nr = NettyHttpRequest.this.nettyRequest;
            if (nr instanceof FullHttpRequest) {
                return (FullHttpRequest)NettyHttpRequest.this.nettyRequest;
            }
            return new DefaultFullHttpRequest(nr.protocolVersion(), nr.method(), nr.uri(), Unpooled.EMPTY_BUFFER, nr.headers(), (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
        }

        @NonNull
        public StreamedHttpRequest toStreamHttpRequest() {
            if (this.isStream()) {
                return (StreamedHttpRequest)NettyHttpRequest.this.nettyRequest;
            }
            FullHttpRequest fullHttpRequest = this.toFullHttpRequest();
            DefaultStreamedHttpRequest request = new DefaultStreamedHttpRequest(fullHttpRequest.protocolVersion(), fullHttpRequest.method(), fullHttpRequest.uri(), true, Publishers.just((Object)new DefaultLastHttpContent(fullHttpRequest.content())));
            request.headers().setAll(fullHttpRequest.headers());
            return request;
        }

        @NonNull
        public io.netty.handler.codec.http.HttpRequest toHttpRequest() {
            if (this.isStream()) {
                return this.toStreamHttpRequest();
            }
            return this.toFullHttpRequest();
        }

        public boolean isStream() {
            return NettyHttpRequest.this.nettyRequest instanceof StreamedHttpRequest;
        }

        public MutableHttpRequest<T> mutate() {
            return new NettyMutableHttpRequest();
        }
    }
}

