/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.files;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.types.NettyFileCustomizableResponseType;
import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.http.server.types.files.SystemFile;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NettySystemFileCustomizableResponseType
extends SystemFile
implements NettyFileCustomizableResponseType {
    private static final int LENGTH_8K = 8192;
    private static final Logger LOG = LoggerFactory.getLogger(NettySystemFileCustomizableResponseType.class);
    protected final RandomAccessFile raf;
    protected final long rafLength;
    protected Optional<FileCustomizableResponseType> delegate = Optional.empty();

    public NettySystemFileCustomizableResponseType(File file) {
        super(file);
        try {
            this.raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new CustomizableResponseTypeException("Could not find file", (Throwable)e);
        }
        try {
            this.rafLength = this.raf.length();
        }
        catch (IOException e) {
            throw new CustomizableResponseTypeException("Could not determine file length", (Throwable)e);
        }
    }

    public NettySystemFileCustomizableResponseType(SystemFile delegate) {
        this(delegate.getFile());
        this.delegate = Optional.of(delegate);
    }

    public long getLength() {
        return this.rafLength;
    }

    public long getLastModified() {
        return this.delegate.map(FileCustomizableResponseType::getLastModified).orElse(super.getLastModified());
    }

    public MediaType getMediaType() {
        return this.delegate.map(FileCustomizableResponseType::getMediaType).orElse(super.getMediaType());
    }

    public void process(MutableHttpResponse response) {
        response.header((CharSequence)"Content-Length", (CharSequence)String.valueOf(this.getLength()));
        this.delegate.ifPresent(type -> type.process(response));
    }

    @Override
    public void write(HttpRequest<?> request, MutableHttpResponse<?> response, ChannelHandlerContext context) {
        if (response instanceof NettyMutableHttpResponse) {
            NettyMutableHttpResponse nettyResponse = (NettyMutableHttpResponse)response;
            DefaultHttpResponse finalResponse = new DefaultHttpResponse(nettyResponse.getNettyHttpVersion(), nettyResponse.getNettyHttpStatus(), nettyResponse.getNettyHeaders());
            if (request instanceof NettyHttpRequest) {
                ((NettyHttpRequest)request).prepareHttp2ResponseIfNecessary((HttpResponse)finalResponse);
            }
            context.write((Object)finalResponse, context.voidPromise());
            ChannelFutureListener closeListener = future -> {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    LOG.warn("An error occurred closing the file reference: " + this.getFile().getAbsolutePath(), (Throwable)e);
                }
            };
            if (context.pipeline().get(SslHandler.class) == null && ((SmartHttpContentCompressor)context.pipeline().get(SmartHttpContentCompressor.class)).shouldSkip((HttpResponse)finalResponse)) {
                context.write((Object)new DefaultFileRegion(this.raf.getChannel(), 0L, this.getLength()), (ChannelPromise)context.newProgressivePromise()).addListener((GenericFutureListener)closeListener);
                context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                try {
                    HttpChunkedInput chunkedInput = new HttpChunkedInput((ChunkedInput)new ChunkedFile(this.raf, 0L, this.getLength(), 8192));
                    context.writeAndFlush((Object)chunkedInput, (ChannelPromise)context.newProgressivePromise()).addListener((GenericFutureListener)closeListener);
                }
                catch (IOException e) {
                    throw new CustomizableResponseTypeException("Could not read file", (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported response type. Not a Netty response: " + response);
        }
    }
}

