/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.discovery.event.ServiceStoppedEvent;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.context.event.HttpRequestReceivedEvent;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.netty.stream.HttpStreamsServerHandler;
import io.micronaut.http.netty.stream.StreamingInboundHttp2ToHttpAdapter;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.server.netty.DefaultHttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpToHttpsRedirectHandler;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.NettyEmbeddedServerInstance;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.decoders.HttpRequestDecoder;
import io.micronaut.http.server.netty.encoders.HttpResponseEncoder;
import io.micronaut.http.server.netty.handler.accesslog.HttpAccessLogHandler;
import io.micronaut.http.server.netty.ssl.HttpRequestCertificateHandler;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler;
import io.micronaut.http.server.util.DefaultHttpHostResolver;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.web.router.Router;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@TypeHint(value={ChannelOption.class}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS})
public class NettyHttpServer
implements NettyEmbeddedServer {
    public static final String OUTBOUND_KEY = "-outbound-";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final NettyEmbeddedServices nettyEmbeddedServices;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final ServerSslConfiguration sslConfiguration;
    private final Environment environment;
    private final int specifiedPort;
    private final HttpRequestCertificateHandler requestCertificateHandler;
    private final RoutingInBoundHandler routingHandler;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final boolean isDefault;
    private volatile int serverPort;
    private final ApplicationContext applicationContext;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ChannelGroup webSocketSessions = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final HttpHostResolver hostResolver;
    private boolean shutdownWorker = false;
    private boolean shutdownParent = false;
    private EventLoopGroup workerGroup;
    private EventLoopGroup parentGroup;
    private EmbeddedServerInstance serviceInstance;
    private final Collection<ChannelPipelineListener> pipelineListeners = new ArrayList<ChannelPipelineListener>(2);
    private final ApplicationEventPublisher<HttpRequestReceivedEvent> httpRequestReceivedEventPublisher;
    private NettyHttpServerInitializer childHandler;
    private final Set<Integer> boundPorts = new HashSet<Integer>(2);

    public NettyHttpServer(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices nettyEmbeddedServices, NettyCustomizableResponseTypeHandlerRegistry handlerRegistry, boolean isDefault) {
        int port;
        this.isDefault = isDefault;
        this.serverConfiguration = serverConfiguration;
        this.nettyEmbeddedServices = nettyEmbeddedServices;
        Optional location = this.serverConfiguration.getMultipart().getLocation();
        location.ifPresent(dir -> {
            DiskFileUpload.baseDirectory = dir.getAbsolutePath();
        });
        this.applicationContext = nettyEmbeddedServices.getApplicationContext();
        this.environment = this.applicationContext.getEnvironment();
        ServerSslBuilder serverSslBuilder = nettyEmbeddedServices.getServerSslBuilder();
        if (serverSslBuilder != null) {
            this.sslConfiguration = serverSslBuilder.getSslConfiguration();
            this.specifiedPort = this.sslConfiguration.isEnabled() ? (port = this.sslConfiguration.getPort()) : (port = this.getHttpPort(this.serverConfiguration));
        } else {
            this.specifiedPort = port = this.getHttpPort(this.serverConfiguration);
            this.sslConfiguration = null;
        }
        this.serverPort = port;
        this.requestCertificateHandler = new HttpRequestCertificateHandler();
        this.httpRequestReceivedEventPublisher = nettyEmbeddedServices.getEventPublisher(HttpRequestReceivedEvent.class);
        ApplicationEventPublisher<HttpRequestTerminatedEvent> httpRequestTerminatedEventPublisher = nettyEmbeddedServices.getEventPublisher(HttpRequestTerminatedEvent.class);
        Supplier ioExecutor = SupplierUtil.memoized(() -> nettyEmbeddedServices.getExecutorSelector().select("io").orElse(null));
        this.httpContentProcessorResolver = new DefaultHttpContentProcessorResolver((BeanLocator)nettyEmbeddedServices.getApplicationContext(), (BeanProvider<NettyHttpServerConfiguration>)((BeanProvider)() -> serverConfiguration));
        this.routingHandler = new RoutingInBoundHandler(serverConfiguration, handlerRegistry, nettyEmbeddedServices, ioExecutor, this.httpContentProcessorResolver, httpRequestTerminatedEventPublisher);
        this.hostResolver = new DefaultHttpHostResolver((HttpServerConfiguration)serverConfiguration, () -> this);
    }

    private int getHttpPort(NettyHttpServerConfiguration serverConfiguration) {
        Integer configPort = serverConfiguration.getPort().orElse(null);
        return this.getHttpPort(configPort);
    }

    private int getHttpPort(Integer configPort) {
        if (configPort != null) {
            return configPort;
        }
        if (this.environment.getActiveNames().contains("test")) {
            return -1;
        }
        return 8080;
    }

    public boolean isKeepAlive() {
        return false;
    }

    public NettyHttpServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public synchronized NettyEmbeddedServer start() {
        if (!this.isRunning()) {
            EventLoopGroupConfiguration workerConfig = this.resolveWorkerConfiguration();
            this.workerGroup = this.createWorkerEventLoopGroup(workerConfig);
            this.parentGroup = this.createParentEventLoopGroup();
            ServerBootstrap serverBootstrap = this.createServerBootstrap();
            serverBootstrap.channelFactory(() -> this.nettyEmbeddedServices.getServerSocketChannelInstance(workerConfig));
            this.processOptions(this.serverConfiguration.getOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).option(arg_0, arg_1));
            this.processOptions(this.serverConfiguration.getChildOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).childOption(arg_0, arg_1));
            this.childHandler = new NettyHttpServerInitializer();
            serverBootstrap = serverBootstrap.group(this.parentGroup, this.workerGroup).childHandler((ChannelHandler)this.childHandler);
            Optional host = this.serverConfiguration.getHost();
            String definedHost = host.orElse(null);
            this.serverPort = this.bindServerToHost(serverBootstrap, definedHost, this.serverPort);
            if (this.isDefault) {
                ArrayList<Integer> defaultPorts = new ArrayList<Integer>(2);
                defaultPorts.add(this.serverPort);
                if (this.serverConfiguration.isDualProtocol()) {
                    defaultPorts.add(this.bindServerToHost(serverBootstrap, definedHost, this.getHttpPort(this.serverConfiguration)));
                }
                Router router = this.nettyEmbeddedServices.getRouter();
                Set exposedPorts = router.getExposedPorts();
                this.boundPorts.addAll(defaultPorts);
                if (CollectionUtils.isNotEmpty((Collection)exposedPorts)) {
                    router.applyDefaultPorts(defaultPorts);
                    for (Integer exposedPort : exposedPorts) {
                        if (defaultPorts.contains(exposedPort)) continue;
                        try {
                            if (definedHost != null) {
                                serverBootstrap.bind(definedHost, exposedPort.intValue()).sync();
                            } else {
                                serverBootstrap.bind(exposedPort.intValue()).sync();
                            }
                            this.boundPorts.add(exposedPort);
                        }
                        catch (Throwable e) {
                            boolean isBindError = e instanceof BindException;
                            if (LOG.isErrorEnabled()) {
                                if (isBindError) {
                                    LOG.error("Unable to start server. Additional specified server port {} already in use.", (Object)exposedPort);
                                } else {
                                    LOG.error("Error starting Micronaut server: " + e.getMessage(), e);
                                }
                            }
                            throw new ServerStartupException("Unable to start Micronaut server on port: " + this.serverPort, e);
                        }
                    }
                }
            }
            this.fireStartupEvents();
            this.running.set(true);
        }
        return this;
    }

    private EventLoopGroupConfiguration resolveWorkerConfiguration() {
        NettyHttpServerConfiguration.Worker workerConfig = this.serverConfiguration.getWorker();
        if (workerConfig == null) {
            workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration("default").orElse(null);
        } else {
            String eventLoopGroupName = workerConfig.getName();
            if (!"default".equals(eventLoopGroupName)) {
                workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration(eventLoopGroupName).orElse(workerConfig);
            }
        }
        return workerConfig;
    }

    @Override
    public synchronized NettyEmbeddedServer stop() {
        if (this.isRunning() && this.workerGroup != null && this.running.compareAndSet(true, false)) {
            this.stopInternal();
        }
        return this;
    }

    public int getPort() {
        if (!this.isRunning() && this.serverPort == -1) {
            throw new UnsupportedOperationException("Retrieving the port from the server before it has started is not supported when binding to a random port");
        }
        return this.serverPort;
    }

    public String getHost() {
        return this.serverConfiguration.getHost().orElseGet(() -> Optional.ofNullable(CachedEnvironment.getenv((String)"HOSTNAME")).orElse("localhost"));
    }

    public String getScheme() {
        return this.sslConfiguration != null && this.sslConfiguration.isEnabled() ? "https" : "http";
    }

    public URL getURL() {
        try {
            return new URL(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        try {
            return new URI(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.serverConfiguration.getApplicationConfiguration();
    }

    @Override
    public final Set<Integer> getBoundPorts() {
        return Collections.unmodifiableSet(this.boundPorts);
    }

    protected EventLoopGroup createParentEventLoopGroup() {
        NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(parent != null ? parent.getName() : "parent").orElseGet(() -> {
            EventLoopGroup newGroup = this.newEventLoopGroup(parent);
            this.shutdownParent = true;
            return newGroup;
        });
    }

    protected EventLoopGroup createWorkerEventLoopGroup(@Nullable EventLoopGroupConfiguration workerConfig) {
        String configName = workerConfig != null ? workerConfig.getName() : "default";
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(configName).orElseGet(() -> {
            LOG.warn("The configuration for 'micronaut.server.netty.worker.{}' is deprecated. Use 'micronaut.netty.event-loops.default' configuration instead.", (Object)configName);
            EventLoopGroup newGroup = this.newEventLoopGroup(workerConfig);
            this.shutdownWorker = true;
            return newGroup;
        });
    }

    protected ServerBootstrap createServerBootstrap() {
        return new ServerBootstrap();
    }

    private int bindServerToHost(ServerBootstrap serverBootstrap, @Nullable String host, int port) {
        boolean isRandomPort = this.specifiedPort == -1;
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        if (applicationName.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding {} server to {}:{}", new Object[]{applicationName.get(), host != null ? host : "*", port});
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Binding server to {}:{}", (Object)(host != null ? host : "*"), (Object)port);
        }
        try {
            if (isRandomPort) {
                ChannelFuture future = host != null ? serverBootstrap.bind(host, 0).sync() : serverBootstrap.bind(0).sync();
                InetSocketAddress ia = (InetSocketAddress)future.channel().localAddress();
                return ia.getPort();
            }
            if (host != null) {
                serverBootstrap.bind(host, port).sync();
            } else {
                serverBootstrap.bind(port).sync();
            }
            return port;
        }
        catch (Throwable e) {
            boolean isBindError = e instanceof BindException;
            if (LOG.isErrorEnabled()) {
                if (isBindError) {
                    LOG.error("Unable to start server. Port {} already in use.", (Object)port);
                } else {
                    LOG.error("Error starting Micronaut server: " + e.getMessage(), e);
                }
            }
            this.stopInternal();
            throw new ServerStartupException("Unable to start Micronaut server on port: " + port, e);
        }
    }

    private void fireStartupEvents() {
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        this.applicationContext.getEventPublisher(ServerStartupEvent.class).publishEvent((Object)new ServerStartupEvent((EmbeddedServer)this));
        applicationName.ifPresent(id -> {
            this.serviceInstance = (EmbeddedServerInstance)this.applicationContext.createBean(NettyEmbeddedServerInstance.class, new Object[]{id, this});
            this.applicationContext.getEventPublisher(ServiceReadyEvent.class).publishEvent((Object)new ServiceReadyEvent((ServiceInstance)this.serviceInstance));
        });
    }

    private void logShutdownErrorIfNecessary(Future<?> future) {
        if (!future.isSuccess() && LOG.isWarnEnabled()) {
            Throwable e = future.cause();
            LOG.warn("Error stopping Micronaut server: " + e.getMessage(), e);
        }
    }

    private void stopInternal() {
        block9: {
            try {
                if (this.shutdownParent) {
                    NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
                    if (parent != null) {
                        long quietPeriod = parent.getShutdownQuietPeriod().toMillis();
                        long timeout = parent.getShutdownTimeout().toMillis();
                        this.parentGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS).addListener(this::logShutdownErrorIfNecessary);
                    } else {
                        this.parentGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                    }
                }
                if (this.shutdownWorker) {
                    this.workerGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                }
                this.webSocketSessions.close();
                this.applicationContext.getEventPublisher(ServerShutdownEvent.class).publishEvent((Object)new ServerShutdownEvent((EmbeddedServer)this));
                if (this.serviceInstance != null) {
                    this.applicationContext.getEventPublisher(ServiceStoppedEvent.class).publishEvent((Object)new ServiceStoppedEvent((ServiceInstance)this.serviceInstance));
                }
                if (this.isDefault) {
                    if (this.applicationContext.isRunning()) {
                        this.applicationContext.stop();
                    }
                    this.serverConfiguration.getMultipart().getLocation().ifPresent(dir -> {
                        DiskFileUpload.baseDirectory = null;
                    });
                }
                this.serverConfiguration.getMultipart().getLocation().ifPresent(dir -> {
                    DiskFileUpload.baseDirectory = null;
                });
                this.childHandler = null;
                this.boundPorts.clear();
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error("Error stopping Micronaut server: " + e.getMessage(), e);
            }
        }
    }

    private EventLoopGroup newEventLoopGroup(EventLoopGroupConfiguration config) {
        if (config != null) {
            ExecutorService executorService = config.getExecutorName().flatMap(name -> this.applicationContext.findBean(ExecutorService.class, Qualifiers.byName((String)name))).orElse(null);
            if (executorService != null) {
                return this.nettyEmbeddedServices.createEventLoopGroup(config.getNumThreads(), executorService, config.getIoRatio().orElse(null));
            }
            return this.nettyEmbeddedServices.createEventLoopGroup(config);
        }
        return this.nettyEmbeddedServices.createEventLoopGroup((EventLoopGroupConfiguration)new DefaultEventLoopGroupConfiguration());
    }

    private void processOptions(Map<ChannelOption, Object> options, BiConsumer<ChannelOption, Object> biConsumer) {
        ChannelOptionFactory channelOptionFactory = this.nettyEmbeddedServices.getChannelOptionFactory();
        options.forEach((option, value) -> biConsumer.accept((ChannelOption)option, channelOptionFactory.convertValue(option, value, this.environment)));
    }

    public void addChannel(Channel channel) {
        this.webSocketSessions.add((Object)channel);
    }

    public void removeChannel(Channel channel) {
        this.webSocketSessions.remove((Object)channel);
    }

    public ChannelGroup getChannelGroup() {
        return this.webSocketSessions;
    }

    public WebSocketSessionRepository getWebSocketSessionRepository() {
        return this;
    }

    private HttpToHttp2ConnectionHandler newHttpToHttp2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        StreamingInboundHttp2ToHttpAdapter http2ToHttpAdapter = new StreamingInboundHttp2ToHttpAdapter((Http2Connection)connection, (int)this.serverConfiguration.getMaxRequestSize(), this.serverConfiguration.isValidateHeaders(), true);
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)http2ToHttpAdapter).validateHeaders(this.serverConfiguration.isValidateHeaders()).initialSettings(this.serverConfiguration.getHttp2().http2Settings());
        this.serverConfiguration.getLogLevel().ifPresent(logLevel -> builder.frameLogger(new Http2FrameLogger(logLevel, NettyHttpServer.class)));
        return builder.connection((Http2Connection)connection).build();
    }

    public boolean isClientChannel() {
        return false;
    }

    public void doOnConnect(@NonNull ChannelPipelineListener listener) {
        this.pipelineListeners.add(Objects.requireNonNull(listener, "The listener cannot be null"));
    }

    public Set<String> getObservedConfigurationPrefixes() {
        return Collections.singleton("micronaut.server");
    }

    public void onApplicationEvent(RefreshEvent event) {
        if (this.childHandler != null) {
            ServerSslBuilder serverSslBuilder = this.nettyEmbeddedServices.getServerSslBuilder();
            this.childHandler.sslContext = serverSslBuilder != null ? (SslContext)serverSslBuilder.build().orElse(null) : null;
            this.childHandler.loggingHandler = this.serverConfiguration.getLogLevel().isPresent() ? new LoggingHandler(NettyHttpServer.class, this.serverConfiguration.getLogLevel().get()) : null;
            this.childHandler.initHttpCoders();
        }
    }

    private void insertPcapLoggingHandler(ChannelPipeline pipeline, String qualifier) {
        String pattern = this.serverConfiguration.getPcapLoggingPathPattern();
        if (pattern == null) {
            return;
        }
        String path = pattern;
        path = path.replace("{qualifier}", qualifier);
        path = path.replace("{localAddress}", NettyHttpServer.resolveIfNecessary(pipeline.channel().localAddress()));
        path = path.replace("{remoteAddress}", NettyHttpServer.resolveIfNecessary(pipeline.channel().remoteAddress()));
        path = path.replace("{random}", Long.toHexString(ThreadLocalRandom.current().nextLong()));
        path = path.replace("{timestamp}", Instant.now().toString());
        path = path.replace(':', '_');
        LOG.warn("Logging *full* request data, as configured. This will contain sensitive information! Path: '{}'", (Object)path);
        try {
            pipeline.addLast(new ChannelHandler[]{new PcapWriteHandler((OutputStream)new FileOutputStream(path))});
        }
        catch (FileNotFoundException e) {
            LOG.warn("Failed to create target pcap at '{}', not logging.", (Object)path, (Object)e);
        }
    }

    private static String resolveIfNecessary(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            if (((InetSocketAddress)address).isUnresolved() && ((InetSocketAddress)(address = new InetSocketAddress(((InetSocketAddress)address).getHostString(), ((InetSocketAddress)address).getPort()))).isUnresolved()) {
                return "unresolved";
            }
            return ((InetSocketAddress)address).getAddress().getHostAddress() + ':' + ((InetSocketAddress)address).getPort();
        }
        String s = address.toString();
        if (s.contains("/")) {
            return "weird";
        }
        return s;
    }

    private class NettyHttpServerInitializer
    extends ChannelInitializer<SocketChannel> {
        SslContext sslContext;
        LoggingHandler loggingHandler;
        private HttpAccessLogHandler accessLogHandler;
        private HttpRequestDecoder requestDecoder;
        private HttpResponseEncoder responseEncoder;

        private NettyHttpServerInitializer() {
            this.sslContext = NettyHttpServer.this.nettyEmbeddedServices.getServerSslBuilder() != null ? (SslContext)NettyHttpServer.this.nettyEmbeddedServices.getServerSslBuilder().build().orElse(null) : null;
            this.loggingHandler = NettyHttpServer.this.serverConfiguration.getLogLevel().isPresent() ? new LoggingHandler(NettyHttpServer.class, NettyHttpServer.this.serverConfiguration.getLogLevel().get()) : null;
            this.initHttpCoders();
        }

        private Predicate<String> inclusionPredicate(NettyHttpServerConfiguration.AccessLogger config) {
            List<String> exclusions = config.getExclusions();
            if (CollectionUtils.isEmpty(exclusions)) {
                return null;
            }
            List patterns = exclusions.stream().map(Pattern::compile).collect(Collectors.toList());
            return uri -> patterns.stream().noneMatch(pattern -> pattern.matcher((CharSequence)uri).matches());
        }

        private HttpAccessLogHandler accessLogHandler() {
            NettyHttpServerConfiguration.AccessLogger accessLogger = NettyHttpServer.this.serverConfiguration.getAccessLogger();
            if (accessLogger != null && accessLogger.isEnabled()) {
                return new HttpAccessLogHandler(accessLogger.getLoggerName(), accessLogger.getLogFormat(), this.inclusionPredicate(accessLogger));
            }
            return null;
        }

        void initHttpCoders() {
            this.accessLogHandler = this.accessLogHandler();
            this.requestDecoder = new HttpRequestDecoder(NettyHttpServer.this, (ConversionService<?>)NettyHttpServer.this.environment, NettyHttpServer.this.serverConfiguration, (ApplicationEventPublisher<HttpRequestReceivedEvent>)NettyHttpServer.this.httpRequestReceivedEventPublisher);
            this.responseEncoder = new HttpResponseEncoder(NettyHttpServer.this.nettyEmbeddedServices.getMediaTypeCodecRegistry(), NettyHttpServer.this.serverConfiguration);
        }

        protected void initChannel(SocketChannel ch) {
            boolean ssl;
            ChannelPipeline pipeline = ch.pipeline();
            NettyHttpServer.this.insertPcapLoggingHandler(pipeline, "encapsulated");
            int port = ch.localAddress().getPort();
            boolean bl = ssl = this.sslContext != null && NettyHttpServer.this.sslConfiguration != null && port == NettyHttpServer.this.serverPort;
            if (ssl) {
                SslHandler sslHandler = this.sslContext.newHandler(ch.alloc());
                sslHandler.setHandshakeTimeoutMillis(NettyHttpServer.this.sslConfiguration.getHandshakeTimeout().toMillis());
                pipeline.addLast("ssl", (ChannelHandler)sslHandler);
                NettyHttpServer.this.insertPcapLoggingHandler(pipeline, "ssl-decapsulated");
            }
            if (this.loggingHandler != null) {
                pipeline.addLast(new ChannelHandler[]{this.loggingHandler});
            }
            final Http2OrHttpHandler http2OrHttpHandler = new Http2OrHttpHandler(this.sslContext != null, NettyHttpServer.this.serverConfiguration.getFallbackProtocol(), this.accessLogHandler, this.requestDecoder, this.responseEncoder);
            if (NettyHttpServer.this.serverConfiguration.getHttpVersion() != HttpVersion.HTTP_2_0) {
                http2OrHttpHandler.configurePipeline("http/1.1", pipeline);
            } else if (ssl) {
                pipeline.addLast(new ChannelHandler[]{http2OrHttpHandler});
            } else {
                HttpToHttp2ConnectionHandler connectionHandler = NettyHttpServer.this.newHttpToHttp2ConnectionHandler();
                String fallbackHandlerName = "http1-fallback-handler";
                HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
                    if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                        return new Http2ServerUpgradeCodec("http2-connection", (Http2ConnectionHandler)connectionHandler){

                            public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
                                ChannelPipeline p = ctx.pipeline();
                                p.remove("http1-fallback-handler");
                                http2OrHttpHandler.getHandlerForProtocol(null).forEach((arg_0, arg_1) -> ((ChannelPipeline)p).addLast(arg_0, arg_1));
                                for (ChannelPipelineListener pipelineListener : NettyHttpServer.this.pipelineListeners) {
                                    pipelineListener.onConnect(p);
                                }
                                super.upgradeTo(ctx, upgradeRequest);
                                upgradeRequest.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)1);
                                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)upgradeRequest));
                            }
                        };
                    }
                    return null;
                };
                HttpServerCodec sourceCodec = http2OrHttpHandler.createServerCodec();
                final HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory, NettyHttpServer.this.serverConfiguration.getMaxH2cUpgradeRequestSize());
                CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)connectionHandler);
                pipeline.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
                pipeline.addLast("http1-fallback-handler", (ChannelHandler)new SimpleChannelInboundHandler<HttpMessage>(){

                    protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) {
                        Map.Entry entry;
                        HttpRequest req;
                        if (msg instanceof HttpRequest && (req = (HttpRequest)msg).headers().contains((CharSequence)AbstractNettyHttpRequest.STREAM_ID)) {
                            ChannelPipeline pipeline = ctx.pipeline();
                            pipeline.remove((ChannelHandler)this);
                            pipeline.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                            return;
                        }
                        ChannelPipeline pipeline = ctx.pipeline();
                        pipeline.remove((ChannelHandler)upgradeHandler);
                        pipeline.remove((ChannelHandler)this);
                        ChannelHandlerContext serverCodecContext = pipeline.context(HttpServerCodec.class);
                        Iterator newHandlers = http2OrHttpHandler.getHandlerForProtocol("http/1.1", (HttpServerCodec)serverCodecContext.handler()).entrySet().iterator();
                        while (true) {
                            if (!newHandlers.hasNext()) {
                                throw new AssertionError((Object)"getHandlerForProtocol(HTTP_1_1) should return the HttpServerCodec passed to it");
                            }
                            entry = newHandlers.next();
                            if (entry.getValue() == serverCodecContext.handler()) break;
                            pipeline.addBefore(serverCodecContext.name(), (String)entry.getKey(), (ChannelHandler)entry.getValue());
                        }
                        while (newHandlers.hasNext()) {
                            entry = newHandlers.next();
                            pipeline.addLast((String)entry.getKey(), (ChannelHandler)entry.getValue());
                        }
                        for (ChannelPipelineListener pipelineListener : NettyHttpServer.this.pipelineListeners) {
                            pipelineListener.onConnect(pipeline);
                        }
                        pipeline.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                    }
                });
            }
        }
    }

    private final class Http2OrHttpHandler
    extends ApplicationProtocolNegotiationHandler {
        private final boolean useSsl;
        private final HttpAccessLogHandler accessLogHandler;
        private final HttpRequestDecoder requestDecoder;
        private final HttpResponseEncoder responseEncoder;

        Http2OrHttpHandler(boolean useSsl, @Nullable String fallbackProtocol, HttpAccessLogHandler accessLogHandler, HttpRequestDecoder requestDecoder, HttpResponseEncoder responseEncoder) {
            super(fallbackProtocol);
            this.useSsl = useSsl;
            this.accessLogHandler = accessLogHandler;
            this.requestDecoder = requestDecoder;
            this.responseEncoder = responseEncoder;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            SslHandshakeCompletionEvent event;
            if (evt instanceof SslHandshakeCompletionEvent && !(event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                Throwable cause = event.cause();
                if (!(cause instanceof ClosedChannelException)) {
                    super.userEventTriggered(ctx, evt);
                } else {
                    return;
                }
            }
            super.userEventTriggered(ctx, evt);
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            ChannelPipeline pipeline = ctx.pipeline();
            this.configurePipeline(protocol, pipeline);
            ctx.read();
        }

        private void configurePipeline(String protocol, ChannelPipeline pipeline) {
            Map<String, ChannelHandler> handlers = this.getHandlerForProtocol(protocol);
            handlers.forEach((arg_0, arg_1) -> ((ChannelPipeline)pipeline).addLast(arg_0, arg_1));
            for (ChannelPipelineListener pipelineListener : NettyHttpServer.this.pipelineListeners) {
                pipelineListener.onConnect(pipeline);
            }
        }

        private void registerMicronautChannelHandlers(Map<String, ChannelHandler> channelHandlerMap) {
            int i = 0;
            for (ChannelOutboundHandler outboundHandlerAdapter : NettyHttpServer.this.nettyEmbeddedServices.getOutboundHandlers()) {
                String name = outboundHandlerAdapter instanceof Named ? ((Named)outboundHandlerAdapter).getName() : "micronaut-inbound-handler-outbound-" + ++i;
                channelHandlerMap.put(name, (ChannelHandler)outboundHandlerAdapter);
            }
        }

        @NonNull
        private Map<String, ChannelHandler> getHandlerForProtocol(@Nullable String protocol) {
            return this.getHandlerForProtocol(protocol, null);
        }

        @NonNull
        private Map<String, ChannelHandler> getHandlerForProtocol(@Nullable String protocol, @Nullable HttpServerCodec serverCodec) {
            Duration idleTime = NettyHttpServer.this.serverConfiguration.getIdleTimeout();
            LinkedHashMap<String, ChannelHandler> handlers = new LinkedHashMap<String, ChannelHandler>(15);
            if (!idleTime.isNegative()) {
                handlers.put("idle-state", (ChannelHandler)new IdleStateHandler((int)NettyHttpServer.this.serverConfiguration.getReadIdleTimeout().getSeconds(), (int)NettyHttpServer.this.serverConfiguration.getWriteIdleTimeout().getSeconds(), (int)idleTime.getSeconds()));
            }
            if (protocol == null) {
                handlers.put("flow-control-handler", (ChannelHandler)new FlowControlHandler());
                if (this.accessLogHandler != null) {
                    handlers.put("http-access-logger", (ChannelHandler)this.accessLogHandler);
                }
            } else if ("h2".equals(protocol)) {
                HttpToHttp2ConnectionHandler httpToHttp2ConnectionHandler = NettyHttpServer.this.newHttpToHttp2ConnectionHandler();
                handlers.put("http2-connection", (ChannelHandler)httpToHttp2ConnectionHandler);
                this.registerMicronautChannelHandlers(handlers);
                handlers.put("flow-control-handler", (ChannelHandler)new FlowControlHandler());
                if (this.accessLogHandler != null) {
                    handlers.put("http-access-logger", (ChannelHandler)this.accessLogHandler);
                }
            } else {
                handlers.put("http-server-codec", (ChannelHandler)(serverCodec == null ? this.createServerCodec() : serverCodec));
                if (this.accessLogHandler != null) {
                    handlers.put("http-access-logger", (ChannelHandler)this.accessLogHandler);
                }
                this.registerMicronautChannelHandlers(handlers);
                handlers.put("flow-control-handler", (ChannelHandler)new FlowControlHandler());
                handlers.put("http-keep-alive-handler", (ChannelHandler)new HttpServerKeepAliveHandler());
                handlers.put("http-compressor", (ChannelHandler)new SmartHttpContentCompressor(NettyHttpServer.this.nettyEmbeddedServices.getHttpCompressionStrategy()));
                handlers.put("http-decompressor", (ChannelHandler)new HttpContentDecompressor());
            }
            handlers.put("WebSocketServerCompressionHandler", (ChannelHandler)new WebSocketServerCompressionHandler());
            handlers.put("http-streams-codec", (ChannelHandler)new HttpStreamsServerHandler());
            handlers.put("chunk-writer", (ChannelHandler)new ChunkedWriteHandler());
            handlers.put("micronaut-http-decoder", (ChannelHandler)this.requestDecoder);
            if (NettyHttpServer.this.serverConfiguration.isDualProtocol() && NettyHttpServer.this.serverConfiguration.isHttpToHttpsRedirect() && this.useSsl) {
                handlers.put("http-to-https-redirect", (ChannelHandler)new HttpToHttpsRedirectHandler(NettyHttpServer.this.sslConfiguration, NettyHttpServer.this.hostResolver));
            }
            if (this.useSsl) {
                handlers.put("request-certificate-handler", (ChannelHandler)NettyHttpServer.this.requestCertificateHandler);
            }
            handlers.put("micronaut-http-encoder", (ChannelHandler)this.responseEncoder);
            handlers.put("websocket-upgrade-handler", (ChannelHandler)new NettyServerWebSocketUpgradeHandler(NettyHttpServer.this.nettyEmbeddedServices, NettyHttpServer.this.getWebSocketSessionRepository()));
            handlers.put("micronaut-inbound-handler", (ChannelHandler)NettyHttpServer.this.routingHandler);
            return handlers;
        }

        @NotNull
        private HttpServerCodec createServerCodec() {
            return new HttpServerCodec(NettyHttpServer.this.serverConfiguration.getMaxInitialLineLength(), NettyHttpServer.this.serverConfiguration.getMaxHeaderSize(), NettyHttpServer.this.serverConfiguration.getMaxChunkSize(), NettyHttpServer.this.serverConfiguration.isValidateHeaders(), NettyHttpServer.this.serverConfiguration.getInitialBufferSize());
        }
    }
}

