/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.context.event.HttpRequestReceivedEvent;
import io.micronaut.http.netty.stream.HttpStreamsServerHandler;
import io.micronaut.http.server.netty.HttpToHttpsRedirectHandler;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.NettyServerCustomizer;
import io.micronaut.http.server.netty.QuicTokenHandlerImpl;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.SmartHttpContentCompressor;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.decoders.HttpRequestDecoder;
import io.micronaut.http.server.netty.encoders.HttpResponseEncoder;
import io.micronaut.http.server.netty.handler.accesslog.HttpAccessLogHandler;
import io.micronaut.http.server.netty.ssl.HttpRequestCertificateHandler;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3FrameToHttpObjectCodec;
import io.netty.incubator.codec.http3.Http3ServerConnectionHandler;
import io.netty.incubator.codec.quic.QuicServerCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpPipelineBuilder {
    static final Supplier<AttributeKey<StreamPipeline>> STREAM_PIPELINE_ATTRIBUTE = SupplierUtil.memoized(() -> AttributeKey.newInstance((String)"stream-pipeline"));
    private static final Logger LOG = LoggerFactory.getLogger(HttpPipelineBuilder.class);
    private final NettyHttpServer server;
    private final NettyEmbeddedServices embeddedServices;
    private final ServerSslConfiguration sslConfiguration;
    private final RoutingInBoundHandler routingInBoundHandler;
    private final HttpHostResolver hostResolver;
    private final LoggingHandler loggingHandler;
    private final SslContext sslContext;
    private final QuicSslContext quicSslContext;
    private final HttpAccessLogHandler accessLogHandler;
    private final HttpRequestDecoder requestDecoder;
    private final HttpResponseEncoder responseEncoder;
    private final NettyServerCustomizer serverCustomizer;
    private final boolean quic;

    HttpPipelineBuilder(NettyHttpServer server, NettyEmbeddedServices embeddedServices, ServerSslConfiguration sslConfiguration, RoutingInBoundHandler routingInBoundHandler, HttpHostResolver hostResolver, NettyServerCustomizer serverCustomizer, boolean quic) {
        this.server = server;
        this.embeddedServices = embeddedServices;
        this.sslConfiguration = sslConfiguration;
        this.routingInBoundHandler = routingInBoundHandler;
        this.hostResolver = hostResolver;
        this.serverCustomizer = serverCustomizer;
        this.quic = quic;
        Optional<LogLevel> logLevel = server.getServerConfiguration().getLogLevel();
        this.loggingHandler = logLevel.map(level -> new LoggingHandler(NettyHttpServer.class, level)).orElse(null);
        this.sslContext = embeddedServices.getServerSslBuilder() != null && !quic ? (SslContext)embeddedServices.getServerSslBuilder().build().orElse(null) : null;
        this.quicSslContext = quic ? (QuicSslContext)embeddedServices.getServerSslBuilder().buildQuic().orElse(null) : null;
        NettyHttpServerConfiguration.AccessLogger accessLogger = server.getServerConfiguration().getAccessLogger();
        this.accessLogHandler = accessLogger != null && accessLogger.isEnabled() ? new HttpAccessLogHandler(accessLogger.getLoggerName(), accessLogger.getLogFormat(), NettyHttpServer.inclusionPredicate(accessLogger)) : null;
        this.requestDecoder = new HttpRequestDecoder(server, (ConversionService)server.getEnvironment(), server.getServerConfiguration(), embeddedServices.getEventPublisher(HttpRequestReceivedEvent.class));
        this.responseEncoder = new HttpResponseEncoder(embeddedServices.getMediaTypeCodecRegistry(), server.getServerConfiguration(), embeddedServices.getApplicationContext().getConversionService());
    }

    boolean supportsSsl() {
        return this.sslContext != null;
    }

    final class StreamPipeline {
        HttpVersion httpVersion = HttpVersion.HTTP_1_1;
        private final Channel channel;
        private final ChannelPipeline pipeline;
        @Nullable
        private final SslHandler sslHandler;
        private final boolean https;
        private final NettyServerCustomizer streamCustomizer;

        private StreamPipeline(@Nullable Channel channel, SslHandler sslHandler, boolean https, NettyServerCustomizer streamCustomizer) {
            this.channel = channel;
            this.pipeline = channel.pipeline();
            this.sslHandler = sslHandler;
            this.https = https;
            this.streamCustomizer = streamCustomizer;
        }

        void initializeChildPipelineForPushPromise(Channel childChannel) {
            StreamPipeline promisePipeline = new StreamPipeline(childChannel, this.sslHandler, this.https, this.streamCustomizer.specializeForChannel(childChannel, NettyServerCustomizer.ChannelRole.PUSH_PROMISE_STREAM));
            promisePipeline.insertHttp2FrameHandlers();
            promisePipeline.streamCustomizer.onStreamPipelineBuilt();
        }

        private void insertHttp2FrameHandlers() {
            this.pipeline.addLast("http-decoder", (ChannelHandler)new Http2StreamFrameToHttpObjectCodec(true, HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders()));
            this.insertHttp2DownstreamHandlers();
        }

        private void insertHttp3FrameHandlers() {
            this.pipeline.addLast("http-decoder", (ChannelHandler)new Http3FrameToHttpObjectCodec(true, HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders()));
            this.insertHttp2DownstreamHandlers();
        }

        private void insertHttp2DownstreamHandlers() {
            this.httpVersion = HttpVersion.HTTP_2_0;
            this.pipeline.addLast("flow-control-handler", (ChannelHandler)new FlowControlHandler());
            if (HttpPipelineBuilder.this.accessLogHandler != null) {
                this.pipeline.addLast("http-access-logger", (ChannelHandler)HttpPipelineBuilder.this.accessLogHandler);
            }
            this.registerMicronautChannelHandlers();
            this.insertMicronautHandlers(false);
        }

        private void insertMicronautHandlers(boolean zeroCopySupported) {
            this.channel.attr(STREAM_PIPELINE_ATTRIBUTE.get()).set((Object)this);
            SmartHttpContentCompressor contentCompressor = new SmartHttpContentCompressor(HttpPipelineBuilder.this.embeddedServices.getHttpCompressionStrategy());
            if (zeroCopySupported) {
                this.channel.attr(NettySystemFileCustomizableResponseType.ZERO_COPY_PREDICATE.get()).set((Object)contentCompressor);
            }
            this.pipeline.addLast("http-compressor", (ChannelHandler)contentCompressor);
            this.pipeline.addLast("http-decompressor", (ChannelHandler)new HttpContentDecompressor());
            Optional<SimpleChannelInboundHandler<NettyHttpRequest<?>>> webSocketUpgradeHandler = HttpPipelineBuilder.this.embeddedServices.getWebSocketUpgradeHandler(HttpPipelineBuilder.this.server);
            if (webSocketUpgradeHandler.isPresent()) {
                this.pipeline.addLast("WebSocketServerCompressionHandler", (ChannelHandler)new WebSocketServerCompressionHandler());
            }
            if (HttpPipelineBuilder.this.server.getServerConfiguration().getServerType() == NettyHttpServerConfiguration.HttpServerType.STREAMED) {
                this.pipeline.addLast("http-streams-codec", (ChannelHandler)new HttpStreamsServerHandler());
            } else {
                this.pipeline.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator((int)HttpPipelineBuilder.this.server.getServerConfiguration().getMaxRequestSize(), HttpPipelineBuilder.this.server.getServerConfiguration().isCloseOnExpectationFailed()));
            }
            this.pipeline.addLast("chunk-writer", (ChannelHandler)new ChunkedWriteHandler());
            this.pipeline.addLast("micronaut-http-decoder", (ChannelHandler)HttpPipelineBuilder.this.requestDecoder);
            if (HttpPipelineBuilder.this.server.getServerConfiguration().isDualProtocol() && HttpPipelineBuilder.this.server.getServerConfiguration().isHttpToHttpsRedirect() && !this.https) {
                this.pipeline.addLast("http-to-https-redirect", (ChannelHandler)new HttpToHttpsRedirectHandler(HttpPipelineBuilder.this.sslConfiguration, HttpPipelineBuilder.this.hostResolver));
            }
            if (this.sslHandler != null) {
                this.pipeline.addLast("request-certificate-handler", (ChannelHandler)new HttpRequestCertificateHandler(this.sslHandler));
            }
            this.pipeline.addLast("micronaut-http-encoder", (ChannelHandler)HttpPipelineBuilder.this.responseEncoder);
            webSocketUpgradeHandler.ifPresent(h -> this.pipeline.addLast("websocket-upgrade-handler", (ChannelHandler)h));
            this.pipeline.addLast("micronaut-inbound-handler", (ChannelHandler)HttpPipelineBuilder.this.routingInBoundHandler);
        }

        private void insertHttp1DownstreamHandlers() {
            this.httpVersion = HttpVersion.HTTP_1_1;
            if (HttpPipelineBuilder.this.accessLogHandler != null) {
                this.pipeline.addLast("http-access-logger", (ChannelHandler)HttpPipelineBuilder.this.accessLogHandler);
            }
            this.registerMicronautChannelHandlers();
            if (HttpPipelineBuilder.this.server.getServerConfiguration().getServerType() == NettyHttpServerConfiguration.HttpServerType.STREAMED) {
                this.pipeline.addLast("flow-control-handler", (ChannelHandler)new FlowControlHandler());
            }
            this.pipeline.addLast("http-keep-alive-handler", (ChannelHandler)new HttpServerKeepAliveHandler());
            this.insertMicronautHandlers(this.sslHandler == null && !this.https);
        }

        private void registerMicronautChannelHandlers() {
            int i = 0;
            for (ChannelOutboundHandler outboundHandlerAdapter : HttpPipelineBuilder.this.embeddedServices.getOutboundHandlers()) {
                Object name = outboundHandlerAdapter instanceof Named ? ((Named)outboundHandlerAdapter).getName() : "micronaut-inbound-handler-outbound-" + ++i;
                this.pipeline.addLast((String)name, (ChannelHandler)outboundHandlerAdapter);
            }
        }
    }

    final class ConnectionPipeline {
        private final Channel channel;
        private final ChannelPipeline pipeline;
        @Nullable
        private final SslHandler sslHandler;
        private final boolean https;
        private final NettyServerCustomizer connectionCustomizer;

        ConnectionPipeline(Channel channel, boolean tls, boolean https) {
            this.channel = channel;
            this.pipeline = channel.pipeline();
            this.sslHandler = tls ? HttpPipelineBuilder.this.sslContext.newHandler(channel.alloc()) : null;
            this.https = https;
            this.connectionCustomizer = HttpPipelineBuilder.this.serverCustomizer.specializeForChannel(channel, NettyServerCustomizer.ChannelRole.CONNECTION);
        }

        void insertPcapLoggingHandler(Channel ch, String qualifier) {
            String pattern = HttpPipelineBuilder.this.server.getServerConfiguration().getPcapLoggingPathPattern();
            if (pattern == null) {
                return;
            }
            String path = pattern;
            path = path.replace("{qualifier}", qualifier);
            if (ch.localAddress() != null) {
                path = path.replace("{localAddress}", this.resolveIfNecessary(ch.localAddress()));
            }
            if (ch.remoteAddress() != null) {
                path = path.replace("{remoteAddress}", this.resolveIfNecessary(ch.remoteAddress()));
            }
            if (HttpPipelineBuilder.this.quic && ch instanceof QuicStreamChannel) {
                QuicStreamChannel qsc = (QuicStreamChannel)ch;
                path = path.replace("{localAddress}", this.resolveIfNecessary(qsc.parent().localAddress()));
                path = path.replace("{remoteAddress}", this.resolveIfNecessary(qsc.parent().remoteAddress()));
            }
            path = path.replace("{random}", Long.toHexString(ThreadLocalRandom.current().nextLong()));
            path = path.replace("{timestamp}", Instant.now().toString());
            path = path.replace(':', '_');
            LOG.warn("Logging *full* request data, as configured. This will contain sensitive information! Path: '{}'", (Object)path);
            try {
                PcapWriteHandler.Builder builder = PcapWriteHandler.builder();
                if (HttpPipelineBuilder.this.quic && ch instanceof QuicStreamChannel) {
                    QuicStreamChannel qsc = (QuicStreamChannel)ch;
                    builder.forceTcpChannel((InetSocketAddress)qsc.parent().localAddress(), (InetSocketAddress)qsc.parent().remoteAddress(), true);
                }
                ch.pipeline().addLast(new ChannelHandler[]{builder.build((OutputStream)new FileOutputStream(path))});
            }
            catch (FileNotFoundException e) {
                LOG.warn("Failed to create target pcap at '{}', not logging.", (Object)path, (Object)e);
            }
        }

        private String resolveIfNecessary(SocketAddress address) {
            if (address instanceof InetSocketAddress) {
                if (((InetSocketAddress)address).isUnresolved() && ((InetSocketAddress)(address = new InetSocketAddress(((InetSocketAddress)address).getHostString(), ((InetSocketAddress)address).getPort()))).isUnresolved()) {
                    return "unresolved";
                }
                return ((InetSocketAddress)address).getAddress().getHostAddress() + ":" + ((InetSocketAddress)address).getPort();
            }
            String s = address.toString();
            if (s.contains("/")) {
                return "weird";
            }
            return s;
        }

        void initChannel() {
            this.insertOuterTcpHandlers();
            if (HttpPipelineBuilder.this.server.getServerConfiguration().getHttpVersion() != HttpVersion.HTTP_2_0) {
                this.configureForHttp1();
            } else if (this.sslHandler != null) {
                this.configureForAlpn();
            } else {
                this.configureForH2cSupport();
            }
        }

        void initHttp3Channel() {
            this.insertPcapLoggingHandler(this.channel, "udp-encapsulated");
            this.pipeline.addLast(new ChannelHandler[]{((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)((QuicServerCodecBuilder)Http3.newQuicServerCodecBuilder().sslContext(HttpPipelineBuilder.this.quicSslContext)).initialMaxData((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxData())).initialMaxStreamDataBidirectionalLocal((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxStreamDataBidirectionalLocal())).initialMaxStreamDataBidirectionalRemote((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxStreamDataBidirectionalRemote())).initialMaxStreamsBidirectional((long)HttpPipelineBuilder.this.server.getServerConfiguration().getHttp3().getInitialMaxStreamsBidirectional())).tokenHandler(QuicTokenHandlerImpl.create(this.channel.alloc())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(@NonNull Channel ch) throws Exception {
                    ConnectionPipeline.this.insertPcapLoggingHandler(ch, "quic-decapsulated");
                    ch.pipeline().addLast(new ChannelHandler[]{new Http3ServerConnectionHandler((ChannelHandler)new ChannelInitializer<QuicStreamChannel>(){

                        protected void initChannel(@NonNull QuicStreamChannel ch) throws Exception {
                            StreamPipeline streamPipeline = new StreamPipeline((Channel)ch, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.https, ConnectionPipeline.this.connectionCustomizer.specializeForChannel((Channel)ch, NettyServerCustomizer.ChannelRole.REQUEST_STREAM));
                            streamPipeline.insertHttp3FrameHandlers();
                            streamPipeline.streamCustomizer.onStreamPipelineBuilt();
                        }
                    })});
                }
            }).build()});
        }

        void insertOuterTcpHandlers() {
            this.insertPcapLoggingHandler(this.channel, "encapsulated");
            if (this.sslHandler != null) {
                this.sslHandler.setHandshakeTimeoutMillis(HttpPipelineBuilder.this.sslConfiguration.getHandshakeTimeout().toMillis());
                this.pipeline.addLast("ssl", (ChannelHandler)this.sslHandler);
                this.insertPcapLoggingHandler(this.channel, "ssl-decapsulated");
            }
            if (HttpPipelineBuilder.this.loggingHandler != null) {
                this.pipeline.addLast(new ChannelHandler[]{HttpPipelineBuilder.this.loggingHandler});
            }
        }

        private void onRequestPipelineBuilt() {
            HttpPipelineBuilder.this.server.triggerPipelineListeners(this.pipeline);
        }

        private void insertIdleStateHandler() {
            Duration idleTime = HttpPipelineBuilder.this.server.getServerConfiguration().getIdleTimeout();
            if (!idleTime.isNegative()) {
                this.pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler((int)HttpPipelineBuilder.this.server.getServerConfiguration().getReadIdleTimeout().getSeconds(), (int)HttpPipelineBuilder.this.server.getServerConfiguration().getWriteIdleTimeout().getSeconds(), (int)idleTime.getSeconds()));
            }
        }

        void configureForHttp1() {
            this.insertIdleStateHandler();
            this.pipeline.addLast("http-server-codec", (ChannelHandler)this.createServerCodec());
            new StreamPipeline(this.channel, this.sslHandler, this.https, this.connectionCustomizer).insertHttp1DownstreamHandlers();
            this.connectionCustomizer.onInitialPipelineBuilt();
            this.connectionCustomizer.onStreamPipelineBuilt();
            this.onRequestPipelineBuilt();
        }

        private void configureForHttp2() {
            this.insertIdleStateHandler();
            this.pipeline.addLast("http2-connection", (ChannelHandler)this.createHttp2FrameCodec());
            this.pipeline.addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(@NonNull Channel ch) {
                    StreamPipeline streamPipeline = new StreamPipeline(ch, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.https, ConnectionPipeline.this.connectionCustomizer.specializeForChannel(ch, NettyServerCustomizer.ChannelRole.REQUEST_STREAM));
                    streamPipeline.insertHttp2FrameHandlers();
                    streamPipeline.streamCustomizer.onStreamPipelineBuilt();
                }
            })});
            this.connectionCustomizer.onInitialPipelineBuilt();
            this.onRequestPipelineBuilt();
        }

        private Http2FrameCodec createHttp2FrameCodec() {
            Http2FrameCodecBuilder builder = Http2FrameCodecBuilder.forServer().validateHeaders(HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders()).initialSettings(HttpPipelineBuilder.this.server.getServerConfiguration().getHttp2().http2Settings());
            HttpPipelineBuilder.this.server.getServerConfiguration().getLogLevel().ifPresent(logLevel -> builder.frameLogger(new Http2FrameLogger(logLevel, NettyHttpServer.class)));
            return builder.build();
        }

        void configureForAlpn() {
            this.pipeline.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler(HttpPipelineBuilder.this.server.getServerConfiguration().getFallbackProtocol()){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (HttpPipelineBuilder.this.routingInBoundHandler.isIgnorable(cause)) {
                        ctx.close();
                    } else {
                        super.exceptionCaught(ctx, cause);
                    }
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    SslHandshakeCompletionEvent event;
                    if (evt instanceof SslHandshakeCompletionEvent && !(event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                        Throwable cause = event.cause();
                        if (!(cause instanceof ClosedChannelException)) {
                            super.userEventTriggered(ctx, evt);
                        } else {
                            return;
                        }
                    }
                    super.userEventTriggered(ctx, evt);
                }

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    switch (protocol) {
                        case "h2": {
                            ConnectionPipeline.this.configureForHttp2();
                            break;
                        }
                        case "http/1.1": {
                            ConnectionPipeline.this.configureForHttp1();
                            break;
                        }
                        default: {
                            LOG.warn("Negotiated unknown ALPN protocol. Is the fallback protocol configured correctly? Falling back on HTTP 1");
                            ConnectionPipeline.this.configureForHttp1();
                        }
                    }
                    ctx.read();
                }
            }});
        }

        void configureForH2cSupport() {
            this.insertIdleStateHandler();
            Http2FrameCodec connectionHandler = this.createHttp2FrameCodec();
            String fallbackHandlerName = "http1-fallback-handler";
            HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
                if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    return new Http2ServerUpgradeCodec(connectionHandler, new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

                        protected void initChannel(@NonNull Http2StreamChannel ch) {
                            StreamPipeline streamPipeline = new StreamPipeline((Channel)ch, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.https, ConnectionPipeline.this.connectionCustomizer.specializeForChannel((Channel)ch, NettyServerCustomizer.ChannelRole.REQUEST_STREAM));
                            streamPipeline.insertHttp2FrameHandlers();
                            streamPipeline.streamCustomizer.onStreamPipelineBuilt();
                        }
                    })}){

                        public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
                            super.upgradeTo(ctx, upgradeRequest);
                            ConnectionPipeline.this.pipeline.remove("http1-fallback-handler");
                            ConnectionPipeline.this.onRequestPipelineBuilt();
                        }
                    };
                }
                return null;
            };
            HttpServerCodec sourceCodec = this.createServerCodec();
            final HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory, HttpPipelineBuilder.this.server.getServerConfiguration().getMaxH2cUpgradeRequestSize());
            CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)connectionHandler);
            this.pipeline.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
            this.pipeline.addLast("http1-fallback-handler", (ChannelHandler)new SimpleChannelInboundHandler<HttpMessage>(){

                protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) {
                    ChannelPipeline cp = ctx.pipeline();
                    cp.remove((ChannelHandler)upgradeHandler);
                    cp.remove((ChannelHandler)this);
                    new StreamPipeline(ConnectionPipeline.this.channel, ConnectionPipeline.this.sslHandler, ConnectionPipeline.this.https, ConnectionPipeline.this.connectionCustomizer).insertHttp1DownstreamHandlers();
                    ConnectionPipeline.this.connectionCustomizer.onStreamPipelineBuilt();
                    ConnectionPipeline.this.onRequestPipelineBuilt();
                    cp.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                }
            });
            this.connectionCustomizer.onInitialPipelineBuilt();
        }

        @NonNull
        private HttpServerCodec createServerCodec() {
            return new HttpServerCodec(HttpPipelineBuilder.this.server.getServerConfiguration().getMaxInitialLineLength(), HttpPipelineBuilder.this.server.getServerConfiguration().getMaxHeaderSize(), HttpPipelineBuilder.this.server.getServerConfiguration().getMaxChunkSize(), HttpPipelineBuilder.this.server.getServerConfiguration().isValidateHeaders(), HttpPipelineBuilder.this.server.getServerConfiguration().getInitialBufferSize());
        }
    }
}

