/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyRequestLifecycle;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.runtime.http.codec.TextPlainCodec;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Internal
@ChannelHandler.Sharable
final class RoutingInBoundHandler
extends SimpleChannelInboundHandler<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    final StaticResourceResolver staticResourceResolver;
    final NettyHttpServerConfiguration serverConfiguration;
    final HttpContentProcessorResolver httpContentProcessorResolver;
    final RequestArgumentSatisfier requestArgumentSatisfier;
    final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    final NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry;
    final Supplier<ExecutorService> ioExecutorSupplier;
    final boolean multipartEnabled;
    ExecutorService ioExecutor;
    final ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher;
    final RouteExecutor routeExecutor;
    final ConversionService conversionService;

    RoutingInBoundHandler(NettyHttpServerConfiguration serverConfiguration, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, NettyEmbeddedServices embeddedServerContext, Supplier<ExecutorService> ioExecutor, HttpContentProcessorResolver httpContentProcessorResolver, ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher, ConversionService conversionService) {
        this.mediaTypeCodecRegistry = embeddedServerContext.getMediaTypeCodecRegistry();
        this.customizableResponseTypeHandlerRegistry = customizableResponseTypeHandlerRegistry;
        this.staticResourceResolver = embeddedServerContext.getStaticResourceResolver();
        this.ioExecutorSupplier = ioExecutor;
        this.requestArgumentSatisfier = embeddedServerContext.getRequestArgumentSatisfier();
        this.serverConfiguration = serverConfiguration;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.terminateEventPublisher = terminateEventPublisher;
        Optional isMultiPartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || (Boolean)isMultiPartEnabled.get() != false;
        this.routeExecutor = embeddedServerContext.getRouteExecutor();
        this.conversionService = conversionService;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.cleanupIfNecessary(ctx);
    }

    public void channelInactive(@NonNull ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (ctx.channel().isWritable()) {
            ctx.flush();
        }
        this.cleanupIfNecessary(ctx);
    }

    private void cleanupIfNecessary(ChannelHandlerContext ctx) {
        NettyHttpRequest.remove(ctx);
    }

    private void cleanupRequest(ChannelHandlerContext ctx, NettyHttpRequest<?> request) {
        try {
            request.release();
        }
        finally {
            if (!this.terminateEventPublisher.isEmpty()) {
                ctx.executor().execute(() -> {
                    block2: {
                        try {
                            this.terminateEventPublisher.publishEvent((Object)new HttpRequestTerminatedEvent((HttpRequest)request));
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) break block2;
                            LOG.error("Error publishing request terminated event: " + e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            IdleStateEvent idleStateEvent;
            IdleState state;
            if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isIgnorable(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
            }
            return;
        }
        NettyHttpRequest nettyHttpRequest = NettyHttpRequest.remove(ctx);
        if (nettyHttpRequest == null) {
            if (cause instanceof SSLException || cause.getCause() instanceof SSLException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
                }
            } else if (LOG.isErrorEnabled()) {
                LOG.error("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
            }
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            return;
        }
        new NettyRequestLifecycle(this, ctx, nettyHttpRequest).handleException(cause);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest<?> httpRequest) {
        new NettyRequestLifecycle(this, ctx, (NettyHttpRequest)httpRequest).handleNormal();
    }

    void writeResponse(ChannelHandlerContext ctx, NettyHttpRequest<?> nettyHttpRequest, MutableHttpResponse<?> response, Throwable throwable) {
        if (throwable != null) {
            response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, throwable);
        }
        if (response == null) {
            ctx.read();
        } else {
            try {
                this.encodeHttpResponse(ctx, nettyHttpRequest, response, null, response.body());
            }
            catch (Throwable e) {
                response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, e);
                this.encodeHttpResponse(ctx, nettyHttpRequest, response, null, response.body());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private void encodeHttpResponse(ChannelHandlerContext context, NettyHttpRequest<?> nettyRequest, MutableHttpResponse<?> response, @Nullable Argument<Object> bodyType, Object body) {
        boolean isNotHead;
        boolean bl = isNotHead = nettyRequest.getMethod() != HttpMethod.HEAD;
        if (isNotHead) {
            if (body instanceof Writable) {
                this.getIoExecutor().execute(() -> {
                    ByteBuf byteBuf = context.alloc().ioBuffer(128);
                    ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
                    try {
                        Writable writable = (Writable)body;
                        writable.writeTo((OutputStream)outputStream, nettyRequest.getCharacterEncoding());
                        response.body((Object)byteBuf);
                        if (response.getContentType().isEmpty()) {
                            response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).ifPresent(routeInfo -> response.contentType(this.routeExecutor.resolveDefaultResponseContentType((HttpRequest)nettyRequest, routeInfo)));
                        }
                        this.writeFinalNettyResponse(response, nettyRequest, context);
                    }
                    catch (IOException e) {
                        MutableHttpResponse errorResponse = this.routeExecutor.createDefaultErrorResponse((HttpRequest)nettyRequest, (Throwable)e);
                        this.writeFinalNettyResponse(errorResponse, nettyRequest, context);
                    }
                });
            } else if (body instanceof Publisher) {
                response.body(null);
                if (this.serverConfiguration.getServerType() == NettyHttpServerConfiguration.HttpServerType.FULL_CONTENT) {
                    Flux.from(this.mapToHttpContent(nettyRequest, response, body, context)).collectList().subscribe(contents -> {
                        if (contents.size() == 0) {
                            this.setResponseBody(response, Unpooled.EMPTY_BUFFER);
                        } else if (contents.size() == 1) {
                            this.setResponseBody(response, ((HttpContent)contents.get(0)).content().retain());
                        } else {
                            CompositeByteBuf composite = context.alloc().compositeBuffer();
                            for (HttpContent c : contents) {
                                composite.addComponent(true, c.content().retain());
                            }
                            this.setResponseBody(response, (ByteBuf)composite);
                        }
                        for (HttpContent content : contents) {
                            content.release();
                        }
                        this.writeFinalNettyResponse(response, nettyRequest, context);
                    }, error -> {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error occurred writing publisher response: " + error.getMessage(), error);
                        }
                        HttpResponseStatus responseStatus = error instanceof HttpStatusException ? HttpResponseStatus.valueOf((int)((HttpStatusException)error).getStatus().getCode(), (String)error.getMessage()) : HttpResponseStatus.INTERNAL_SERVER_ERROR;
                        context.writeAndFlush((Object)new DefaultHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, responseStatus)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    });
                } else {
                    DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse(this.toNettyResponse((HttpResponse<?>)response), (Publisher<HttpContent>)this.mapToHttpContent(nettyRequest, response, body, context));
                    context.writeAndFlush((Object)streamedResponse);
                    context.read();
                }
            } else {
                this.encodeResponseBody(context, nettyRequest, response, bodyType, body);
                this.writeFinalNettyResponse(response, nettyRequest, context);
            }
        } else {
            response.body(null);
            this.writeFinalNettyResponse(response, nettyRequest, context);
        }
    }

    private Flux<HttpContent> mapToHttpContent(NettyHttpRequest<?> request, MutableHttpResponse<?> response, Object body, ChannelHandlerContext context) {
        RouteInfo routeInfo = response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        boolean hasRouteInfo = routeInfo != null;
        MediaType mediaType = response.getContentType().orElse(null);
        if (mediaType == null && hasRouteInfo) {
            mediaType = this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo);
        }
        boolean isJson = mediaType != null && mediaType.getExtension().equals("json") && this.isJsonFormattable(hasRouteInfo ? routeInfo.getBodyType() : null);
        NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
        Flux bodyPublisher = Flux.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)body, Publisher.class)));
        MediaType finalMediaType = mediaType;
        Flux httpContentPublisher = bodyPublisher.map(message -> {
            DefaultHttpContent httpContent;
            if (message instanceof ByteBuf) {
                ByteBuf bb = (ByteBuf)message;
                httpContent = new DefaultHttpContent(bb);
            } else if (message instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)message;
                Object nativeBuffer = byteBuffer.asNativeBuffer();
                if (nativeBuffer instanceof ByteBuf) {
                    ByteBuf bb = (ByteBuf)nativeBuffer;
                    httpContent = new DefaultHttpContent(bb);
                } else {
                    httpContent = new DefaultHttpContent(Unpooled.copiedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer()));
                }
            } else if (message instanceof byte[]) {
                byte[] bytes = (byte[])message;
                httpContent = new DefaultHttpContent(Unpooled.copiedBuffer((byte[])bytes));
            } else if (message instanceof HttpContent) {
                HttpContent hc = (HttpContent)message;
                httpContent = hc;
            } else {
                Argument bodyType;
                MediaTypeCodec codec = (MediaTypeCodec)this.mediaTypeCodecRegistry.findCodec(finalMediaType, message.getClass()).orElse(new TextPlainCodec(this.serverConfiguration.getDefaultCharset(), this.conversionService));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Encoding emitted response object [{}] using codec: {}", message, (Object)codec);
                }
                ByteBuffer encoded = hasRouteInfo ? ((bodyType = routeInfo.getBodyType()).isInstance(message) ? codec.encode(bodyType, message, (ByteBufferFactory)byteBufferFactory) : codec.encode(message, (ByteBufferFactory)byteBufferFactory)) : codec.encode(message, (ByteBufferFactory)byteBufferFactory);
                httpContent = new DefaultHttpContent((ByteBuf)encoded.asNativeBuffer());
            }
            return httpContent;
        });
        if (isJson) {
            httpContentPublisher = JsonSubscriber.lift((Publisher)httpContentPublisher);
        }
        httpContentPublisher = httpContentPublisher.contextWrite(reactorContext -> reactorContext.put((Object)"micronaut.http.server.request", (Object)request)).doOnNext(httpContent -> context.read()).doAfterTerminate(() -> this.cleanupRequest(context, request));
        return httpContentPublisher;
    }

    private boolean isJsonFormattable(Argument<?> argument) {
        if (argument == null) {
            return false;
        }
        Class javaType = argument.getType();
        if (Publishers.isConvertibleToPublisher((Class)javaType)) {
            javaType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getType();
        }
        return javaType != byte[].class && !ByteBuffer.class.isAssignableFrom(javaType) && !ByteBuf.class.isAssignableFrom(javaType);
    }

    private void encodeResponseBody(ChannelHandlerContext context, HttpRequest<?> request, MutableHttpResponse<?> message, @Nullable Argument<Object> bodyType, Object body) {
        if (body == null) {
            return;
        }
        Optional<NettyCustomizableResponseTypeHandler> typeHandler = this.customizableResponseTypeHandlerRegistry.findTypeHandler(body.getClass());
        if (typeHandler.isPresent()) {
            NettyCustomizableResponseTypeHandler th = typeHandler.get();
            this.setBodyContent(message, new NettyCustomizableResponseTypeHandlerInvoker(th, body));
        } else {
            MediaType mediaType = message.getContentType().orElse(null);
            if (mediaType == null) {
                mediaType = message.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).map(routeInfo -> this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo)).orElse(MediaType.APPLICATION_JSON_TYPE);
                message.contentType(mediaType);
            }
            if (body instanceof CharSequence) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])body.toString().getBytes(message.getCharacterEncoding()));
                this.setResponseBody(message, byteBuf);
            } else if (body instanceof byte[]) {
                byte[] bytes = (byte[])body;
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
                this.setResponseBody(message, byteBuf);
            } else if (body instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)body;
                Object nativeBuffer = byteBuffer.asNativeBuffer();
                if (nativeBuffer instanceof ByteBuf) {
                    ByteBuf bb = (ByteBuf)nativeBuffer;
                    this.setResponseBody(message, bb);
                } else if (nativeBuffer instanceof java.nio.ByteBuffer) {
                    java.nio.ByteBuffer nbb = (java.nio.ByteBuffer)nativeBuffer;
                    ByteBuf byteBuf = Unpooled.wrappedBuffer((java.nio.ByteBuffer)nbb);
                    this.setResponseBody(message, byteBuf);
                }
            } else if (body instanceof ByteBuf) {
                ByteBuf bb = (ByteBuf)body;
                this.setResponseBody(message, bb);
            } else {
                Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(mediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = (MediaTypeCodec)registeredCodec.get();
                    this.encodeBodyWithCodec(message, bodyType, body, codec, context, request);
                } else {
                    TextPlainCodec defaultCodec = new TextPlainCodec(this.serverConfiguration.getDefaultCharset(), this.conversionService);
                    this.encodeBodyWithCodec(message, bodyType, body, (MediaTypeCodec)defaultCodec, context, request);
                }
            }
        }
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, final HttpRequest<?> request, final ChannelHandlerContext context) {
        int httpStatus = message.code();
        HttpVersion httpVersion = request.getHttpVersion();
        boolean isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        boolean decodeError = request instanceof NettyHttpRequest && ((NettyHttpRequest)request).getNativeRequest().decoderResult().isFailure();
        final GenericFutureListener requestCompletor = future -> {
            try {
                Throwable throwable;
                if (!future.isSuccess() && !this.isIgnorable(throwable = future.cause())) {
                    Http2Exception.StreamException se;
                    if (throwable instanceof Http2Exception.StreamException && (se = (Http2Exception.StreamException)throwable).error() == Http2Error.STREAM_CLOSED) {
                        return;
                    }
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Error writing final response: " + throwable.getMessage(), throwable);
                    }
                }
            }
            finally {
                if (request instanceof NettyHttpRequest) {
                    this.cleanupRequest(context, (NettyHttpRequest)request);
                }
                context.read();
            }
        };
        Object body = message.body();
        if (body instanceof NettyCustomizableResponseTypeHandlerInvoker) {
            if (!isHttp2 && !message.getHeaders().contains("Connection")) {
                if (!decodeError && (httpStatus < 500 || this.serverConfiguration.isKeepAliveOnServerError())) {
                    message.getHeaders().set((CharSequence)"Connection", (CharSequence)HttpHeaderValues.KEEP_ALIVE);
                } else {
                    message.getHeaders().set((CharSequence)"Connection", (CharSequence)HttpHeaderValues.CLOSE);
                }
            }
            NettyCustomizableResponseTypeHandlerInvoker handler = (NettyCustomizableResponseTypeHandlerInvoker)body;
            message.body(null);
            handler.invoke(request, message, context).addListener(requestCompletor);
        } else {
            StreamedHttpRequest streamedHttpRequest;
            NettyHttpRequest nettyHttpRequest;
            io.netty.handler.codec.http.HttpRequest nativeRequest;
            final io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
            HttpHeaders nettyHeaders = nettyResponse.headers();
            if (!isHttp2 && !nettyHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
                boolean expectKeepAlive;
                boolean bl = expectKeepAlive = nettyResponse.protocolVersion().isKeepAliveDefault() || request.getHeaders().isKeepAlive();
                if (!decodeError && expectKeepAlive && (httpStatus < 500 || this.serverConfiguration.isKeepAliveOnServerError())) {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                } else {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                }
            }
            if (!nettyHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !nettyHeaders.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                nettyHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            if ((nativeRequest = (nettyHttpRequest = (NettyHttpRequest)request).getNativeRequest()) instanceof StreamedHttpRequest && !(streamedHttpRequest = (StreamedHttpRequest)nativeRequest).isConsumed()) {
                streamedHttpRequest.subscribe((Subscriber)new Subscriber<HttpContent>(){
                    private Subscription streamSub;

                    public void onSubscribe(Subscription s) {
                        this.streamSub = s;
                        s.request(1L);
                    }

                    public void onNext(HttpContent httpContent) {
                        httpContent.release();
                        this.streamSub.request(1L);
                    }

                    public void onError(Throwable t) {
                        RoutingInBoundHandler.this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, (GenericFutureListener<Future<? super Void>>)requestCompletor);
                    }

                    public void onComplete() {
                        RoutingInBoundHandler.this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, (GenericFutureListener<Future<? super Void>>)requestCompletor);
                    }
                });
            } else {
                this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, (GenericFutureListener<Future<? super Void>>)requestCompletor);
            }
        }
    }

    private void syncWriteAndFlushNettyResponse(ChannelHandlerContext context, HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse, GenericFutureListener<Future<? super Void>> requestCompletor) {
        context.writeAndFlush((Object)nettyResponse).addListener(requestCompletor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} - {} {}", new Object[]{nettyResponse.status().code(), request.getMethodName(), request.getUri()});
        }
    }

    @NonNull
    private io.netty.handler.codec.http.HttpResponse toNettyResponse(HttpResponse<?> message) {
        if (message instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)message;
            return builder.toHttpResponse();
        }
        return this.createNettyResponse(message).toHttpResponse();
    }

    @NonNull
    private NettyMutableHttpResponse<?> createNettyResponse(HttpResponse<?> message) {
        Object body = message.body();
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(this.serverConfiguration.isValidateHeaders());
        message.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)nettyHeaders).set(arg_0, arg_1));
        return new NettyMutableHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)message.code(), (String)message.reason()), body instanceof ByteBuf ? body : null, this.conversionService);
    }

    private MutableHttpResponse<?> encodeBodyWithCodec(MutableHttpResponse<?> response, @Nullable Argument<Object> bodyType, Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        try {
            ByteBuf byteBuf = this.encodeBodyAsByteBuf(bodyType, body, codec, context, request);
            this.setResponseBody(response, byteBuf);
            return response;
        }
        catch (LinkageError e) {
            throw new InternalServerException("Fatal error encoding bytebuf: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setResponseBody(MutableHttpResponse<?> response, ByteBuf byteBuf) {
        int len = byteBuf.readableBytes();
        MutableHttpHeaders headers = response.getHeaders();
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(len));
        this.setBodyContent(response, byteBuf);
    }

    private MutableHttpResponse<?> setBodyContent(MutableHttpResponse<?> response, Object bodyContent) {
        MutableHttpResponse res = response.body(bodyContent);
        return res;
    }

    private ByteBuf encodeBodyAsByteBuf(@Nullable Argument<Object> bodyType, Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        ByteBuf byteBuf;
        if (body instanceof ByteBuf) {
            ByteBuf bb;
            byteBuf = bb = (ByteBuf)body;
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            byteBuf = nativeBuffer instanceof ByteBuf ? (ByteBuf)nativeBuffer : Unpooled.wrappedBuffer((java.nio.ByteBuffer)byteBuffer.asNioBuffer());
        } else if (body instanceof byte[]) {
            byte[] bytes = (byte[])body;
            byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        } else if (body instanceof Writable) {
            byteBuf = context.alloc().ioBuffer(128);
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            Writable writable = (Writable)body;
            try {
                writable.writeTo((OutputStream)outputStream, request.getCharacterEncoding());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encoding emitted response object [{}] using codec: {}", body, (Object)codec);
            }
            ByteBuffer wrapped = bodyType != null && bodyType.isInstance(body) ? codec.encode(bodyType, body, (ByteBufferFactory)new NettyByteBufferFactory(context.alloc())) : codec.encode(body, (ByteBufferFactory)new NettyByteBufferFactory(context.alloc()));
            byteBuf = ((ByteBuf)wrapped.asNativeBuffer()).retain();
            if (wrapped instanceof ReferenceCounted) {
                ((ReferenceCounted)wrapped).release();
            }
        }
        return byteBuf;
    }

    boolean isIgnorable(Throwable cause) {
        if (cause instanceof ClosedChannelException || cause.getCause() instanceof ClosedChannelException) {
            return true;
        }
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    private static class NettyCustomizableResponseTypeHandlerInvoker {
        final NettyCustomizableResponseTypeHandler handler;
        final Object body;

        NettyCustomizableResponseTypeHandlerInvoker(NettyCustomizableResponseTypeHandler handler, Object body) {
            this.handler = handler;
            this.body = body;
        }

        ChannelFuture invoke(HttpRequest<?> request, MutableHttpResponse response, ChannelHandlerContext channelHandlerContext) {
            return this.handler.handle(this.body, request, response, channelHandlerContext);
        }
    }
}

