/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.PublisherBodyBinder;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;

@Internal
public class CompletableFutureBodyBinder
implements NonBlockingBodyArgumentBinder<CompletableFuture<?>> {
    private static final Argument<CompletableFuture<?>> TYPE = Argument.of(CompletableFuture.class);
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final ConversionService conversionService;
    private final BeanProvider<HttpServerConfiguration> httpServerConfiguration;

    public CompletableFutureBodyBinder(HttpContentProcessorResolver httpContentProcessorResolver, ConversionService conversionService, BeanProvider<HttpServerConfiguration> httpServerConfiguration) {
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.conversionService = conversionService;
        this.httpServerConfiguration = httpServerConfiguration;
    }

    @NonNull
    public List<Class<?>> superTypes() {
        return Arrays.asList(CompletionStage.class, Future.class);
    }

    public Argument<CompletableFuture<?>> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<CompletableFuture<?>> bind(ArgumentConversionContext<CompletableFuture<?>> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            ImmediateByteBody immediate;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            ByteBody rootBody = nhr.rootBody();
            if (rootBody instanceof ImmediateByteBody && (immediate = (ImmediateByteBody)rootBody).empty()) {
                return ArgumentBinder.BindingResult.EMPTY;
            }
            Optional firstTypeParameter = context.getFirstTypeVariable();
            Argument targetType = firstTypeParameter.orElse(Argument.OBJECT_ARGUMENT);
            try {
                ExecutionFlow retFlow = rootBody.buffer(nhr.getChannelHandlerContext().alloc()).map(bytes -> {
                    try {
                        return bytes.processSingle(this.httpContentProcessorResolver.resolve(nhr, targetType), ((HttpServerConfiguration)this.httpServerConfiguration.get()).getDefaultCharset(), nhr.getChannelHandlerContext().alloc());
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
                CompletableFuture future = retFlow.map(immediateSingleObjectBody -> {
                    Object claimed = immediateSingleObjectBody.claimForExternal();
                    if (firstTypeParameter.isPresent()) {
                        return PublisherBodyBinder.convertAndRelease(this.conversionService, context.with(targetType), claimed);
                    }
                    return claimed;
                }).toCompletableFuture();
                return () -> Optional.of(future);
            }
            catch (Throwable e) {
                return () -> Optional.of(CompletableFuture.failedFuture(e));
            }
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

