/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.MicronautHttpData;
import io.micronaut.http.server.netty.body.ImmediateSingleObjectBody;
import io.micronaut.http.server.netty.body.ManagedBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;

@Internal
public final class ImmediateMultiObjectBody
extends ManagedBody<List<?>>
implements MultiObjectBody {
    ImmediateMultiObjectBody(List<?> objects) {
        super(objects);
    }

    @Override
    void release(List<?> value) {
        value.forEach(ImmediateSingleObjectBody::release0);
    }

    public ImmediateSingleObjectBody single(Charset defaultCharset, ByteBufAllocator alloc) {
        List objects = (List)this.prepareClaim();
        if (objects.isEmpty()) {
            return this.next(new ImmediateSingleObjectBody((Object)null));
        }
        boolean allFormData = true;
        for (Object object : objects) {
            if (object instanceof MicronautHttpData) continue;
            allFormData = false;
            break;
        }
        if (allFormData) {
            return this.next(new ImmediateSingleObjectBody(ImmediateMultiObjectBody.toMap(defaultCharset, objects)));
        }
        if (objects.size() == 1) {
            Object object;
            Object o = objects.get(0);
            if (o instanceof ByteBufHolder) {
                ByteBufHolder bbh = (ByteBufHolder)o;
                object = bbh.content();
            } else {
                object = o;
            }
            return this.next(new ImmediateSingleObjectBody(object));
        }
        return this.next(new ImmediateSingleObjectBody(ImmediateMultiObjectBody.coerceToComposite(objects, alloc)));
    }

    private static CompositeByteBuf coerceToComposite(List<?> objects, ByteBufAllocator alloc) {
        CompositeByteBuf composite = alloc.compositeBuffer();
        for (Object object : objects) {
            composite.addComponent(true, ((ByteBufHolder)object).content());
        }
        return composite;
    }

    public static Map<String, Object> toMap(Charset charset, Collection<? extends MicronautHttpData<?>> dataList) {
        LinkedHashMap singleMap = CollectionUtils.newLinkedHashMap((int)dataList.size());
        LinkedHashMap multiMap = new LinkedHashMap();
        for (MicronautHttpData<?> data : dataList) {
            String newValue;
            String key = data.getName();
            try {
                newValue = data.getString(charset);
            }
            catch (IOException e) {
                throw new InternalServerException("Error retrieving or decoding the value for: " + data.getName());
            }
            List multi = (List)multiMap.get(key);
            if (multi != null) {
                multi.add(newValue);
                continue;
            }
            String existing = singleMap.put(key, newValue);
            if (existing == null) continue;
            ArrayList<String> combined = new ArrayList<String>(2);
            combined.add(existing);
            combined.add(newValue);
            singleMap.put(key, combined);
            multiMap.put(key, combined);
        }
        return singleMap;
    }

    @Override
    public InputStream coerceToInputStream(ByteBufAllocator alloc) {
        List objects = (List)this.claim();
        ByteBuf buf = switch (objects.size()) {
            case 0 -> Unpooled.EMPTY_BUFFER;
            case 1 -> ((ByteBufHolder)objects.get(0)).content();
            default -> ImmediateMultiObjectBody.coerceToComposite(objects, alloc);
        };
        return new ByteBufInputStream(buf, true);
    }

    @Override
    public Publisher<?> asPublisher() {
        return Flux.fromIterable((Iterable)((Iterable)this.claim())).doOnDiscard(ReferenceCounted.class, ReferenceCounted::release);
    }

    @Override
    public MultiObjectBody mapNotNull(Function<Object, Object> transform) {
        return this.next(new ImmediateMultiObjectBody(((List)this.prepareClaim()).stream().map(transform).toList()));
    }

    @Override
    public void handleForm(FormRouteCompleter formRouteCompleter) {
        Flux.fromIterable((Iterable)((Iterable)this.prepareClaim())).subscribe((Subscriber)formRouteCompleter);
        this.next(formRouteCompleter);
    }
}

