/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.multipart.MultipartBody;
import io.micronaut.http.server.netty.DefaultHttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyHttpServer;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.micronaut.http.server.netty.multipart.NettyCompletedAttribute;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.micronaut.web.router.qualifier.ConsumesMediaTypeQualifier;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.util.ReferenceCounted;
import java.util.HashSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Internal
public class MultipartBodyArgumentBinder
implements NonBlockingBodyArgumentBinder<MultipartBody> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final BeanLocator beanLocator;
    private final BeanProvider<HttpServerConfiguration> httpServerConfiguration;

    public MultipartBodyArgumentBinder(BeanLocator beanLocator, BeanProvider<HttpServerConfiguration> httpServerConfiguration) {
        this.beanLocator = beanLocator;
        this.httpServerConfiguration = httpServerConfiguration;
    }

    public Argument<MultipartBody> argumentType() {
        return Argument.of(MultipartBody.class);
    }

    public ArgumentBinder.BindingResult<MultipartBody> bind(ArgumentConversionContext<MultipartBody> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            MultiObjectBody multiObjectBody;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            HttpContentProcessor processor = this.beanLocator.findBean(HttpContentSubscriberFactory.class, (Qualifier)new ConsumesMediaTypeQualifier(MediaType.MULTIPART_FORM_DATA_TYPE)).map(factory -> factory.build(nhr)).orElse(new DefaultHttpContentProcessor(nhr, (HttpServerConfiguration)this.httpServerConfiguration.get()));
            try {
                multiObjectBody = nhr.rootBody().processMulti(processor);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            HashSet partial = new HashSet();
            Flux completed = Flux.from(multiObjectBody.asPublisher()).mapNotNull(message -> {
                if (message.isCompleted() && message.length() != 0L) {
                    partial.remove(message);
                    if (message instanceof FileUpload) {
                        FileUpload fu = (FileUpload)message;
                        return new NettyCompletedFileUpload(fu, true);
                    }
                    return new NettyCompletedAttribute((Attribute)message, true);
                }
                partial.add(message);
                return null;
            }).doOnTerminate(() -> partial.forEach(ReferenceCounted::release));
            return () -> Optional.of(arg_0 -> ((Flux)completed).subscribe(arg_0));
        }
        return ArgumentBinder.BindingResult.empty();
    }
}

