/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.ssl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMessage;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;

@Internal
public class HttpRequestCertificateHandler
extends ChannelInboundHandlerAdapter {
    private final SslHandler sslHandler;
    private Certificate certificate;

    public HttpRequestCertificateHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpMessage) {
            HttpMessage http = (HttpMessage)msg;
            if (this.certificate == null) {
                this.certificate = HttpRequestCertificateHandler.getCertificate(this.sslHandler);
                if (this.certificate == null) {
                    ctx.pipeline().remove((ChannelHandler)this);
                    super.channelRead(ctx, msg);
                    return;
                }
            }
            http.setAttribute((CharSequence)HttpAttributes.X509_CERTIFICATE, (Object)this.certificate);
        }
        super.channelRead(ctx, msg);
    }

    @Nullable
    private static Certificate getCertificate(SslHandler handler) {
        try {
            return handler.engine().getSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException ex) {
            return null;
        }
    }
}

