/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.types.files;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettyStreamedFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.types.CustomizableResponseTypeException;
import io.micronaut.http.server.types.files.StreamedFile;
import io.micronaut.http.server.types.files.SystemFile;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;

@Internal
public class FileTypeHandler
implements NettyCustomizableResponseTypeHandler<Object> {
    private static final String[] ENTITY_HEADERS = new String[]{"Allow", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Expires", "Last-Modified"};
    private static final Class<?>[] SUPPORTED_TYPES = new Class[]{File.class, StreamedFile.class, NettyFileCustomizableResponseType.class, SystemFile.class};
    private final NettyHttpServerConfiguration.FileTypeHandlerConfiguration configuration;

    public FileTypeHandler(NettyHttpServerConfiguration.FileTypeHandlerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ChannelFuture handle(Object obj, HttpRequest<?> request, MutableHttpResponse<?> response, ChannelHandlerContext context) {
        long fileLastModifiedSeconds;
        long ifModifiedSinceDateSeconds;
        NettyFileCustomizableResponseType type;
        if (obj instanceof File) {
            type = new NettySystemFileCustomizableResponseType((File)obj);
        } else if (obj instanceof NettyFileCustomizableResponseType) {
            type = (NettyFileCustomizableResponseType)obj;
        } else if (obj instanceof StreamedFile) {
            type = new NettyStreamedFileCustomizableResponseType((StreamedFile)obj);
        } else if (obj instanceof SystemFile) {
            type = new NettySystemFileCustomizableResponseType((SystemFile)obj);
        } else {
            throw new CustomizableResponseTypeException("FileTypeHandler only supports File or FileCustomizableResponseType types");
        }
        long lastModified = type.getLastModified();
        ZonedDateTime ifModifiedSince = request.getHeaders().getDate((CharSequence)"If-Modified-Since");
        if (ifModifiedSince != null && (ifModifiedSinceDateSeconds = ifModifiedSince.toEpochSecond()) == (fileLastModifiedSeconds = lastModified / 1000L)) {
            FullHttpResponse nettyResponse = this.notModified(response);
            return context.writeAndFlush((Object)nettyResponse);
        }
        if (!response.getHeaders().contains("Content-Type")) {
            response.header((CharSequence)"Content-Type", (CharSequence)type.getMediaType().toString());
        }
        this.setDateAndCacheHeaders(response, lastModified);
        type.process(response);
        return type.write(request, response, context);
    }

    @Override
    public boolean supports(Class<?> type) {
        return Arrays.stream(SUPPORTED_TYPES).anyMatch(aClass -> aClass.isAssignableFrom(type));
    }

    protected void setDateAndCacheHeaders(MutableHttpResponse response, long lastModified) {
        MutableHttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        if (!headers.contains("Date")) {
            headers.date(now);
        }
        LocalDateTime cacheSeconds = now.plus(this.configuration.getCacheSeconds(), ChronoUnit.SECONDS);
        if (response.header((CharSequence)"Expires") == null) {
            headers.expires(cacheSeconds);
        }
        if (response.header((CharSequence)"Cache-Control") == null) {
            NettyHttpServerConfiguration.FileTypeHandlerConfiguration.CacheControlConfiguration cacheConfig = this.configuration.getCacheControl();
            StringBuilder header = new StringBuilder(cacheConfig.getPublic() ? "public" : "private").append(", max-age=").append(this.configuration.getCacheSeconds());
            response.header((CharSequence)"Cache-Control", (CharSequence)header.toString());
        }
        if (response.header((CharSequence)"Last-Modified") == null) {
            headers.lastModified(lastModified);
        }
    }

    protected void setDateHeader(MutableHttpResponse response) {
        MutableHttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        headers.date(now);
    }

    private static void copyNonEntityHeaders(MutableHttpResponse<?> from, MutableHttpResponse to) {
        from.getHeaders().forEachValue((header, value) -> {
            if (Arrays.binarySearch(ENTITY_HEADERS, header) < 0) {
                to.getHeaders().add((CharSequence)header, (CharSequence)value);
            }
        });
    }

    private FullHttpResponse notModified(MutableHttpResponse<?> originalResponse) {
        MutableHttpResponse response = HttpResponse.notModified();
        FileTypeHandler.copyNonEntityHeaders(originalResponse, response);
        this.setDateHeader(response);
        return ((NettyMutableHttpResponse)response).toFullHttpResponse();
    }
}

