/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.NonBlockingBodyArgumentBinder;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.multipart.MultipartBody;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.micronaut.http.server.netty.multipart.NettyCompletedAttribute;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.util.ReferenceCounted;
import java.util.HashSet;
import java.util.Optional;
import reactor.core.publisher.Flux;

@Internal
public class MultipartBodyArgumentBinder
implements NonBlockingBodyArgumentBinder<MultipartBody> {
    private final BeanProvider<HttpServerConfiguration> httpServerConfiguration;

    public MultipartBodyArgumentBinder(BeanLocator beanLocator, BeanProvider<HttpServerConfiguration> httpServerConfiguration) {
        this.httpServerConfiguration = httpServerConfiguration;
    }

    public Argument<MultipartBody> argumentType() {
        return Argument.of(MultipartBody.class);
    }

    public ArgumentBinder.BindingResult<MultipartBody> bind(ArgumentConversionContext<MultipartBody> context, HttpRequest<?> source) {
        if (source instanceof NettyHttpRequest) {
            MultiObjectBody multiObjectBody;
            NettyHttpRequest nhr = (NettyHttpRequest)source;
            FormDataHttpContentProcessor processor = new FormDataHttpContentProcessor(nhr, (HttpServerConfiguration)this.httpServerConfiguration.get());
            try {
                multiObjectBody = nhr.rootBody().processMulti(processor);
            }
            catch (Throwable e) {
                return () -> Optional.of(arg_0 -> ((Flux)Flux.error((Throwable)e)).subscribe(arg_0));
            }
            HashSet partial = new HashSet();
            Flux completed = Flux.from(multiObjectBody.asPublisher()).mapNotNull(message -> {
                if (message.isCompleted() && message.length() != 0L) {
                    partial.remove(message);
                    if (message instanceof FileUpload) {
                        FileUpload fu = (FileUpload)message;
                        return new NettyCompletedFileUpload(fu, true);
                    }
                    return new NettyCompletedAttribute((Attribute)message, true);
                }
                partial.add(message);
                return null;
            }).doOnTerminate(() -> partial.forEach(ReferenceCounted::release));
            return () -> Optional.of(arg_0 -> ((Flux)completed).subscribe(arg_0));
        }
        return ArgumentBinder.BindingResult.empty();
    }
}

