/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.HttpBodyReused;
import io.micronaut.http.server.netty.body.ImmediateMultiObjectBody;
import io.micronaut.http.server.netty.body.ImmediateSingleObjectBody;
import io.micronaut.http.server.netty.body.ManagedBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class ImmediateByteBody
extends ManagedBody<ByteBuf>
implements ByteBody {
    private final boolean empty;

    ImmediateByteBody(ByteBuf buf) {
        super(buf);
        this.empty = !buf.isReadable();
    }

    @Override
    void release(ByteBuf value) {
        value.release();
    }

    @Override
    public MultiObjectBody processMulti(FormDataHttpContentProcessor processor) throws Throwable {
        ByteBuf data = (ByteBuf)this.prepareClaim();
        Object item = processor.processSingle(data);
        if (item != null) {
            return this.next(new ImmediateSingleObjectBody(item));
        }
        return this.next(this.processMultiImpl(processor, data));
    }

    @Override
    public ImmediateSingleObjectBody rawContent(HttpServerConfiguration configuration) throws ContentLengthExceededException {
        ByteBuf buf = (ByteBuf)this.prepareClaim();
        ImmediateByteBody.checkLength(configuration, buf.readableBytes());
        return this.next(new ImmediateSingleObjectBody(buf));
    }

    static void checkLength(HttpServerConfiguration configuration, long n) {
        if (n > configuration.getMaxRequestSize()) {
            throw new ContentLengthExceededException(configuration.getMaxRequestSize(), n);
        }
    }

    @NonNull
    private ImmediateMultiObjectBody processMultiImpl(FormDataHttpContentProcessor processor, ByteBuf data) throws Throwable {
        ArrayList<Object> out = new ArrayList<Object>(1);
        if (data.isReadable()) {
            data.retain();
            processor.add((ByteBufHolder)new DefaultLastHttpContent(data), out);
        }
        data.release();
        processor.complete(out);
        return new ImmediateMultiObjectBody((List<?>)out);
    }

    public ImmediateSingleObjectBody processSingle(FormDataHttpContentProcessor processor, Charset defaultCharset, ByteBufAllocator alloc) throws Throwable {
        return this.next(this.processMultiImpl(processor, (ByteBuf)this.prepareClaim()).single(defaultCharset, alloc));
    }

    public <T> ImmediateSingleObjectBody processSingle(HttpServerConfiguration configuration, MessageBodyReader<T> reader, Argument<T> type, MediaType mediaType, Headers httpHeaders) {
        ByteBuf buf = (ByteBuf)this.prepareClaim();
        ImmediateByteBody.checkLength(configuration, buf.readableBytes());
        ByteBuffer wrapped = NettyByteBufferFactory.DEFAULT.wrap(buf);
        Object read = reader.read(type, mediaType, httpHeaders, wrapped);
        return this.next(new ImmediateSingleObjectBody(read));
    }

    @Override
    public ExecutionFlow<ImmediateByteBody> buffer(ByteBufAllocator alloc) {
        return ExecutionFlow.just((Object)this);
    }

    @Override
    public HttpRequest claimForReuse(HttpRequest request) {
        DefaultFullHttpRequest copy = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), (ByteBuf)this.prepareClaim(), request.headers(), LastHttpContent.EMPTY_LAST_CONTENT.trailingHeaders());
        copy.setDecoderResult(request.decoderResult());
        this.next(new HttpBodyReused());
        return copy;
    }

    public boolean empty() {
        return this.empty;
    }
}

