/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.netty.jackson.JsonViewCodecResolver;
import io.micronaut.json.JsonConfiguration;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.web.router.RouteInfo;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Requirements(value={@Requires(beans={JsonConfiguration.class}), @Requires(classes={JsonView.class}), @Requires(property="jackson.json-view.enabled")})
@ServerFilter(value={"/**"})
@Internal
public class JsonViewServerFilter
implements Ordered {
    public static final String PROPERTY_JSON_VIEW_ENABLED = "jackson.json-view.enabled";
    private final JsonViewCodecResolver codecFactory;
    private final ExecutorService executorService;
    private final ConversionService conversionService;

    public JsonViewServerFilter(JsonViewCodecResolver jsonViewCodecResolver, @Named(value="blocking") ExecutorService executorService, ConversionService conversionService) {
        this.codecFactory = jsonViewCodecResolver;
        this.executorService = executorService;
        this.conversionService = conversionService;
    }

    @ResponseFilter
    public final Publisher<? extends MutableHttpResponse<?>> doFilter(HttpRequest<?> request, MutableHttpResponse<?> response) {
        Optional optionalBody;
        Optional viewClass;
        RouteInfo routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        if (routeInfo != null && (viewClass = routeInfo.findAnnotation(JsonView.class).flatMap(AnnotationValue::classValue)).isPresent() && (optionalBody = response.getBody()).isPresent()) {
            Object body = optionalBody.get();
            JsonMediaTypeCodec codec = this.codecFactory.resolveJsonViewCodec((Class)viewClass.get());
            if (Publishers.isConvertibleToPublisher(body)) {
                Publisher pub = (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, body, Publisher.class);
                response.body((Object)Flux.from((Publisher)pub).map(arg_0 -> JsonViewServerFilter.lambda$doFilter$0((MediaTypeCodec)codec, routeInfo, arg_0)).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.executorService)));
            } else {
                return Mono.fromCallable(() -> JsonViewServerFilter.lambda$doFilter$1((MediaTypeCodec)codec, routeInfo, body, response)).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.executorService));
            }
        }
        return Mono.just(response);
    }

    public int getOrder() {
        return ServerFilterPhase.RENDERING.order();
    }

    private static /* synthetic */ MutableHttpResponse lambda$doFilter$1(MediaTypeCodec codec, RouteInfo routeInfo, Object body, MutableHttpResponse response) throws Exception {
        byte[] encoded = codec.encode(routeInfo.getResponseBodyType(), body);
        response.body((Object)encoded);
        return response;
    }

    private static /* synthetic */ byte[] lambda$doFilter$0(MediaTypeCodec codec, RouteInfo routeInfo, Object o) {
        return codec.encode(routeInfo.getResponseBodyType(), o);
    }
}

