/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaders;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

final class DateTimeElement
implements LogElement {
    public static final String DATE_TIME = "t";
    private static final String COMMON_LOG_PATTERN = "'['dd/MMM/yyyy:HH:mm:ss Z']'";
    private static final Set<LogElement.Event> LAST_RESPONSE_EVENTS = Collections.unmodifiableSet(EnumSet.of(LogElement.Event.ON_LAST_RESPONSE_WRITE));
    private final DateTimeFormatter formatter;
    private final Set<LogElement.Event> events;
    private final String dateFormat;

    DateTimeElement(String dateFormat) {
        boolean fromStart;
        String format;
        if (dateFormat == null) {
            format = COMMON_LOG_PATTERN;
            fromStart = true;
        } else {
            boolean bl = fromStart = !dateFormat.startsWith("end:");
            if (dateFormat.startsWith("begin:")) {
                format = dateFormat.substring("begin:".length());
                fromStart = true;
            } else if (dateFormat.startsWith("end:")) {
                format = dateFormat.substring("end:".length());
                fromStart = false;
            } else {
                format = dateFormat;
            }
        }
        this.dateFormat = dateFormat;
        String[] formatSplit = format.split(",");
        this.formatter = formatSplit.length < 2 ? DateTimeFormatter.ofPattern(format, Locale.US) : DateTimeFormatter.ofPattern(formatSplit[0], Locale.US).withZone(ZoneId.of(formatSplit[1].strip()));
        this.events = fromStart ? LogElement.Event.REQUEST_HEADERS_EVENTS : LAST_RESPONSE_EVENTS;
    }

    @Override
    public Set<LogElement.Event> events() {
        return this.events;
    }

    @Override
    public String onRequestHeaders(SocketChannel channel, String method, HttpHeaders headers, String uri, String protocol) {
        if (this.events.contains((Object)LogElement.Event.ON_REQUEST_HEADERS)) {
            return ZonedDateTime.now().format(this.formatter);
        }
        return "-";
    }

    @Override
    public String onLastResponseWrite(int contentSize) {
        if (this.events.contains((Object)LogElement.Event.ON_LAST_RESPONSE_WRITE)) {
            return ZonedDateTime.now().format(this.formatter);
        }
        return "-";
    }

    @Override
    public LogElement copy() {
        return this;
    }

    public String toString() {
        return this.dateFormat == null ? "%t" : "%{" + this.dateFormat + "}t";
    }
}

