/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.multipart;

import io.micronaut.buffer.netty.NettyReadBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.AsyncSingleResultPublisher;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.functional.ThrowingSupplier;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.stream.PublisherAsBlocking;
import io.micronaut.http.body.stream.PublisherAsStream;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.multipart.PartData;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Internal
public final class NettyStreamingFileUpload
implements StreamingFileUpload {
    private static final Logger LOG = LoggerFactory.getLogger(NettyStreamingFileUpload.class);
    private final FileUpload fileUpload;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final ExecutorService ioExecutor;
    private final HttpServerConfiguration.MultipartConfiguration configuration;
    private final Flux<PartData> subject;

    private NettyStreamingFileUpload(FileUpload httpData, HttpServerConfiguration.MultipartConfiguration multipartConfiguration, ExecutorService ioExecutor, Flux<PartData> subject) {
        this.configuration = multipartConfiguration;
        this.fileUpload = httpData;
        this.ioExecutor = ioExecutor;
        this.subject = subject.doOnTerminate(this::discard);
    }

    public Optional<MediaType> getContentType() {
        return Optional.of(new MediaType(this.fileUpload.getContentType(), NameUtils.extension((String)this.fileUpload.getFilename())));
    }

    public String getName() {
        return this.fileUpload.getName();
    }

    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    public long getSize() {
        return this.fileUpload.length();
    }

    public long getDefinedSize() {
        return this.fileUpload.definedLength();
    }

    public boolean isComplete() {
        return this.fileUpload.isCompleted();
    }

    public Publisher<Boolean> transferTo(String location) {
        String baseDirectory = this.configuration.getLocation().map(File::getAbsolutePath).orElse(DiskFileUpload.baseDirectory);
        File file = baseDirectory == null ? this.createTemp(location) : new File(baseDirectory, location);
        return this.transferTo(file);
    }

    public Publisher<Boolean> transferTo(File destination) {
        return this.transferTo((ThrowingSupplier<OutputStream, IOException>)((ThrowingSupplier)() -> Files.newOutputStream(destination.toPath(), new OpenOption[0])));
    }

    public Publisher<Boolean> transferTo(OutputStream outputStream) {
        return this.transferTo((ThrowingSupplier<OutputStream, IOException>)((ThrowingSupplier)() -> outputStream));
    }

    public Publisher<Boolean> delete() {
        return new AsyncSingleResultPublisher(this.ioExecutor, () -> {
            this.fileUpload.delete();
            return true;
        });
    }

    public InputStream asInputStream() {
        PublisherAsBlocking publisherAsBlocking = new PublisherAsBlocking();
        this.subject.map(pd -> {
            ByteBuf byteBuf = ((NettyPartData)pd).getByteBuf();
            return NettyReadBufferFactory.of((ByteBufAllocator)byteBuf.alloc()).adapt(byteBuf);
        }).subscribe((Subscriber)publisherAsBlocking);
        return new PublisherAsStream(publisherAsBlocking);
    }

    private File createTemp(String location) {
        try {
            return Files.createTempFile("FUp_", ".tmp_" + location, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new MultipartException("Unable to create temp file: " + e.getMessage(), (Throwable)e);
        }
    }

    public void subscribe(Subscriber<? super PartData> s) {
        this.subject.subscribe(s);
    }

    public void discard() {
        if (this.released.compareAndSet(false, true)) {
            this.fileUpload.release();
        }
    }

    private Publisher<Boolean> transferTo(final ThrowingSupplier<OutputStream, IOException> outputStreamSupplier) {
        return Mono.create(emitter -> this.subject.publishOn(Schedulers.fromExecutorService((ExecutorService)this.ioExecutor)).subscribe((Subscriber)new Subscriber<PartData>(){
            Subscription subscription;
            OutputStream outputStream;

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                this.subscription.request(1L);
                try {
                    this.outputStream = (OutputStream)outputStreamSupplier.get();
                }
                catch (IOException e) {
                    this.handleError(e);
                }
            }

            public void onNext(PartData o) {
                try {
                    this.outputStream.write(o.getBytes());
                    this.subscription.request(1L);
                }
                catch (IOException e) {
                    this.handleError(e);
                }
            }

            public void onError(Throwable t) {
                block3: {
                    NettyStreamingFileUpload.this.discard();
                    emitter.error(t);
                    try {
                        if (this.outputStream != null) {
                            this.outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        if (!LOG.isWarnEnabled()) break block3;
                        LOG.warn("Failed to close file stream : {}", (Object)NettyStreamingFileUpload.this.fileUpload.getName());
                    }
                }
            }

            public void onComplete() {
                NettyStreamingFileUpload.this.discard();
                try {
                    this.outputStream.close();
                    emitter.success((Object)true);
                }
                catch (IOException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Failed to close file stream : {}", (Object)NettyStreamingFileUpload.this.fileUpload.getName());
                    }
                    emitter.success((Object)false);
                }
            }

            private void handleError(Throwable t) {
                this.subscription.cancel();
                this.onError((Throwable)new MultipartException("Error transferring file: " + NettyStreamingFileUpload.this.fileUpload.getName(), t));
            }
        })).flux();
    }

    @Internal
    public record Factory(HttpServerConfiguration.MultipartConfiguration multipartConfiguration, ExecutorService ioExecutor) {
        public NettyStreamingFileUpload create(FileUpload httpData, Flux<PartData> subject) {
            return new NettyStreamingFileUpload(httpData, this.multipartConfiguration, this.ioExecutor, subject);
        }
    }
}

