/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.MicronautHttpData;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.buffer.ByteBufHolder;
import io.netty.contrib.multipart.DecoderQuirk;
import io.netty.contrib.multipart.FormDecoderException;
import io.netty.contrib.multipart.TooManyFormFieldsException;
import io.netty.contrib.multipart.vintage.HttpPostRequestDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

@Internal
public final class FormDataHttpContentProcessor {
    private static boolean contribCodecMissing;
    protected final NettyHttpRequest<?> nettyHttpRequest;
    protected final long advertisedLength;
    protected final long requestMaxSize;
    protected final AtomicLong receivedLength = new AtomicLong();
    protected final NettyHttpServerConfiguration configuration;
    private final InterfaceHttpPostRequestDecoder decoder;
    private final long partMaxSize;
    private volatile boolean pleaseDestroy = false;
    private volatile boolean inFlight = false;
    private boolean destroyed = false;
    private boolean receivedLast = false;

    public FormDataHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration) {
        this.nettyHttpRequest = nettyHttpRequest;
        this.advertisedLength = nettyHttpRequest.getContentLength();
        this.requestMaxSize = configuration.getMaxRequestSize();
        this.configuration = configuration;
        Charset characterEncoding = nettyHttpRequest.getCharacterEncoding();
        HttpServerConfiguration.MultipartConfiguration multipart = configuration.getMultipart();
        MicronautHttpData.Factory factory = new MicronautHttpData.Factory(multipart, characterEncoding);
        HttpRequest nativeRequest = nettyHttpRequest.toHttpRequestWithoutBody();
        this.decoder = FormDataHttpContentProcessor.createDecoder(factory, nativeRequest, characterEncoding, configuration);
        this.partMaxSize = multipart.getMaxFileSize();
    }

    private static InterfaceHttpPostRequestDecoder createDecoder(HttpDataFactory factory, HttpRequest request, Charset charset, NettyHttpServerConfiguration configuration) {
        if (!contribCodecMissing) {
            try {
                HttpPostRequestDecoder.Builder builder = io.netty.contrib.multipart.vintage.HttpPostRequestDecoder.builder().dataFactory(factory).charset(charset).maxFields(configuration.getFormMaxFields()).undecodedLimit(configuration.getFormMaxBufferedBytes()).enableQuirks((DecoderQuirk[])configuration.getFormDecoderQuirks().stream().map(name -> (DecoderQuirk)ConversionService.SHARED.convertRequired(name, DecoderQuirk.class)).toArray(DecoderQuirk[]::new));
                if (HttpPostRequestDecoder.isMultipart((HttpRequest)request)) {
                    return builder.buildMultipart(request);
                }
                return builder.buildStandard(request);
            }
            catch (LinkageError e) {
                if (!configuration.getFormDecoderQuirks().isEmpty()) {
                    throw new ConfigurationException("Configuration contained form-decoder-quirks, but failed to load new decoder implementation", (Throwable)e);
                }
                contribCodecMissing = true;
            }
        }
        if (HttpPostRequestDecoder.isMultipart((HttpRequest)request)) {
            return new HttpPostMultipartRequestDecoder(factory, request, charset, configuration.getFormMaxFields(), configuration.getFormMaxBufferedBytes());
        }
        return new HttpPostStandardRequestDecoder(factory, request, charset, configuration.getFormMaxFields(), configuration.getFormMaxBufferedBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onData(ByteBufHolder message, Collection<? super InterfaceHttpData> out) {
        block22: {
            boolean skip;
            FormDataHttpContentProcessor formDataHttpContentProcessor = this;
            synchronized (formDataHttpContentProcessor) {
                if (this.destroyed) {
                    skip = true;
                } else {
                    skip = false;
                    this.inFlight = true;
                }
            }
            if (skip) {
                message.release();
                return;
            }
            try {
                if (message instanceof HttpContent) {
                    HttpContent httpContent = (HttpContent)message;
                    try {
                        InterfaceHttpPostRequestDecoder postRequestDecoder = this.decoder;
                        postRequestDecoder.offer(httpContent);
                        block15: while (postRequestDecoder.hasNext()) {
                            InterfaceHttpData data = postRequestDecoder.next();
                            data.touch();
                            switch (data.getHttpDataType()) {
                                case Attribute: {
                                    Attribute attribute = (Attribute)data;
                                    out.add((InterfaceHttpData)attribute.retain());
                                    postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)attribute);
                                    break;
                                }
                                case FileUpload: {
                                    FileUpload fileUpload = (FileUpload)data;
                                    if (!fileUpload.isCompleted()) continue block15;
                                    out.add((InterfaceHttpData)fileUpload.retain());
                                    postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)fileUpload);
                                    break;
                                }
                            }
                        }
                        InterfaceHttpData currentPartialHttpData = postRequestDecoder.currentPartialHttpData();
                        if (currentPartialHttpData != null) {
                            out.add((InterfaceHttpData)currentPartialHttpData);
                            postRequestDecoder.removeHttpDataFromClean(currentPartialHttpData);
                        }
                        break block22;
                    }
                    catch (RuntimeException e) {
                        RuntimeException mapped = this.mapFormException(e);
                        if (mapped != null) {
                            throw mapped;
                        }
                        break block22;
                    }
                    finally {
                        httpContent.release();
                    }
                }
                message.release();
            }
            finally {
                this.inFlight = false;
                this.destroyIfRequested();
            }
        }
    }

    private RuntimeException mapFormException(RuntimeException original) {
        if (original instanceof HttpPostRequestDecoder.EndOfDataDecoderException || FormDataHttpContentProcessor.instanceOfSafe(original, () -> HttpPostRequestDecoder.EndOfDataDecoderException.class)) {
            return null;
        }
        if (original instanceof HttpPostRequestDecoder.ErrorDataDecoderException || FormDataHttpContentProcessor.instanceOfSafe(original, () -> HttpPostRequestDecoder.ErrorDataDecoderException.class)) {
            Throwable cause = original.getCause();
            if (cause instanceof IOException && cause.getMessage().equals("Size exceed allowed maximum capacity")) {
                String partName = this.decoder.currentPartialHttpData().getName();
                return new ContentLengthExceededException("The part named [" + partName + "] exceeds the maximum allowed content length [" + this.partMaxSize + "]");
            }
            return original;
        }
        if (original instanceof HttpPostRequestDecoder.TooManyFormFieldsException || FormDataHttpContentProcessor.instanceOfSafe(original, () -> TooManyFormFieldsException.class)) {
            return new ContentLengthExceededException("Number of form fields exceeds configured limit of [" + this.configuration.getFormMaxFields() + "]");
        }
        if (original instanceof HttpPostRequestDecoder.TooLongFormFieldException || FormDataHttpContentProcessor.instanceOfSafe(original, () -> FormDecoderException.class) && original.getMessage().equals("Undecoded data limit exceeded")) {
            return new ContentLengthExceededException("Length of buffered form field exceeds configured limit of [" + this.configuration.getFormMaxBufferedBytes() + "]");
        }
        return original;
    }

    private static <B> boolean instanceOfSafe(B object, Supplier<Class<? extends B>> type) {
        Class<B> cl;
        try {
            cl = type.get();
        }
        catch (LinkageError e) {
            return false;
        }
        return cl.isInstance(object);
    }

    public void add(ByteBufHolder message, Collection<? super InterfaceHttpData> out) throws Throwable {
        try {
            this.receivedLast |= message instanceof LastHttpContent;
            long receivedLength1 = this.receivedLength.addAndGet(message.content().readableBytes());
            ReferenceCountUtil.touch((Object)message);
            if (this.advertisedLength > this.requestMaxSize) {
                this.fireExceedsLength(this.advertisedLength, this.requestMaxSize, message);
            } else if (receivedLength1 > this.requestMaxSize) {
                this.fireExceedsLength(receivedLength1, this.requestMaxSize, message);
            } else {
                this.onData(message, out);
            }
        }
        catch (Throwable e) {
            this.cancel();
            throw e;
        }
    }

    public void complete(Collection<? super InterfaceHttpData> out) throws Throwable {
        if (!this.receivedLast) {
            this.add((ByteBufHolder)LastHttpContent.EMPTY_LAST_CONTENT, out);
        }
        this.cancel();
    }

    public void cancel() {
        this.pleaseDestroy = true;
        this.destroyIfRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfRequested() {
        boolean destroy;
        FormDataHttpContentProcessor formDataHttpContentProcessor = this;
        synchronized (formDataHttpContentProcessor) {
            if (this.pleaseDestroy && !this.destroyed && !this.inFlight) {
                destroy = true;
                this.destroyed = true;
            } else {
                destroy = false;
            }
        }
        if (destroy) {
            this.decoder.destroy();
        }
    }

    protected void fireExceedsLength(long receivedLength, long expected, ByteBufHolder message) {
        message.release();
        throw new ContentLengthExceededException(expected, receivedLength);
    }
}

