/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import java.util.ArrayList;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public final class HttpContentProcessorAsReactiveProcessor {
    private HttpContentProcessorAsReactiveProcessor() {
    }

    @NonNull
    public static <T> Flux<T> asPublisher(HttpContentProcessor processor, Publisher<HttpContent> streamed) {
        return Flux.concat((Publisher[])new Publisher[]{Flux.from(streamed).doOnError(e -> {
            try {
                processor.cancel();
            }
            catch (Throwable ex) {
                e.addSuppressed(ex);
            }
        }).concatMap(c -> {
            try {
                ArrayList<Object> out = new ArrayList<Object>(1);
                processor.add((ByteBufHolder)c, out);
                return Flux.fromIterable(out);
            }
            catch (Throwable e) {
                c.touch();
                return Flux.error((Throwable)e);
            }
        }), Flux.defer(() -> {
            try {
                ArrayList<Object> out = new ArrayList<Object>(1);
                processor.complete(out);
                return Flux.fromIterable(out);
            }
            catch (Throwable ex) {
                return Flux.error((Throwable)ex);
            }
        })});
    }
}

