/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.PipeliningServerHandler;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.http.uri.UriBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;

@Internal
record HttpToHttpsRedirectHandler(ConversionService conversionService, NettyHttpServerConfiguration serverConfiguration, ServerSslConfiguration sslConfiguration, HttpHostResolver hostResolver) implements RequestHandler
{
    @Override
    public void accept(ChannelHandlerContext ctx, HttpRequest request, PipeliningServerHandler.OutboundAccess outboundAccess) {
        NettyHttpRequest<?> strippedRequest = NettyHttpRequest.createSafe(request, ctx, this.conversionService, this.serverConfiguration);
        UriBuilder uriBuilder = UriBuilder.of((CharSequence)this.hostResolver.resolve(strippedRequest));
        strippedRequest.release();
        uriBuilder.scheme("https");
        int port = this.sslConfiguration.getPort();
        if (port == 443) {
            uriBuilder.port(-1);
        } else {
            uriBuilder.port(port);
        }
        uriBuilder.path(strippedRequest.getPath());
        MutableHttpResponse response = HttpResponse.permanentRedirect((URI)uriBuilder.build()).header((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE);
        io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse((HttpResponse)response);
        outboundAccess.closeAfterWrite();
        outboundAccess.writeFull((FullHttpResponse)nettyResponse);
    }

    @Override
    public void handleUnboundError(Throwable cause) {
    }
}

