/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupRegistry;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ServerSocketChannel;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

@Internal
public interface NettyEmbeddedServices {
    public MessageBodyHandlerRegistry getMessageBodyHandlerRegistry();

    @NonNull
    public List<ChannelOutboundHandler> getOutboundHandlers();

    @NonNull
    public ApplicationContext getApplicationContext();

    @NonNull
    default public RequestArgumentSatisfier getRequestArgumentSatisfier() {
        return this.getRouteExecutor().getRequestArgumentSatisfier();
    }

    @NonNull
    public RouteExecutor getRouteExecutor();

    @NonNull
    public MediaTypeCodecRegistry getMediaTypeCodecRegistry();

    @NonNull
    public StaticResourceResolver getStaticResourceResolver();

    @NonNull
    default public ExecutorSelector getExecutorSelector() {
        return this.getRouteExecutor().getExecutorSelector();
    }

    @Nullable
    public ServerSslBuilder getServerSslBuilder();

    @NonNull
    public ChannelOptionFactory getChannelOptionFactory();

    @NonNull
    public HttpCompressionStrategy getHttpCompressionStrategy();

    public Optional<NettyServerWebSocketUpgradeHandler> getWebSocketUpgradeHandler(NettyEmbeddedServer var1);

    @NonNull
    public EventLoopGroupRegistry getEventLoopGroupRegistry();

    @NonNull
    default public Router getRouter() {
        return this.getRouteExecutor().getRouter();
    }

    @NonNull
    public EventLoopGroup createEventLoopGroup(@NonNull EventLoopGroupConfiguration var1);

    @NonNull
    public EventLoopGroup createEventLoopGroup(int var1, @NonNull ExecutorService var2, @Nullable Integer var3);

    @NonNull
    public ServerSocketChannel getServerSocketChannelInstance(@NonNull EventLoopGroupConfiguration var1);

    @NonNull
    default public ServerChannel getDomainServerChannelInstance(@NonNull EventLoopGroupConfiguration workerConfig) {
        throw new UnsupportedOperationException("Domain sockets not supported");
    }

    @NonNull
    default public Channel getChannelInstance(NettyChannelType type, @NonNull EventLoopGroupConfiguration workerConfig) {
        return switch (type) {
            case NettyChannelType.SERVER_SOCKET -> this.getServerSocketChannelInstance(workerConfig);
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> this.getDomainServerChannelInstance(workerConfig);
            default -> throw new UnsupportedOperationException("Unsupported netty channel type");
        };
    }

    @NonNull
    default public Channel getChannelInstance(NettyChannelType type, @NonNull EventLoopGroupConfiguration workerConfig, int fd) {
        throw new UnsupportedOperationException("File descriptor channels not supported");
    }

    @NonNull
    public <E> ApplicationEventPublisher<E> getEventPublisher(@NonNull Class<E> var1);
}

