/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.handler.accesslog.Http2AccessLogManager;
import io.micronaut.http.server.netty.handler.accesslog.element.AccessLog;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameListenerDecorator;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;

@Internal
public final class Http2AccessLogFrameListener
extends Http2FrameListenerDecorator {
    private final Http2AccessLogManager manager;

    public Http2AccessLogFrameListener(Http2FrameListener listener, Http2AccessLogManager manager) {
        super(listener);
        this.manager = manager;
    }

    private void logHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers) throws Http2Exception {
        AccessLog accessLog;
        if (!this.manager.logger.isInfoEnabled()) {
            return;
        }
        HttpRequest request = HttpConversionUtil.toHttpRequest((int)streamId, (Http2Headers)headers, (boolean)false);
        if (this.manager.uriInclusion != null && !this.manager.uriInclusion.test(request.uri())) {
            return;
        }
        if (this.manager.logForReuse != null) {
            accessLog = this.manager.logForReuse;
            this.manager.logForReuse = null;
        } else {
            accessLog = this.manager.formatParser.newAccessLogger();
        }
        this.manager.connection.stream(streamId).setProperty(this.manager.accessLogKey, (Object)accessLog);
        accessLog.onRequestHeaders((SocketChannel)ctx.channel(), request.method().name(), request.headers(), request.uri(), "HTTP/2.0");
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
        this.logHeaders(ctx, streamId, headers);
        super.onHeadersRead(ctx, streamId, headers, padding, endStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        this.logHeaders(ctx, streamId, headers);
        super.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
    }
}

