/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.netty.reactive.HotObservable;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.body.HttpBody;
import io.micronaut.http.server.netty.body.ImmediateByteBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.micronaut.http.server.netty.body.StreamingByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import org.reactivestreams.Publisher;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public interface ByteBody
extends HttpBody {
    public MultiObjectBody processMulti(FormDataHttpContentProcessor var1) throws Throwable;

    public MultiObjectBody rawContent(HttpServerConfiguration var1) throws ContentLengthExceededException;

    public ExecutionFlow<ImmediateByteBody> buffer(ByteBufAllocator var1);

    public HttpRequest claimForReuse(HttpRequest var1);

    public static ByteBody of(ByteBuf content) {
        return new ImmediateByteBody(content);
    }

    public static ByteBody of(HotObservable<HttpContent> content, long contentLength) {
        return new StreamingByteBody((Publisher<HttpContent>)content, contentLength);
    }

    public static ByteBody empty() {
        return ByteBody.of(Unpooled.EMPTY_BUFFER);
    }
}

