/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.DelayedSubscriber;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.DynamicMessageBodyWriter;
import io.micronaut.http.body.MediaTypeProvider;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyRequestLifecycle;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Internal
@ChannelHandler.Sharable
public final class RoutingInBoundHandler
implements RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    final StaticResourceResolver staticResourceResolver;
    final NettyHttpServerConfiguration serverConfiguration;
    final HttpContentProcessorResolver httpContentProcessorResolver;
    final RequestArgumentSatisfier requestArgumentSatisfier;
    final Supplier<ExecutorService> ioExecutorSupplier;
    final boolean multipartEnabled;
    final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    ExecutorService ioExecutor;
    final ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher;
    final RouteExecutor routeExecutor;
    final ConversionService conversionService;
    boolean supportLoggingHandler = false;

    RoutingInBoundHandler(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices embeddedServerContext, Supplier<ExecutorService> ioExecutor, HttpContentProcessorResolver httpContentProcessorResolver, ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher, ConversionService conversionService) {
        this.staticResourceResolver = embeddedServerContext.getStaticResourceResolver();
        this.messageBodyHandlerRegistry = embeddedServerContext.getMessageBodyHandlerRegistry();
        this.ioExecutorSupplier = ioExecutor;
        this.requestArgumentSatisfier = embeddedServerContext.getRequestArgumentSatisfier();
        this.serverConfiguration = serverConfiguration;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.terminateEventPublisher = terminateEventPublisher;
        Optional isMultiPartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || (Boolean)isMultiPartEnabled.get() != false;
        this.routeExecutor = embeddedServerContext.getRouteExecutor();
        this.conversionService = conversionService;
    }

    private void cleanupRequest(NettyHttpRequest<?> request) {
        try {
            request.release();
        }
        finally {
            block9: {
                if (!this.terminateEventPublisher.isEmpty()) {
                    try {
                        this.terminateEventPublisher.publishEvent((Object)new HttpRequestTerminatedEvent(request));
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error("Error publishing request terminated event: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
    }

    @Override
    public void responseWritten(Object attachment) {
        if (attachment != null) {
            this.cleanupRequest((NettyHttpRequest)((Object)attachment));
        }
    }

    @Override
    public void handleUnboundError(Throwable cause) {
        if (this.isIgnorable(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: {}", (Object)cause.getMessage(), (Object)cause);
            }
            return;
        }
        if (cause instanceof SSLException || cause.getCause() instanceof SSLException || cause instanceof DecompressionException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Micronaut Server Error - No request state present. Cause: {}", (Object)cause.getMessage(), (Object)cause);
            }
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Micronaut Server Error - No request state present. Cause: {}", (Object)cause.getMessage(), (Object)cause);
        }
    }

    @Override
    public void accept(ChannelHandlerContext ctx, io.netty.handler.codec.http.HttpRequest request, ByteBody body, OutboundAccess outboundAccess) {
        NettyHttpRequest mnRequest = new NettyHttpRequest(request, body, ctx, this.conversionService, this.serverConfiguration);
        if (this.serverConfiguration.isValidateUrl()) {
            try {
                mnRequest.getUri();
            }
            catch (IllegalArgumentException e) {
                body.release();
                NettyHttpRequest errorRequest = new NettyHttpRequest((io.netty.handler.codec.http.HttpRequest)new DefaultHttpRequest(request.protocolVersion(), request.method(), "/"), ByteBody.empty(), ctx, this.conversionService, this.serverConfiguration);
                outboundAccess.attachment((Object)errorRequest);
                try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(errorRequest)).propagate();){
                    new NettyRequestLifecycle(this, outboundAccess).handleException(errorRequest, e.getCause() == null ? e : e.getCause());
                }
                return;
            }
        }
        if (this.supportLoggingHandler && ctx.pipeline().get("http-access-logger") != null) {
            AttributeKey key = AttributeKey.valueOf((String)NettyHttpRequest.class.getSimpleName());
            ctx.channel().attr(key).set(mnRequest);
        }
        outboundAccess.attachment((Object)mnRequest);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(mnRequest)).propagate();){
            new NettyRequestLifecycle(this, outboundAccess).handleNormal(mnRequest);
        }
    }

    public void writeResponse(OutboundAccess outboundAccess, NettyHttpRequest<?> nettyHttpRequest, HttpResponse<?> response, Throwable throwable) {
        if (throwable != null) {
            response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, throwable);
        }
        if (response != null) {
            try {
                this.encodeHttpResponse(outboundAccess, nettyHttpRequest, (HttpResponse<?>)response, response.body());
            }
            catch (Throwable e) {
                try {
                    response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, e);
                    this.encodeHttpResponse(outboundAccess, nettyHttpRequest, (HttpResponse<?>)response, response.body());
                }
                catch (Throwable f) {
                    f.addSuppressed(e);
                    outboundAccess.closeAfterWrite();
                    try {
                        outboundAccess.writeFull((FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER));
                    }
                    catch (Throwable g) {
                        f.addSuppressed(g);
                    }
                    LOG.warn("Failed to encode error response", f);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private void encodeHttpResponse(OutboundAccess outboundAccess, NettyHttpRequest<?> nettyRequest, HttpResponse<?> httpResponse, Object body) {
        MutableHttpResponse response = httpResponse.toMutableResponse();
        if (nettyRequest.getMethod() != HttpMethod.HEAD && body != null) {
            Argument actualResponseType;
            RouteInfo routeInfo = response.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
            if (Publishers.isConvertibleToPublisher((Object)body)) {
                response.body(null);
                DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse(this.toNettyResponse((HttpResponse<?>)response), (Publisher<HttpContent>)this.mapToHttpContent(nettyRequest, response, body, (RouteInfo<Object>)routeInfo, nettyRequest.getChannelHandlerContext()));
                this.writeStreamedWithErrorHandling(nettyRequest, outboundAccess, streamedResponse);
                return;
            }
            MessageBodyWriter messageBodyWriter = response.getBodyWriter().orElse(null);
            MediaType responseMediaType = response.getContentType().orElse(null);
            Argument responseBodyType = routeInfo != null ? routeInfo.getResponseBodyType() : Argument.of(body.getClass());
            if (responseMediaType == null) {
                if (body instanceof MediaTypeProvider) {
                    MediaTypeProvider mediaTypeProvider = (MediaTypeProvider)body;
                    responseMediaType = mediaTypeProvider.getMediaType();
                } else {
                    responseMediaType = routeInfo != null ? this.routeExecutor.resolveDefaultResponseContentType(nettyRequest, routeInfo) : MediaType.APPLICATION_JSON_TYPE;
                }
            }
            if (messageBodyWriter == null) {
                messageBodyWriter = this.messageBodyHandlerRegistry.findWriter(responseBodyType, Collections.singletonList(responseMediaType)).orElse(null);
            }
            if (messageBodyWriter == null || !responseBodyType.isInstance(body) || !messageBodyWriter.isWriteable(responseBodyType, responseMediaType)) {
                messageBodyWriter = new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, List.of(responseMediaType));
                actualResponseType = Argument.of(body.getClass());
            } else {
                actualResponseType = responseBodyType;
            }
            NettyBodyWriter<Object> closure = this.specialize(this.wrap(messageBodyWriter), actualResponseType, responseMediaType, body);
            this.closeConnectionIfError(response, nettyRequest, outboundAccess);
            if (closure.isBlocking()) {
                MediaType finalResponseMediaType = responseMediaType;
                this.getIoExecutor().execute(() -> this.writeNettyMessageBody(nettyRequest, (MutableHttpResponse<Object>)response, (Argument<Object>)actualResponseType, finalResponseMediaType, body, closure, outboundAccess, true));
            } else {
                this.writeNettyMessageBody(nettyRequest, (MutableHttpResponse<Object>)response, (Argument<Object>)actualResponseType, responseMediaType, body, closure, outboundAccess, false);
            }
        } else {
            response.body(null);
            this.writeFinalNettyResponse(response, nettyRequest, outboundAccess);
        }
    }

    private void writeNettyMessageBody(NettyHttpRequest<?> nettyRequest, MutableHttpResponse<Object> response, Argument<Object> responseBodyType, MediaType mediaType, Object body, NettyBodyWriter<Object> nettyMessageBodyWriter, OutboundAccess outboundAccess, boolean onIoExecutor) {
        try {
            nettyMessageBodyWriter.writeTo(nettyRequest, response, responseBodyType, mediaType, body, (NettyWriteContext)outboundAccess);
        }
        catch (CodecException e) {
            MutableHttpResponse errorResponse = this.routeExecutor.createDefaultErrorResponse(nettyRequest, (Throwable)e);
            MediaType t = errorResponse.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            NettyBodyWriter dyn = this.wrap(new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, List.of(t)).find(Argument.OBJECT_ARGUMENT, t, errorResponse.body()));
            if (onIoExecutor || !dyn.isBlocking()) {
                dyn.writeTo(nettyRequest, errorResponse, Argument.OBJECT_ARGUMENT, t, errorResponse.body(), (NettyWriteContext)outboundAccess);
            }
            this.ioExecutor.execute(() -> dyn.writeTo((HttpRequest)nettyRequest, errorResponse, Argument.OBJECT_ARGUMENT, t, errorResponse.body(), (NettyWriteContext)outboundAccess));
        }
    }

    private Flux<HttpContent> mapToHttpContent(NettyHttpRequest<?> request, MutableHttpResponse<?> response, Object body, RouteInfo<Object> routeInfo, ChannelHandlerContext context) {
        Flux httpContentPublisher;
        MediaType mediaType = response.getContentType().orElse(null);
        NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
        Flux bodyPublisher = Flux.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)body, Publisher.class)));
        boolean isJson = false;
        if (routeInfo != null) {
            if (mediaType == null) {
                mediaType = this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo);
            }
            isJson = mediaType != null && mediaType.getExtension().equals("json") && routeInfo.isResponseBodyJsonFormattable();
            MediaType finalMediaType = mediaType;
            Argument responseBodyType = routeInfo.getResponseBodyType();
            httpContentPublisher = bodyPublisher.concatMap(message -> {
                MessageBodyWriter messageBodyWriter = routeInfo.getMessageBodyWriter();
                if (messageBodyWriter == null || !responseBodyType.isInstance(message) || !messageBodyWriter.isWriteable(responseBodyType, finalMediaType)) {
                    messageBodyWriter = new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, List.of(finalMediaType));
                }
                return this.writeAsync((MessageBodyWriter)messageBodyWriter, (Argument)(responseBodyType.isInstance(message) ? responseBodyType : Argument.of(message.getClass())), finalMediaType, (Object)message, (MutableHeaders)response.getHeaders(), (ByteBufferFactory<?, ?>)byteBufferFactory);
            }).map(byteBuffer -> new DefaultHttpContent((ByteBuf)byteBuffer.asNativeBuffer()));
        } else {
            MediaType finalMediaType = mediaType;
            DynamicMessageBodyWriter dynamicWriter = new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, mediaType == null ? List.of() : List.of(mediaType));
            httpContentPublisher = bodyPublisher.concatMap(message -> this.writeAsync((MessageBodyWriter)dynamicWriter, (Argument)Argument.OBJECT_ARGUMENT, finalMediaType, (Object)message, (MutableHeaders)response.getHeaders(), (ByteBufferFactory<?, ?>)byteBufferFactory)).map(byteBuffer -> new DefaultHttpContent((ByteBuf)byteBuffer.asNativeBuffer()));
        }
        if (isJson) {
            httpContentPublisher = JsonSubscriber.lift((Publisher)httpContentPublisher);
        }
        httpContentPublisher = httpContentPublisher.contextWrite(reactorContext -> reactorContext.put((Object)"micronaut.http.server.request", (Object)request));
        return httpContentPublisher;
    }

    private <T> Publisher<ByteBuffer<?>> writeAsync(@NonNull MessageBodyWriter<T> messageBodyWriter, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull ByteBufferFactory<?, ?> bufferFactory) {
        if (messageBodyWriter instanceof DynamicMessageBodyWriter) {
            DynamicMessageBodyWriter dyn = (DynamicMessageBodyWriter)messageBodyWriter;
            messageBodyWriter = dyn.find(type, mediaType, object);
        }
        if (messageBodyWriter.isBlocking()) {
            MessageBodyWriter finalMessageBodyWriter = messageBodyWriter;
            return Mono.defer(() -> Mono.just((Object)finalMessageBodyWriter.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory))).subscribeOn(Schedulers.fromExecutor((Executor)this.ioExecutor));
        }
        return Mono.just((Object)messageBodyWriter.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory));
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, NettyHttpRequest<?> request, OutboundAccess outboundAccess) {
        this.closeConnectionIfError(message, request, outboundAccess);
        io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
        if (nettyResponse instanceof StreamedHttpResponse) {
            StreamedHttpResponse streamed = (StreamedHttpResponse)nettyResponse;
            this.writeStreamedWithErrorHandling(request, outboundAccess, streamed);
        } else {
            FullHttpResponse fullResponse = (FullHttpResponse)nettyResponse;
            outboundAccess.writeFull(fullResponse, request.getMethod() == HttpMethod.HEAD);
        }
        this.log(request, nettyResponse);
    }

    private void writeFinalFullNettyResponse(MutableHttpResponse<?> message, NettyHttpRequest<?> request, OutboundAccess outboundAccess, ByteBuf byteBuf) {
        this.closeConnectionIfError(message, request, outboundAccess);
        FullHttpResponse fullResponse = NettyHttpResponseBuilder.toFullHttpResponse(message, (ByteBuf)byteBuf);
        outboundAccess.writeFull(fullResponse, request.getMethod() == HttpMethod.HEAD);
        this.log(request, (io.netty.handler.codec.http.HttpResponse)fullResponse);
    }

    private void log(HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} - {} {}", new Object[]{nettyResponse.status().code(), request.getMethodName(), request.getUri()});
        }
    }

    private void writeStreamedWithErrorHandling(NettyHttpRequest<?> request, OutboundAccess outboundAccess, StreamedHttpResponse streamed) {
        LazySendingSubscriber sub = new LazySendingSubscriber(request, (io.netty.handler.codec.http.HttpResponse)streamed, outboundAccess);
        streamed.subscribe((Subscriber)sub);
    }

    private void closeConnectionIfError(MutableHttpResponse<?> message, HttpRequest<?> request, OutboundAccess outboundAccess) {
        NettyHttpRequest nettyRequest;
        boolean decodeError;
        boolean bl = decodeError = request instanceof NettyHttpRequest && (nettyRequest = (NettyHttpRequest)request).getNativeRequest().decoderResult().isFailure();
        if (decodeError || message.code() >= 500 && !this.serverConfiguration.isKeepAliveOnServerError()) {
            outboundAccess.closeAfterWrite();
        }
    }

    @NonNull
    private io.netty.handler.codec.http.HttpResponse toNettyResponse(HttpResponse<?> message) {
        if (message instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)message;
            return builder.toHttpResponse();
        }
        return this.createNettyResponse(message).toHttpResponse();
    }

    @NonNull
    private NettyMutableHttpResponse<?> createNettyResponse(HttpResponse<?> message) {
        Object body = message.body();
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(this.serverConfiguration.isValidateHeaders());
        message.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)nettyHeaders).set(arg_0, arg_1));
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)message.code(), (String)message.reason()), body instanceof ByteBuf ? body : null, this.conversionService);
    }

    boolean isIgnorable(Throwable cause) {
        if (cause instanceof ClosedChannelException || cause.getCause() instanceof ClosedChannelException) {
            return true;
        }
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    <T> NettyBodyWriter<T> wrap(MessageBodyWriter<T> closure) {
        if (closure instanceof NettyBodyWriter) {
            NettyBodyWriter nettyClosure = (NettyBodyWriter)closure;
            return nettyClosure;
        }
        return new CompatNettyWriteClosure<T>(closure);
    }

    <T> NettyBodyWriter<T> specialize(NettyBodyWriter<T> original, Argument<T> bodyType, MediaType mediaType, T body) {
        if (original instanceof CompatNettyWriteClosure) {
            CompatNettyWriteClosure cnwc = (CompatNettyWriteClosure)original;
            MessageBodyWriter messageBodyWriter = cnwc.delegate;
            if (messageBodyWriter instanceof DynamicMessageBodyWriter) {
                DynamicMessageBodyWriter dyn = (DynamicMessageBodyWriter)messageBodyWriter;
                return this.wrap(dyn.find(bodyType, mediaType, body));
            }
        }
        return original;
    }

    private final class LazySendingSubscriber
    implements Processor<HttpContent, HttpContent> {
        private static final Object COMPLETE = new Object();
        boolean headersSent = false;
        Subscription upstream;
        final DelayedSubscriber<HttpContent> downstream = new DelayedSubscriber();
        @Nullable
        HttpContent first;
        Object completion = null;
        private final EventLoopFlow flow;
        private final NettyHttpRequest<?> request;
        private final io.netty.handler.codec.http.HttpResponse headers;
        private final OutboundAccess outboundAccess;

        private LazySendingSubscriber(NettyHttpRequest<?> request, io.netty.handler.codec.http.HttpResponse headers, OutboundAccess outboundAccess) {
            this.request = request;
            this.headers = headers;
            this.outboundAccess = outboundAccess;
            this.flow = new EventLoopFlow((OrderedEventExecutor)request.getChannelHandlerContext().channel().eventLoop());
        }

        public void subscribe(final Subscriber<? super HttpContent> s) {
            this.downstream.onSubscribe(new Subscription(){

                public void request(long n) {
                    HttpContent first = LazySendingSubscriber.this.first;
                    if (first != null) {
                        LazySendingSubscriber.this.first = null;
                        s.onNext((Object)first);
                        if (LazySendingSubscriber.this.completion != null) {
                            if (LazySendingSubscriber.this.completion == COMPLETE) {
                                s.onComplete();
                            } else {
                                s.onError((Throwable)LazySendingSubscriber.this.completion);
                            }
                            return;
                        }
                        if (n != Long.MAX_VALUE && --n == 0L) {
                            return;
                        }
                    }
                    LazySendingSubscriber.this.upstream.request(n);
                }

                public void cancel() {
                    if (LazySendingSubscriber.this.first != null) {
                        LazySendingSubscriber.this.first.release();
                        LazySendingSubscriber.this.first = null;
                    }
                    LazySendingSubscriber.this.upstream.cancel();
                }
            });
            this.downstream.subscribe(s);
        }

        public void onSubscribe(Subscription s) {
            this.upstream = s;
            s.request(1L);
        }

        public void onNext(HttpContent httpContent) {
            if (this.flow.executeNow(() -> this.onNext0(httpContent))) {
                this.onNext0(httpContent);
            }
        }

        private void onNext0(HttpContent httpContent) {
            if (this.headersSent) {
                this.downstream.onNext((Object)httpContent);
            } else {
                this.first = httpContent;
                this.headersSent = true;
                this.outboundAccess.writeStreamed(this.headers, (Publisher)this);
            }
        }

        public void onError(Throwable t) {
            if (this.flow.executeNow(() -> this.onError0(t))) {
                this.onError0(t);
            }
        }

        private void onError0(Throwable t) {
            if (this.headersSent) {
                if (this.first != null) {
                    this.completion = t;
                } else {
                    this.downstream.onError(t);
                }
            } else {
                MutableHttpResponse response;
                if (t instanceof HttpStatusException) {
                    HttpStatusException hse = (HttpStatusException)t;
                    response = HttpResponse.status((HttpStatus)hse.getStatus());
                    if (hse.getBody().isPresent()) {
                        response.body(hse.getBody().get());
                    } else if (hse.getMessage() != null) {
                        response.body((Object)hse.getMessage());
                    }
                } else {
                    response = RoutingInBoundHandler.this.routeExecutor.createDefaultErrorResponse(this.request, t);
                }
                RoutingInBoundHandler.this.encodeHttpResponse(this.outboundAccess, this.request, (HttpResponse<?>)response, response.body());
            }
        }

        public void onComplete() {
            if (this.flow.executeNow(this::onComplete0)) {
                this.onComplete0();
            }
        }

        private void onComplete0() {
            if (this.headersSent) {
                if (this.first != null) {
                    this.completion = COMPLETE;
                } else {
                    this.downstream.onComplete();
                }
            } else {
                this.headersSent = true;
                this.outboundAccess.writeStreamed(this.headers, (Publisher)Flux.empty());
            }
        }
    }

    private final class CompatNettyWriteClosure<T>
    implements NettyBodyWriter<T> {
        private final MessageBodyWriter<T> delegate;

        CompatNettyWriteClosure(MessageBodyWriter<T> delegate) {
            assert (!(delegate instanceof NettyBodyWriter)) : "please create using wrap()";
            this.delegate = delegate;
        }

        public boolean isBlocking() {
            return this.delegate.isBlocking();
        }

        public void writeTo(HttpRequest<?> request, MutableHttpResponse<T> outgoingResponse, Argument<T> type, MediaType mediaType, T object, NettyWriteContext nettyContext) throws CodecException {
            DynamicMessageBodyWriter dyn;
            MessageBodyWriter actual = this.delegate;
            MessageBodyWriter<T> messageBodyWriter = this.delegate;
            if (messageBodyWriter instanceof DynamicMessageBodyWriter && (actual = (dyn = (DynamicMessageBodyWriter)messageBodyWriter).find(type, mediaType, object)) instanceof NettyBodyWriter) {
                NettyBodyWriter nbw = (NettyBodyWriter)actual;
                nbw.writeTo(request, outgoingResponse, type, mediaType, object, nettyContext);
                return;
            }
            NettyByteBufferFactory bufferFactory = new NettyByteBufferFactory(nettyContext.alloc());
            ByteBuffer byteBuffer = actual.writeTo(type, mediaType, object, (MutableHeaders)outgoingResponse.getHeaders(), (ByteBufferFactory)bufferFactory);
            ByteBuf buffer = (ByteBuf)byteBuffer.asNativeBuffer();
            RoutingInBoundHandler.this.writeFinalFullNettyResponse(outgoingResponse, (NettyHttpRequest)request, (OutboundAccess)nettyContext, buffer);
        }

        public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            this.delegate.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
        }

        public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            return this.delegate.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
        }
    }
}

