/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.netty.PublisherAsBlocking;
import io.micronaut.http.netty.PublisherAsStream;
import io.micronaut.http.netty.reactive.HotObservable;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.body.ManagedBody;
import io.micronaut.http.server.netty.body.MultiObjectBody;
import io.netty.buffer.ByteBufAllocator;
import java.io.InputStream;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;

@Internal
public final class StreamingMultiObjectBody
extends ManagedBody<Publisher<?>>
implements MultiObjectBody {
    public StreamingMultiObjectBody(Publisher<?> publisher) {
        super(publisher);
    }

    @Override
    void release(Publisher<?> value) {
        if (value instanceof HotObservable) {
            HotObservable hot = (HotObservable)value;
            hot.closeIfNoSubscriber();
        }
    }

    @Override
    public InputStream coerceToInputStream(ByteBufAllocator alloc) {
        PublisherAsBlocking publisherAsBlocking = new PublisherAsBlocking();
        ((Publisher)this.claim()).subscribe((Subscriber)publisherAsBlocking);
        return new PublisherAsStream(publisherAsBlocking);
    }

    @Override
    public Publisher<?> asPublisher() {
        return (Publisher)this.claim();
    }

    @Override
    public MultiObjectBody mapNotNull(Function<Object, Object> transform) {
        return this.next(new StreamingMultiObjectBody((Publisher<?>)Flux.from((Publisher)((Publisher)this.prepareClaim())).mapNotNull(transform)));
    }

    @Override
    public void handleForm(FormRouteCompleter formRouteCompleter) {
        ((Publisher)this.prepareClaim()).subscribe((Subscriber)formRouteCompleter);
        this.next(formRouteCompleter);
    }
}

