/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.server.netty.HttpCompressionStrategy;
import io.micronaut.http.server.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.netty.body.BodySizeLimits;
import io.micronaut.http.server.netty.body.BufferConsumer;
import io.micronaut.http.server.netty.body.StreamingNettyByteBody;
import io.micronaut.http.server.netty.handler.BlockingWriter;
import io.micronaut.http.server.netty.handler.Compressor;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class PipeliningServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PipeliningServerHandler.class);
    private final RequestHandler requestHandler;
    private final DroppingInboundHandler droppingInboundHandler = new DroppingInboundHandler();
    private final InboundHandler baseInboundHandler = new MessageInboundHandler();
    private final OptimisticBufferingInboundHandler optimisticBufferingInboundHandler = new OptimisticBufferingInboundHandler();
    private Compressor compressor;
    private BodySizeLimits bodySizeLimits = BodySizeLimits.UNLIMITED;
    private InboundHandler inboundHandler = this.baseInboundHandler;
    private final Queue<OutboundAccessImpl> outboundQueue = new ArrayDeque<OutboundAccessImpl>(1);
    @Nullable
    private OutboundHandler outboundHandler = null;
    private ChannelHandlerContext ctx;
    private boolean reading = false;
    private boolean readCalled = false;
    private boolean removed = false;
    private boolean flushPending = false;
    private boolean writing = false;

    public PipeliningServerHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void setCompressionStrategy(HttpCompressionStrategy compressionStrategy) {
        this.compressor = compressionStrategy.isEnabled() ? new Compressor(compressionStrategy) : null;
    }

    public void setBodySizeLimits(BodySizeLimits bodySizeLimits) {
        this.bodySizeLimits = bodySizeLimits;
    }

    public static boolean canHaveBody(HttpResponseStatus status) {
        return status != HttpResponseStatus.CONTINUE && status != HttpResponseStatus.SWITCHING_PROTOCOLS && status != HttpResponseStatus.PROCESSING && status != HttpResponseStatus.NO_CONTENT && status != HttpResponseStatus.NOT_MODIFIED;
    }

    private static boolean hasBody(HttpRequest request) {
        int contentLength;
        if (request.decoderResult().isFailure()) {
            return false;
        }
        try {
            contentLength = HttpUtil.getContentLength((HttpMessage)request, (int)0);
        }
        catch (NumberFormatException e) {
            contentLength = 0;
        }
        return contentLength != 0 || HttpUtil.isTransferEncodingChunked((HttpMessage)request);
    }

    private void refreshNeedMore() {
        if (!this.readCalled && this.outboundQueue.size() <= 1 && this.inboundHandler.needMore()) {
            this.readCalled = true;
            this.ctx.read();
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        ctx.channel().config().setAutoRead(false);
        this.refreshNeedMore();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.removed = true;
        if (this.outboundHandler != null) {
            this.outboundHandler.discard();
        }
        for (OutboundAccessImpl queued : this.outboundQueue) {
            if (queued.handler == null) continue;
            queued.handler.discard();
        }
        this.outboundQueue.clear();
        this.requestHandler.removed();
    }

    public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
        this.reading = true;
        this.inboundHandler.read(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.inboundHandler.readComplete();
        this.reading = false;
        this.readCalled = false;
        if (this.flushPending) {
            ctx.flush();
            this.flushPending = false;
        }
        this.refreshNeedMore();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.inboundHandler.handleUpstreamError(cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.writeSome();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        IdleState state;
        if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
            ctx.close();
        }
        super.userEventTriggered(ctx, evt);
    }

    private void write(Object message, boolean flush, boolean close) {
        if (close) {
            this.ctx.writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (flush) {
            if (this.reading) {
                this.ctx.write(message, this.ctx.voidPromise());
                this.flushPending = true;
            } else {
                this.ctx.writeAndFlush(message, this.ctx.voidPromise());
            }
        } else {
            this.ctx.write(message, this.ctx.voidPromise());
        }
    }

    private void writeSome() {
        if (this.writing) {
            return;
        }
        this.writing = true;
        try {
            while (this.ctx.channel().isWritable()) {
                if (this.outboundHandler == null) {
                    OutboundAccessImpl next = this.outboundQueue.peek();
                    if (next != null && next.handler != null) {
                        this.outboundQueue.poll();
                        this.outboundHandler = next.handler;
                        this.refreshNeedMore();
                    } else {
                        return;
                    }
                }
                OutboundHandler oldHandler = this.outboundHandler;
                oldHandler.writeSome();
                if (this.outboundHandler != oldHandler) continue;
                break;
            }
        }
        finally {
            this.writing = false;
        }
    }

    static CloseableByteBody createImmediateByteBody(EventLoop loop, BodySizeLimits bodySizeLimits, ByteBuf buf) {
        if ((long)buf.readableBytes() > bodySizeLimits.maxBodySize() || (long)buf.readableBytes() > bodySizeLimits.maxBufferSize()) {
            BufferConsumer.Upstream upstream = bytesConsumed -> {};
            StreamingNettyByteBody.SharedBuffer mockBuffer = new StreamingNettyByteBody.SharedBuffer(loop, bodySizeLimits, upstream);
            mockBuffer.add(buf);
            return new StreamingNettyByteBody(mockBuffer);
        }
        return new AvailableNettyByteBody(buf);
    }

    private final class DroppingInboundHandler
    extends InboundHandler {
        private DroppingInboundHandler() {
        }

        @Override
        void read(Object message) {
            if (message instanceof LastHttpContent) {
                LastHttpContent lhc = (LastHttpContent)message;
                lhc.release();
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.baseInboundHandler;
            } else {
                ((HttpContent)message).release();
            }
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            PipeliningServerHandler.this.requestHandler.handleUnboundError(cause);
        }
    }

    private final class MessageInboundHandler
    extends InboundHandler {
        private MessageInboundHandler() {
        }

        @Override
        void read(Object message) {
            boolean full;
            HttpRequest request = (HttpRequest)message;
            OutboundAccessImpl outboundAccess = new OutboundAccessImpl(request);
            PipeliningServerHandler.this.outboundQueue.add(outboundAccess);
            HttpHeaders headers = request.headers();
            String contentEncoding = MessageInboundHandler.getContentEncoding(headers);
            EmbeddedChannel decompressionChannel = contentEncoding == null ? null : (HttpHeaderValues.GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)}) : (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.ZLIB_OR_NONE)}) : (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase((CharSequence)contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), new ChannelHandler[]{new BrotliDecoder()}) : (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase((CharSequence)contentEncoding) ? new EmbeddedChannel(PipeliningServerHandler.this.ctx.channel().id(), PipeliningServerHandler.this.ctx.channel().metadata().hasDisconnect(), PipeliningServerHandler.this.ctx.channel().config(), new ChannelHandler[]{new SnappyFrameDecoder()}) : null))));
            if (decompressionChannel != null) {
                headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                headers.remove((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
                headers.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            boolean bl = full = request.getClass() != DefaultHttpRequest.class && request instanceof FullHttpRequest;
            if (full && decompressionChannel == null) {
                PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, PipeliningServerHandler.createImmediateByteBody(PipeliningServerHandler.this.ctx.channel().eventLoop(), PipeliningServerHandler.this.bodySizeLimits, ((FullHttpRequest)request).content()), outboundAccess);
            } else if (!PipeliningServerHandler.hasBody(request)) {
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.droppingInboundHandler;
                if (full) {
                    PipeliningServerHandler.this.inboundHandler.read(message);
                }
                if (decompressionChannel != null) {
                    decompressionChannel.finish();
                }
                PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, (CloseableByteBody)AvailableNettyByteBody.empty(), outboundAccess);
            } else {
                PipeliningServerHandler.this.optimisticBufferingInboundHandler.init(request, outboundAccess);
                PipeliningServerHandler.this.inboundHandler = decompressionChannel == null ? PipeliningServerHandler.this.optimisticBufferingInboundHandler : new DecompressingInboundHandler(decompressionChannel, PipeliningServerHandler.this.optimisticBufferingInboundHandler);
                if (full) {
                    PipeliningServerHandler.this.inboundHandler.read(new DefaultLastHttpContent(((FullHttpRequest)request).content()));
                }
            }
        }

        private static String getContentEncoding(HttpHeaders headers) {
            int idx;
            String transferEncoding;
            String contentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            contentEncoding = contentEncoding != null ? contentEncoding.trim() : ((transferEncoding = headers.get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) != null ? ((idx = transferEncoding.indexOf(",")) != -1 ? transferEncoding.substring(0, idx).trim() : transferEncoding.trim()) : null);
            return contentEncoding;
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            PipeliningServerHandler.this.requestHandler.handleUnboundError(cause);
        }
    }

    private abstract class InboundHandler {
        private InboundHandler() {
        }

        boolean needMore() {
            return true;
        }

        abstract void read(Object var1);

        abstract void handleUpstreamError(Throwable var1);

        void readComplete() {
        }
    }

    private final class OptimisticBufferingInboundHandler
    extends InboundHandler {
        private HttpRequest request;
        private OutboundAccessImpl outboundAccess;
        private final List<HttpContent> buffer = new ArrayList<HttpContent>();

        private OptimisticBufferingInboundHandler() {
        }

        void init(HttpRequest request, OutboundAccessImpl outboundAccess) {
            assert (this.buffer.isEmpty());
            this.request = request;
            this.outboundAccess = outboundAccess;
        }

        @Override
        void read(Object message) {
            HttpContent content = (HttpContent)message;
            if (content.content().isReadable()) {
                this.buffer.add(content);
            } else {
                content.release();
            }
            if (message instanceof LastHttpContent) {
                ByteBuf fullBody;
                LastHttpContent last = (LastHttpContent)message;
                if (this.buffer.size() == 0) {
                    fullBody = Unpooled.EMPTY_BUFFER;
                } else if (this.buffer.size() == 1) {
                    fullBody = this.buffer.get(0).content();
                } else {
                    CompositeByteBuf composite = PipeliningServerHandler.this.ctx.alloc().compositeBuffer();
                    for (HttpContent c : this.buffer) {
                        composite.addComponent(true, c.content());
                    }
                    fullBody = composite;
                }
                this.buffer.clear();
                HttpRequest request = this.request;
                this.request = null;
                OutboundAccessImpl outboundAccess = this.outboundAccess;
                this.outboundAccess = null;
                PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, PipeliningServerHandler.createImmediateByteBody(PipeliningServerHandler.this.ctx.channel().eventLoop(), PipeliningServerHandler.this.bodySizeLimits, fullBody), outboundAccess);
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.baseInboundHandler;
            }
        }

        @Override
        void readComplete() {
            this.devolveToStreaming();
            PipeliningServerHandler.this.inboundHandler.readComplete();
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            this.devolveToStreaming();
            PipeliningServerHandler.this.inboundHandler.handleUpstreamError(cause);
        }

        private void devolveToStreaming() {
            HttpRequest request = this.request;
            OutboundAccessImpl outboundAccess = this.outboundAccess;
            this.request = null;
            this.outboundAccess = null;
            StreamingInboundHandler streamingInboundHandler = new StreamingInboundHandler(outboundAccess, HttpUtil.is100ContinueExpected((HttpMessage)request));
            for (HttpContent content : this.buffer) {
                streamingInboundHandler.read(content);
            }
            this.buffer.clear();
            if (PipeliningServerHandler.this.inboundHandler == this) {
                PipeliningServerHandler.this.inboundHandler = streamingInboundHandler;
            } else {
                ((DecompressingInboundHandler)PipeliningServerHandler.this.inboundHandler).delegate = streamingInboundHandler;
            }
            streamingInboundHandler.dest.setExpectedLengthFrom(request.headers());
            PipeliningServerHandler.this.requestHandler.accept(PipeliningServerHandler.this.ctx, request, new StreamingNettyByteBody(streamingInboundHandler.dest), outboundAccess);
        }
    }

    private abstract class OutboundHandler {
        final OutboundAccessImpl outboundAccess;
        Compressor.Session compressionSession;

        private OutboundHandler(OutboundAccessImpl outboundAccess) {
            this.outboundAccess = outboundAccess;
        }

        protected final void writeCompressing(HttpContent content, boolean flush, boolean close) {
            if (this.compressionSession == null) {
                PipeliningServerHandler.this.write(content, flush, close);
            } else {
                this.writeCompressing0(content, flush, close);
            }
        }

        private void writeCompressing0(HttpContent content, boolean flush, boolean close) {
            ByteBuf toSend;
            Compressor.Session compressionSession = this.compressionSession;
            compressionSession.push(content.content());
            boolean last = content instanceof LastHttpContent;
            if (last) {
                compressionSession.finish();
            }
            if (content instanceof HttpResponse) {
                HttpResponse hr = (HttpResponse)content;
                assert (last);
                compressionSession.fixContentLength(hr);
                PipeliningServerHandler.this.write(new DefaultHttpResponse(hr.protocolVersion(), hr.status(), hr.headers()), false, false);
            }
            if ((toSend = compressionSession.poll()) == null) {
                if (last) {
                    HttpHeaders trailingHeaders = ((LastHttpContent)content).trailingHeaders();
                    PipeliningServerHandler.this.write(trailingHeaders.isEmpty() ? LastHttpContent.EMPTY_LAST_CONTENT : new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, trailingHeaders), flush, close);
                } else if (flush || close) {
                    PipeliningServerHandler.this.write(new DefaultHttpContent(Unpooled.EMPTY_BUFFER), flush, close);
                }
            } else if (last) {
                PipeliningServerHandler.this.write(new DefaultLastHttpContent(toSend, ((LastHttpContent)content).trailingHeaders()), flush, close);
            } else {
                PipeliningServerHandler.this.write(new DefaultHttpContent(toSend), flush, close);
            }
        }

        abstract void writeSome();

        void discard() {
            Compressor.Session compressionSession = this.compressionSession;
            if (compressionSession != null) {
                compressionSession.discard();
            }
        }
    }

    public final class OutboundAccessImpl
    implements OutboundAccess {
        private final HttpRequest request;
        private OutboundHandler handler;
        private Object attachment = null;
        private boolean closeAfterWrite = false;

        private OutboundAccessImpl(HttpRequest request) {
            this.request = request;
        }

        public ByteBufAllocator alloc() {
            return PipeliningServerHandler.this.ctx.alloc();
        }

        @Override
        public void attachment(Object attachment) {
            this.attachment = attachment;
        }

        @Override
        public void closeAfterWrite() {
            this.closeAfterWrite = true;
        }

        private void preprocess(HttpResponse message) {
            if (!message.protocolVersion().equals((Object)this.request.protocolVersion())) {
                message.setProtocolVersion(this.request.protocolVersion());
            }
            if (this.request.protocolVersion().isKeepAliveDefault()) {
                if (this.request.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true)) {
                    this.closeAfterWrite();
                }
            } else if (!this.request.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true)) {
                this.closeAfterWrite();
            }
            if (message.protocolVersion().isKeepAliveDefault()) {
                if (message.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true)) {
                    this.closeAfterWrite();
                } else if (this.closeAfterWrite) {
                    message.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                }
            } else if (!message.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true)) {
                this.closeAfterWrite();
            } else if (this.closeAfterWrite) {
                message.headers().remove((CharSequence)HttpHeaderNames.CONNECTION);
            }
            if (!HttpUtil.isContentLengthSet((HttpMessage)message) && !HttpUtil.isTransferEncodingChunked((HttpMessage)message) && PipeliningServerHandler.canHaveBody(message.status())) {
                HttpUtil.setKeepAlive((HttpMessage)message, (boolean)false);
                this.closeAfterWrite();
            }
        }

        private void writeContinue() {
            if (this.handler == null) {
                this.write(new ContinueOutboundHandler(this));
            }
        }

        private void write(OutboundHandler handler) {
            if (this.handler != null && !(this.handler instanceof ContinueOutboundHandler)) {
                throw new IllegalStateException("Only one response per request");
            }
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(() -> this.write(handler));
                return;
            }
            OutboundHandler outboundHandler = this.handler;
            if (outboundHandler instanceof ContinueOutboundHandler) {
                ContinueOutboundHandler cont = (ContinueOutboundHandler)outboundHandler;
                cont.next = handler;
                PipeliningServerHandler.this.writeSome();
            } else {
                this.handler = handler;
                if (PipeliningServerHandler.this.outboundQueue.peek() == this) {
                    PipeliningServerHandler.this.writeSome();
                }
            }
        }

        public void writeFull(FullHttpResponse response, boolean headResponse) {
            response.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            if (PipeliningServerHandler.canHaveBody(response.status())) {
                if (!headResponse) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
                }
            } else {
                response.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            }
            this.preprocess((HttpResponse)response);
            FullOutboundHandler oh = new FullOutboundHandler(this, response);
            this.prepareCompression((HttpResponse)response, oh);
            this.write(oh);
        }

        public void writeStreamed(HttpResponse response, Publisher<HttpContent> content) {
            response.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (PipeliningServerHandler.canHaveBody(response.status())) {
                response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            } else {
                response.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            }
            this.preprocess(response);
            StreamingOutboundHandler oh = new StreamingOutboundHandler(this, response);
            this.prepareCompression(response, oh);
            content.subscribe((Subscriber)oh);
        }

        public void writeStream(HttpResponse response, InputStream stream, ExecutorService executorService) {
            this.preprocess(response);
            BlockingOutboundHandler oh = new BlockingOutboundHandler(this, response, stream, executorService);
            this.prepareCompression(response, oh);
            this.write(oh);
        }

        private void prepareCompression(HttpResponse response, OutboundHandler outboundHandler) {
            if (PipeliningServerHandler.this.compressor == null) {
                return;
            }
            Compressor.Session compressionSession = PipeliningServerHandler.this.compressor.prepare(PipeliningServerHandler.this.ctx, this.request, response);
            if (compressionSession != null) {
                if (!(response instanceof FullHttpResponse) && response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                    response.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
                outboundHandler.compressionSession = compressionSession;
            }
        }
    }

    private final class BlockingOutboundHandler
    extends OutboundHandler {
        private final BlockingWriter blockingWriter;

        BlockingOutboundHandler(final OutboundAccessImpl outboundAccess, final HttpResponse response, InputStream stream, ExecutorService blockingExecutor) {
            super(outboundAccess);
            this.blockingWriter = new BlockingWriter(PipeliningServerHandler.this.ctx.alloc(), stream, blockingExecutor){

                @Override
                protected void writeStart() {
                    PipeliningServerHandler.this.write(response, false, false);
                }

                @Override
                protected boolean writeData(ByteBuf buf) {
                    BlockingOutboundHandler.this.writeCompressing((HttpContent)new DefaultHttpContent(buf), true, false);
                    return PipeliningServerHandler.this.ctx.channel().isWritable();
                }

                @Override
                protected void writeLast() {
                    BlockingOutboundHandler.this.writeCompressing((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT, true, outboundAccess.closeAfterWrite);
                    PipeliningServerHandler.this.outboundHandler = null;
                    PipeliningServerHandler.this.requestHandler.responseWritten(outboundAccess.attachment);
                    PipeliningServerHandler.this.writeSome();
                }

                @Override
                protected void writeSomeAsync() {
                    PipeliningServerHandler.this.ctx.executor().execute(PipeliningServerHandler.this::writeSome);
                }
            };
        }

        @Override
        void writeSome() {
            this.blockingWriter.writeSome();
        }

        @Override
        void discard() {
            super.discard();
            this.blockingWriter.discard();
            PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
        }
    }

    private final class StreamingOutboundHandler
    extends OutboundHandler
    implements Subscriber<HttpContent> {
        private final EventLoopFlow flow;
        private final OutboundAccessImpl outboundAccess;
        private HttpResponse initialMessage;
        private Subscription subscription;
        private boolean earlyComplete;
        private boolean writtenLast;

        StreamingOutboundHandler(OutboundAccessImpl outboundAccess, HttpResponse initialMessage) {
            super(outboundAccess);
            this.flow = new EventLoopFlow((OrderedEventExecutor)PipeliningServerHandler.this.ctx.channel().eventLoop());
            this.earlyComplete = false;
            this.writtenLast = false;
            if (initialMessage instanceof FullHttpResponse) {
                throw new IllegalArgumentException("Cannot have a full response as the initial message of a streaming response");
            }
            this.outboundAccess = outboundAccess;
            this.initialMessage = Objects.requireNonNull(initialMessage, "initialMessage");
        }

        @Override
        void writeSome() {
            if (this.initialMessage != null) {
                PipeliningServerHandler.this.write(this.initialMessage, false, false);
                this.initialMessage = null;
            }
            if (this.earlyComplete) {
                this.onComplete();
            } else {
                this.subscription.request(1L);
            }
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
            this.outboundAccess.write(this);
        }

        public void onNext(HttpContent httpContent) {
            if (this.flow.executeNow(() -> this.onNext0(httpContent))) {
                this.onNext0(httpContent);
            }
        }

        private void onNext0(HttpContent httpContent) {
            if (PipeliningServerHandler.this.outboundHandler != this) {
                throw new IllegalStateException("onNext before request?");
            }
            if (this.writtenLast) {
                throw new IllegalStateException("Already written a LastHttpContent");
            }
            if (!PipeliningServerHandler.this.removed) {
                boolean last = httpContent instanceof LastHttpContent;
                if (last) {
                    this.writtenLast = true;
                }
                this.writeCompressing(httpContent, true, last && this.outboundAccess.closeAfterWrite);
                if (PipeliningServerHandler.this.ctx.channel().isWritable()) {
                    this.subscription.request(1L);
                }
            } else {
                httpContent.release();
            }
        }

        public void onError(Throwable t) {
            if (this.flow.executeNow(() -> this.onError0(t))) {
                this.onError0(t);
            }
        }

        private void onError0(Throwable t) {
            if (!PipeliningServerHandler.this.removed) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Reactive response received an error after some data has already been written. This error cannot be forwarded to the client.", t);
                }
                PipeliningServerHandler.this.ctx.close();
                PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            }
        }

        public void onComplete() {
            if (this.flow.executeNow(this::onComplete0)) {
                this.onComplete0();
            }
        }

        private void onComplete0() {
            if (PipeliningServerHandler.this.outboundHandler != this) {
                this.earlyComplete = true;
                return;
            }
            PipeliningServerHandler.this.outboundHandler = null;
            if (!PipeliningServerHandler.this.removed) {
                if (this.initialMessage != null) {
                    PipeliningServerHandler.this.write(this.initialMessage, false, false);
                    this.initialMessage = null;
                }
                if (!this.writtenLast) {
                    this.writeCompressing((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT, true, this.outboundAccess.closeAfterWrite);
                }
                PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
                PipeliningServerHandler.this.writeSome();
            }
        }

        @Override
        void discard() {
            super.discard();
            PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            this.subscription.cancel();
            PipeliningServerHandler.this.outboundHandler = null;
        }
    }

    private final class FullOutboundHandler
    extends OutboundHandler {
        private final FullHttpResponse message;

        FullOutboundHandler(OutboundAccessImpl outboundAccess, FullHttpResponse message) {
            super(outboundAccess);
            this.message = message;
        }

        @Override
        void writeSome() {
            this.writeCompressing((HttpContent)this.message, true, this.outboundAccess.closeAfterWrite);
            PipeliningServerHandler.this.outboundHandler = null;
            PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            PipeliningServerHandler.this.writeSome();
        }

        @Override
        void discard() {
            super.discard();
            PipeliningServerHandler.this.outboundHandler = null;
            PipeliningServerHandler.this.requestHandler.responseWritten(this.outboundAccess.attachment);
            this.message.release();
        }
    }

    final class ContinueOutboundHandler
    extends OutboundHandler {
        static final FullHttpResponse CONTINUE_11 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        private static final FullHttpResponse CONTINUE_10 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        boolean written;
        OutboundHandler next;

        private ContinueOutboundHandler(OutboundAccessImpl outboundAccess) {
            super(outboundAccess);
            this.written = false;
        }

        @Override
        void writeSome() {
            if (!this.written) {
                PipeliningServerHandler.this.write(this.outboundAccess.request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0) ? CONTINUE_10 : CONTINUE_11, true, false);
                this.written = true;
            }
            if (this.next != null) {
                PipeliningServerHandler.this.outboundHandler = this.next;
            }
        }

        @Override
        void discard() {
            super.discard();
            if (this.next != null) {
                this.next.discard();
                this.next = null;
            }
        }
    }

    private class DecompressingInboundHandler
    extends InboundHandler {
        private final EmbeddedChannel channel;
        private InboundHandler delegate;

        public DecompressingInboundHandler(EmbeddedChannel channel, InboundHandler delegate) {
            this.channel = channel;
            this.delegate = delegate;
        }

        @Override
        void read(Object message) {
            ByteBuf decompressed;
            ByteBuf compressed = ((HttpContent)message).content();
            if (!compressed.isReadable()) {
                this.delegate.read(message);
                return;
            }
            boolean last = message instanceof LastHttpContent;
            try {
                this.channel.writeInbound(new Object[]{compressed});
                if (last) {
                    this.channel.finish();
                }
            }
            catch (DecompressionException e) {
                this.delegate.handleUpstreamError(e);
                this.channel.releaseInbound();
                if (last) {
                    PipeliningServerHandler.this.inboundHandler.read(LastHttpContent.EMPTY_LAST_CONTENT);
                }
                return;
            }
            while ((decompressed = (ByteBuf)this.channel.readInbound()) != null) {
                if (!decompressed.isReadable()) {
                    decompressed.release();
                    continue;
                }
                this.delegate.read(new DefaultHttpContent(decompressed));
            }
            if (last) {
                this.delegate.read(LastHttpContent.EMPTY_LAST_CONTENT);
            }
        }

        void dispose() {
            try {
                this.channel.finishAndReleaseAll();
            }
            catch (DecompressionException decompressionException) {
                // empty catch block
            }
        }

        @Override
        void readComplete() {
            this.delegate.readComplete();
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            this.delegate.handleUpstreamError(cause);
        }
    }

    private final class StreamingInboundHandler
    extends InboundHandler
    implements BufferConsumer.Upstream {
        final StreamingNettyByteBody.SharedBuffer dest;
        final OutboundAccessImpl outboundAccess;
        long requested = 65535L;
        boolean sendContinue;

        private StreamingInboundHandler(OutboundAccessImpl outboundAccess, boolean sendContinue) {
            this.outboundAccess = outboundAccess;
            this.sendContinue = sendContinue;
            this.dest = new StreamingNettyByteBody.SharedBuffer(PipeliningServerHandler.this.ctx.channel().eventLoop(), PipeliningServerHandler.this.bodySizeLimits, this);
        }

        @Override
        void read(Object message) {
            HttpContent content = (HttpContent)message;
            this.requested -= (long)content.content().readableBytes();
            this.dest.add(content.content());
            if (message instanceof LastHttpContent) {
                this.dest.complete();
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.baseInboundHandler;
            }
        }

        @Override
        void handleUpstreamError(Throwable cause) {
            this.dest.error(cause);
        }

        @Override
        boolean needMore() {
            return this.requested > 0L;
        }

        @Override
        public void start() {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(this::start);
                return;
            }
            if (this.sendContinue) {
                this.sendContinue = false;
                this.outboundAccess.writeContinue();
            }
        }

        @Override
        public void onBytesConsumed(long bytesConsumed) {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(() -> this.onBytesConsumed(bytesConsumed));
                return;
            }
            long newRequested = this.requested + bytesConsumed;
            if (newRequested < this.requested) {
                newRequested = Long.MAX_VALUE;
            }
            this.requested = newRequested;
            PipeliningServerHandler.this.refreshNeedMore();
        }

        @Override
        public void allowDiscard() {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(this::allowDiscard);
                return;
            }
            this.sendContinue = false;
            if (PipeliningServerHandler.this.inboundHandler == this) {
                PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.droppingInboundHandler;
                PipeliningServerHandler.this.refreshNeedMore();
            } else {
                InboundHandler inboundHandler = PipeliningServerHandler.this.inboundHandler;
                if (inboundHandler instanceof DecompressingInboundHandler) {
                    DecompressingInboundHandler dec = (DecompressingInboundHandler)inboundHandler;
                    if (dec.delegate == this) {
                        dec.dispose();
                        PipeliningServerHandler.this.inboundHandler = PipeliningServerHandler.this.droppingInboundHandler;
                        PipeliningServerHandler.this.refreshNeedMore();
                    }
                }
            }
            this.dest.discard();
        }

        @Override
        public void disregardBackpressure() {
            EventLoop eventLoop = PipeliningServerHandler.this.ctx.channel().eventLoop();
            if (!eventLoop.inEventLoop()) {
                eventLoop.execute(this::disregardBackpressure);
                return;
            }
            this.requested = Long.MAX_VALUE;
            PipeliningServerHandler.this.refreshNeedMore();
        }
    }
}

