/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.binders.NettyPartUploadAnnotationBinder;
import io.micronaut.http.server.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.netty.body.ImmediateMultiObjectBody;
import io.micronaut.http.server.netty.body.ImmediateSingleObjectBody;
import io.micronaut.web.router.RouteInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

final class NettyBodyAnnotationBinder<T>
extends DefaultBodyAnnotationBinder<T> {
    private static final Set<Class<?>> RAW_BODY_TYPES = CollectionUtils.setOf((Object[])new Class[]{String.class, byte[].class, ByteBuffer.class, InputStream.class});
    final HttpServerConfiguration httpServerConfiguration;
    final MessageBodyHandlerRegistry bodyHandlerRegistry;

    NettyBodyAnnotationBinder(ConversionService conversionService, HttpServerConfiguration httpServerConfiguration, MessageBodyHandlerRegistry bodyHandlerRegistry) {
        super(conversionService);
        this.httpServerConfiguration = httpServerConfiguration;
        this.bodyHandlerRegistry = bodyHandlerRegistry;
    }

    public static boolean isRaw(Argument<?> bodyType) {
        return RAW_BODY_TYPES.contains(bodyType.getType());
    }

    protected ArgumentBinder.BindingResult<T> bindBodyPart(ArgumentConversionContext<T> context, HttpRequest<?> source, String bodyComponent) {
        NettyHttpRequest nhr;
        if (source instanceof NettyHttpRequest && (nhr = (NettyHttpRequest)source).isFormOrMultipartData()) {
            return NettyPartUploadAnnotationBinder.bindPart(this.conversionService, context, nhr, bodyComponent, true);
        }
        return super.bindBodyPart(context, source, bodyComponent);
    }

    protected ArgumentBinder.BindingResult<ConvertibleValues<?>> bindFullBodyConvertibleValues(HttpRequest<?> source) {
        if (!(source instanceof NettyHttpRequest)) {
            return super.bindFullBodyConvertibleValues(source);
        }
        NettyHttpRequest nhr = (NettyHttpRequest)source;
        ArgumentBinder.BindingResult<ConvertibleValues<?>> existing = nhr.convertibleBody;
        if (existing != null) {
            return existing;
        }
        ArgumentBinder.BindingResult<T> result = this.bindFullBody(ConversionContext.of(ConvertibleValues.class), nhr);
        nhr.convertibleBody = result;
        return result;
    }

    public ArgumentBinder.BindingResult<T> bindFullBody(final ArgumentConversionContext<T> context, HttpRequest<?> source) {
        if (!(source instanceof NettyHttpRequest)) {
            return super.bindFullBody(context, source);
        }
        final NettyHttpRequest nhr = (NettyHttpRequest)source;
        if (nhr.byteBody().expectedLength().orElse(-1L) == 0L) {
            return ArgumentBinder.BindingResult.empty();
        }
        CloseableByteBody body = nhr.byteBody().split(ByteBody.SplitBackpressureMode.FASTEST);
        final ExecutionFlow buffered = InternalByteBody.bufferFlow((ByteBody)body);
        return new PendingRequestBindingResult<T>(){
            Optional<T> result;
            {
                nhr.addRouteWaitsFor(buffered.flatMap(imm -> {
                    ExecutionFlow executionFlow;
                    block8: {
                        PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext((HttpRequest)nhr)).propagate();
                        try {
                            this.result = NettyBodyAnnotationBinder.this.transform(nhr, context, (AvailableByteBody)imm);
                            executionFlow = ExecutionFlow.just(null);
                            if (ignore == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ignore != null) {
                                    try {
                                        ignore.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Throwable e) {
                                return ExecutionFlow.error((Throwable)e);
                            }
                        }
                        ignore.close();
                    }
                    return executionFlow;
                }));
            }

            public boolean isPending() {
                return this.result == null;
            }

            public Optional<T> getValue() {
                return this.result;
            }

            public List<ConversionError> getConversionErrors() {
                return context.getLastError().map(List::of).orElseGet(List::of);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<T> transform(NettyHttpRequest<?> nhr, ArgumentConversionContext<T> context, AvailableByteBody imm) throws Throwable {
        if (!NettyBodyAnnotationBinder.isRaw(context.getArgument())) {
            MediaType mediaType;
            if (nhr.isFormOrMultipartData()) {
                FormDataHttpContentProcessor processor = new FormDataHttpContentProcessor(nhr, this.httpServerConfiguration);
                ByteBuf buf = AvailableNettyByteBody.toByteBuf(imm);
                ArrayList result = new ArrayList();
                if (buf.isReadable()) {
                    processor.add((ByteBufHolder)new DefaultLastHttpContent(buf), result);
                } else {
                    buf.release();
                }
                processor.complete(result);
                Optional<Object> converted = new ImmediateMultiObjectBody(result).single(this.httpServerConfiguration.getDefaultCharset(), nhr.getChannelHandlerContext().alloc()).convert(this.conversionService, context).map(o -> o.claimForExternal());
                nhr.setLegacyBody(converted.orElse(null));
                return converted;
            }
            MessageBodyReader reader = null;
            RouteInfo routeInfo = nhr.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
            if (routeInfo != null) {
                reader = routeInfo.getMessageBodyReader();
            }
            if ((mediaType = (MediaType)nhr.getContentType().orElse(null)) != null) {
                if (reader == null) {
                    reader = this.bodyHandlerRegistry.findReader(context.getArgument(), List.of(mediaType)).orElse(null);
                }
                if (reader != null) {
                    Throwable rc;
                    ByteBuffer byteBuffer = imm.toByteBuffer();
                    boolean success = false;
                    try {
                        Object result = reader.read(context.getArgument(), mediaType, (Headers)nhr.getHeaders(), byteBuffer);
                        success = true;
                        nhr.setLegacyBody(result);
                        Optional<Object> optional = Optional.ofNullable(result);
                        return optional;
                    }
                    catch (CodecException ce) {
                        rc = ce.getCause();
                        if (rc instanceof Exception) {
                            Exception e = (Exception)rc;
                            context.reject(e);
                        } else {
                            context.reject((Exception)((Object)ce));
                        }
                        Optional optional = Optional.empty();
                        return optional;
                    }
                    finally {
                        if (!success && byteBuffer instanceof ReferenceCounted) {
                            rc = (ReferenceCounted)byteBuffer;
                            rc.release();
                        }
                    }
                }
            }
        }
        Optional<Object> converted = new ImmediateSingleObjectBody(imm.toByteBuffer().asNativeBuffer()).convert(this.conversionService, context).map(o -> o.claimForExternal());
        nhr.setLegacyBody(converted.orElse(null));
        return converted;
    }
}

