/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.server.netty.body.BufferConsumer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

@Internal
final class UpstreamBalancer {
    private static final AtomicLongFieldUpdater<UpstreamBalancer> DELTA = AtomicLongFieldUpdater.newUpdater(UpstreamBalancer.class, "delta");
    private static final AtomicIntegerFieldUpdater<UpstreamBalancer> FLAGS = AtomicIntegerFieldUpdater.newUpdater(UpstreamBalancer.class, "flags");
    private static final int FLAG_DISCARD_A = 1;
    private static final int FLAG_DISCARD_B = 2;
    private static final int MASK_DISCARD = 3;
    private static final int FLAG_START_A = 4;
    private static final int FLAG_START_B = 8;
    private static final int MASK_START = 12;
    private static final int FLAG_DISREGARD_A = 16;
    private static final int FLAG_DISREGARD_B = 32;
    private static final int MASK_DISREGARD = 48;
    private final BufferConsumer.Upstream upstream;
    private volatile long delta;
    private volatile int flags;

    private UpstreamBalancer(BufferConsumer.Upstream upstream) {
        this.upstream = upstream;
    }

    static UpstreamPair slowest(BufferConsumer.Upstream upstream) {
        UpstreamBalancer balancer;
        UpstreamBalancer upstreamBalancer = balancer = new UpstreamBalancer(upstream);
        Objects.requireNonNull(upstreamBalancer);
        SlowestUpstreamImpl slowestUpstreamImpl = upstreamBalancer.new SlowestUpstreamImpl(false);
        UpstreamBalancer upstreamBalancer2 = balancer;
        Objects.requireNonNull(upstreamBalancer2);
        return new UpstreamPair(slowestUpstreamImpl, upstreamBalancer2.new SlowestUpstreamImpl(true));
    }

    static UpstreamPair fastest(BufferConsumer.Upstream upstream) {
        UpstreamBalancer balancer;
        UpstreamBalancer upstreamBalancer = balancer = new UpstreamBalancer(upstream);
        Objects.requireNonNull(upstreamBalancer);
        FastestUpstreamImpl fastestUpstreamImpl = upstreamBalancer.new FastestUpstreamImpl(false);
        UpstreamBalancer upstreamBalancer2 = balancer;
        Objects.requireNonNull(upstreamBalancer2);
        return new UpstreamPair(fastestUpstreamImpl, upstreamBalancer2.new FastestUpstreamImpl(true));
    }

    static UpstreamPair first(BufferConsumer.Upstream upstream) {
        UpstreamBalancer balancer = new UpstreamBalancer(upstream);
        return new UpstreamPair(balancer.new PassthroughUpstreamImpl(), balancer.new IgnoringUpstreamImpl());
    }

    static UpstreamPair balancer(BufferConsumer.Upstream upstream, ByteBody.SplitBackpressureMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ByteBody.SplitBackpressureMode.SLOWEST -> UpstreamBalancer.slowest(upstream);
            case ByteBody.SplitBackpressureMode.FASTEST -> UpstreamBalancer.fastest(upstream);
            case ByteBody.SplitBackpressureMode.ORIGINAL -> UpstreamBalancer.first(upstream);
            case ByteBody.SplitBackpressureMode.NEW -> UpstreamBalancer.first(upstream).flip();
        };
    }

    private int getAndSetFlag(int flag) {
        int next;
        int current;
        do {
            if (((current = this.flags) & flag) == 0) continue;
            return current;
        } while (!FLAGS.compareAndSet(this, current, next = current | flag));
        return current;
    }

    private boolean setFlagAndCheckMask(int flag, int mask) {
        int old = this.getAndSetFlag(flag);
        return (old & mask) != mask && ((old | flag) & mask) == mask;
    }

    private static long subtractSaturating(long dest, long n) {
        assert (n >= 0L);
        long sum = dest - n;
        if (sum > dest || sum == Long.MIN_VALUE) {
            sum = -9223372036854775807L;
        }
        return sum;
    }

    private static long addSaturating(long dest, long n) {
        assert (n >= 0L);
        long sum = dest + n;
        if (sum < dest) {
            sum = Long.MAX_VALUE;
        }
        return sum;
    }

    private void addSlowest(boolean inv, long n) {
        long actual;
        if (n == 0L) {
            return;
        }
        assert (n > 0L);
        long oldValue = DELTA.getAndUpdate(this, prev -> inv ? UpstreamBalancer.subtractSaturating(prev, n) : UpstreamBalancer.addSaturating(prev, n));
        if (oldValue < 0L != inv && (actual = Math.min(n, Math.abs(oldValue))) > 0L) {
            this.upstream.onBytesConsumed(actual);
        }
    }

    private void addFastest(boolean inv, long n) {
        long actual;
        if (n == 0L) {
            return;
        }
        assert (n > 0L);
        long newValue = DELTA.updateAndGet(this, prev -> inv ? UpstreamBalancer.subtractSaturating(prev, n) : UpstreamBalancer.addSaturating(prev, n));
        if (newValue > 0L != inv && (actual = Math.min(n, Math.abs(newValue))) > 0L) {
            this.upstream.onBytesConsumed(actual);
        }
    }

    private void pushSomeFromIgnored() {
        long n = DELTA.getAndUpdate(this, l -> l > 0L ? 0L : l);
        if (n > 0L) {
            this.upstream.onBytesConsumed(n);
        }
    }

    public record UpstreamPair(BufferConsumer.Upstream left, BufferConsumer.Upstream right) {
        UpstreamPair flip() {
            return new UpstreamPair(this.right, this.left);
        }
    }

    private final class SlowestUpstreamImpl
    extends UpstreamImpl {
        SlowestUpstreamImpl(boolean inv) {
            super(inv);
        }

        @Override
        public void start() {
            int flag;
            int n = flag = this.inv ? 4 : 8;
            if (UpstreamBalancer.this.setFlagAndCheckMask(flag, 12)) {
                UpstreamBalancer.this.upstream.start();
            }
        }

        @Override
        public void onBytesConsumed(long bytesConsumed) {
            UpstreamBalancer.this.addSlowest(this.inv, bytesConsumed);
        }

        @Override
        protected void disregardBackpressureThisSide() {
            this.onBytesConsumed(Long.MAX_VALUE);
        }
    }

    private final class FastestUpstreamImpl
    extends UpstreamImpl {
        FastestUpstreamImpl(boolean inv) {
            super(inv);
        }

        @Override
        public void start() {
            UpstreamBalancer.this.upstream.start();
        }

        @Override
        public void onBytesConsumed(long bytesConsumed) {
            UpstreamBalancer.this.addFastest(this.inv, bytesConsumed);
        }
    }

    private final class PassthroughUpstreamImpl
    extends UpstreamImpl {
        PassthroughUpstreamImpl() {
            super(false);
        }

        @Override
        public void start() {
            UpstreamBalancer.this.upstream.start();
        }

        @Override
        public void onBytesConsumed(long bytesConsumed) {
            DELTA.updateAndGet(UpstreamBalancer.this, old -> UpstreamBalancer.subtractSaturating(old, bytesConsumed));
            UpstreamBalancer.this.upstream.onBytesConsumed(bytesConsumed);
        }

        @Override
        protected void disregardBackpressureThisSide() {
            UpstreamBalancer.this.pushSomeFromIgnored();
        }
    }

    private final class IgnoringUpstreamImpl
    extends UpstreamImpl {
        IgnoringUpstreamImpl() {
            super(true);
        }

        @Override
        public void onBytesConsumed(long bytesConsumed) {
            DELTA.updateAndGet(UpstreamBalancer.this, old -> UpstreamBalancer.addSaturating(old, bytesConsumed));
            if ((UpstreamBalancer.this.flags & 0x10) != 0) {
                UpstreamBalancer.this.pushSomeFromIgnored();
            }
        }
    }

    private abstract class UpstreamImpl
    implements BufferConsumer.Upstream {
        final boolean inv;

        UpstreamImpl(boolean inv) {
            this.inv = inv;
        }

        @Override
        public void allowDiscard() {
            int flag;
            int n = flag = this.inv ? 2 : 1;
            if (UpstreamBalancer.this.setFlagAndCheckMask(flag, 3)) {
                UpstreamBalancer.this.upstream.allowDiscard();
            }
        }

        @Override
        public void disregardBackpressure() {
            int flag = this.inv ? 32 : 16;
            int old = UpstreamBalancer.this.getAndSetFlag(flag);
            if ((old & 0x30) != 48 && ((old | flag) & 0x30) == 48) {
                UpstreamBalancer.this.upstream.disregardBackpressure();
            } else if ((old | flag) != old) {
                this.disregardBackpressureThisSide();
            }
        }

        protected void disregardBackpressureThisSide() {
        }
    }
}

