/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.body.AvailableByteBody;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.netty.EventLoopFlow;
import io.micronaut.http.server.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.netty.body.BodySizeLimits;
import io.micronaut.http.server.netty.body.BufferConsumer;
import io.micronaut.http.server.netty.body.NettyByteBody;
import io.micronaut.http.server.netty.body.StreamingNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;

@Internal
public final class NettyBodyAdapter
implements BufferConsumer.Upstream,
Subscriber<ByteBuf> {
    private final EventLoopFlow eventLoopFlow;
    private final Publisher<ByteBuf> source;
    private volatile boolean cancelled;
    private volatile Subscription subscription;
    private StreamingNettyByteBody.SharedBuffer sharedBuffer;
    private final AtomicLong demand = new AtomicLong(1L);

    private NettyBodyAdapter(EventLoop eventLoop, Publisher<ByteBuf> source) {
        this.eventLoopFlow = new EventLoopFlow((OrderedEventExecutor)eventLoop);
        this.source = source;
    }

    @NonNull
    public static NettyByteBody adapt(@NonNull ByteBody body, @NonNull EventLoop eventLoop) {
        if (body instanceof NettyByteBody) {
            NettyByteBody nbb = (NettyByteBody)body;
            return nbb;
        }
        if (body instanceof AvailableByteBody) {
            AvailableByteBody available = (AvailableByteBody)body;
            return new AvailableNettyByteBody(Unpooled.wrappedBuffer((byte[])available.toByteArray()));
        }
        return NettyBodyAdapter.adapt((Publisher<ByteBuf>)Flux.from((Publisher)body.toByteArrayPublisher()).map(Unpooled::wrappedBuffer), eventLoop);
    }

    public static StreamingNettyByteBody adapt(Publisher<ByteBuf> publisher, EventLoop eventLoop) {
        NettyBodyAdapter adapter = new NettyBodyAdapter(eventLoop, publisher);
        adapter.sharedBuffer = new StreamingNettyByteBody.SharedBuffer(eventLoop, BodySizeLimits.UNLIMITED, adapter);
        return new StreamingNettyByteBody(adapter.sharedBuffer);
    }

    @Override
    public void start() {
        this.source.subscribe((Subscriber)this);
    }

    @Override
    public void onBytesConsumed(long bytesConsumed) {
        if (bytesConsumed < 0L) {
            throw new IllegalArgumentException("Negative bytes consumed");
        }
        LongUnaryOperator add = l -> l + bytesConsumed < l ? Long.MAX_VALUE : l + bytesConsumed;
        long oldDemand = this.demand.getAndUpdate(add);
        long newDemand = add.applyAsLong(oldDemand);
        if (oldDemand <= 0L && newDemand > 0L) {
            this.subscription.request(1L);
        }
    }

    @Override
    public void allowDiscard() {
        this.cancelled = true;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    @Override
    public void disregardBackpressure() {
        this.demand.set(Long.MAX_VALUE);
        if (this.subscription != null) {
            this.subscription.request(Long.MAX_VALUE);
        }
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        long demand = this.demand.get();
        s.request(demand);
        if (this.cancelled) {
            s.cancel();
        }
    }

    public void onNext(ByteBuf bytes) {
        if (this.eventLoopFlow.executeNow(() -> this.onNext0(bytes))) {
            this.onNext0(bytes);
        }
    }

    private void onNext0(ByteBuf bytes) {
        this.demand.addAndGet(-bytes.readableBytes());
        this.sharedBuffer.add(bytes);
    }

    public void onError(Throwable t) {
        if (this.eventLoopFlow.executeNow(() -> this.sharedBuffer.error(t))) {
            this.sharedBuffer.error(t);
        }
    }

    public void onComplete() {
        if (this.eventLoopFlow.executeNow(() -> this.sharedBuffer.complete())) {
            this.sharedBuffer.complete();
        }
    }
}

