/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.server.netty.body.AbstractFileBodyWriter;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.handler.codec.http.HttpHeaderNames;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@Internal
@Singleton
public final class InputStreamBodyWriter
extends AbstractFileBodyWriter
implements ResponseBodyWriter<InputStream> {
    private final ExecutorService executorService;

    InputStreamBodyWriter(NettyHttpServerConfiguration.FileTypeHandlerConfiguration configuration, @Named(value="blocking") ExecutorService executorService) {
        super(configuration);
        this.executorService = executorService;
    }

    public ByteBodyHttpResponse<?> write(ByteBufferFactory<?, ?> bufferFactory, HttpRequest<?> request, MutableHttpResponse<InputStream> outgoingResponse, Argument<InputStream> type, MediaType mediaType, InputStream object) throws CodecException {
        outgoingResponse.getHeaders().setIfMissing((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)mediaType);
        return ByteBodyHttpResponseWrapper.wrap(outgoingResponse, (CloseableByteBody)InputStreamByteBody.create((InputStream)object, (OptionalLong)OptionalLong.empty(), (Executor)this.executorService, (ByteBufferFactory)NettyByteBufferFactory.DEFAULT));
    }

    public void writeTo(Argument<InputStream> type, MediaType mediaType, InputStream object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        throw new UnsupportedOperationException("Can only be used in a Netty context");
    }
}

