/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.DefaultApplicationContext;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.server.netty.CompositeNettyServerCustomizer;
import io.micronaut.http.server.netty.HttpPipelineBuilder;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyServerCustomizer;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.util.DefaultHttpHostResolver;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.web.router.Router;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnixDomainSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@TypeHint(value={ChannelOption.class}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS})
public class NettyHttpServer
implements NettyEmbeddedServer {
    public static final String OUTBOUND_KEY = "-outbound-";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final NettyEmbeddedServices nettyEmbeddedServices;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final ServerSslConfiguration sslConfiguration;
    private final Environment environment;
    private final RoutingInBoundHandler routingHandler;
    private final boolean isDefault;
    private final ApplicationContext applicationContext;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ChannelGroup webSocketSessions = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final HttpHostResolver hostResolver;
    private boolean shutdownWorker = false;
    private boolean shutdownParent = false;
    private EventLoopGroup workerGroup;
    private EventLoopGroup parentGroup;
    private final Collection<ChannelPipelineListener> pipelineListeners = new ArrayList<ChannelPipelineListener>(2);
    @Nullable
    private volatile List<Listener> activeListeners = null;
    private final List<NettyHttpServerConfiguration.NettyListenerConfiguration> listenerConfigurations;
    private final CompositeNettyServerCustomizer rootCustomizer = new CompositeNettyServerCustomizer();

    public NettyHttpServer(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices nettyEmbeddedServices, boolean isDefault) {
        this.isDefault = isDefault;
        this.serverConfiguration = serverConfiguration;
        this.nettyEmbeddedServices = nettyEmbeddedServices;
        Optional location = this.serverConfiguration.getMultipart().getLocation();
        location.ifPresent(dir -> {
            DiskFileUpload.baseDirectory = dir.getAbsolutePath();
        });
        this.applicationContext = nettyEmbeddedServices.getApplicationContext();
        this.environment = this.applicationContext.getEnvironment();
        ServerSslBuilder serverSslBuilder = nettyEmbeddedServices.getServerSslBuilder();
        this.sslConfiguration = serverSslBuilder != null ? serverSslBuilder.getSslConfiguration() : null;
        ApplicationEventPublisher<HttpRequestTerminatedEvent> httpRequestTerminatedEventPublisher = nettyEmbeddedServices.getEventPublisher(HttpRequestTerminatedEvent.class);
        Supplier ioExecutor = SupplierUtil.memoized(() -> nettyEmbeddedServices.getExecutorSelector().select("blocking").orElse(null));
        this.routingHandler = new RoutingInBoundHandler(serverConfiguration, nettyEmbeddedServices, ioExecutor, httpRequestTerminatedEventPublisher, this.applicationContext.getConversionService());
        this.hostResolver = new DefaultHttpHostResolver((HttpServerConfiguration)serverConfiguration, () -> this);
        this.listenerConfigurations = this.buildListenerConfigurations();
    }

    private List<NettyHttpServerConfiguration.NettyListenerConfiguration> buildListenerConfigurations() {
        List<NettyHttpServerConfiguration.NettyListenerConfiguration> explicit = this.serverConfiguration.getListeners();
        if (explicit != null) {
            if (explicit.isEmpty()) {
                throw new IllegalArgumentException("When configuring listeners explicitly, must specify at least one");
            }
            return explicit;
        }
        String configuredHost = this.serverConfiguration.getHost().orElse(null);
        ArrayList<NettyHttpServerConfiguration.NettyListenerConfiguration> implicit = new ArrayList<NettyHttpServerConfiguration.NettyListenerConfiguration>(2);
        ServerSslBuilder serverSslBuilder = this.nettyEmbeddedServices.getServerSslBuilder();
        if (serverSslBuilder != null && this.sslConfiguration.isEnabled()) {
            implicit.add(NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, this.sslConfiguration.getPort(), true));
        } else {
            implicit.add(NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, this.getHttpPort(this.serverConfiguration), false));
        }
        if (this.isDefault) {
            if (this.serverConfiguration.isDualProtocol()) {
                implicit.add(NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, this.getHttpPort(this.serverConfiguration), false));
            }
            Router router = this.nettyEmbeddedServices.getRouter();
            Set exposedPorts = router.getExposedPorts();
            Iterator iterator = exposedPorts.iterator();
            while (iterator.hasNext()) {
                int exposedPort = (Integer)iterator.next();
                if (exposedPort != -1 && exposedPort != 0 && !implicit.stream().noneMatch(cfg -> cfg.getPort() == exposedPort)) continue;
                NettyHttpServerConfiguration.NettyListenerConfiguration mgmt = NettyHttpServerConfiguration.NettyListenerConfiguration.createTcp(configuredHost, exposedPort, false);
                mgmt.setExposeDefaultRoutes(false);
                implicit.add(mgmt);
            }
        }
        return implicit;
    }

    private int getHttpPort(NettyHttpServerConfiguration serverConfiguration) {
        Integer configPort = serverConfiguration.getPort().orElse(null);
        return this.getHttpPort(configPort);
    }

    private int getHttpPort(Integer configPort) {
        if (configPort != null) {
            return configPort;
        }
        if (this.environment.getActiveNames().contains("test")) {
            return -1;
        }
        return 8080;
    }

    public boolean isKeepAlive() {
        return false;
    }

    public NettyHttpServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    @NonNull
    public synchronized NettyEmbeddedServer start() {
        if (!this.isRunning()) {
            Router router;
            Set exposedPorts;
            if (this.isDefault && !this.applicationContext.isRunning()) {
                ApplicationContext applicationContext = this.applicationContext;
                if (applicationContext instanceof DefaultApplicationContext) {
                    DefaultApplicationContext defaultApplicationContext = (DefaultApplicationContext)applicationContext;
                    defaultApplicationContext.setEnvironment(this.environment);
                }
                this.applicationContext.start();
            }
            EventLoopGroupConfiguration workerConfig = this.resolveWorkerConfiguration();
            this.workerGroup = this.createWorkerEventLoopGroup(workerConfig);
            this.parentGroup = this.createParentEventLoopGroup();
            Supplier serverBootstrap = SupplierUtil.memoized(() -> {
                ServerBootstrap sb = this.createServerBootstrap();
                this.processOptions(this.serverConfiguration.getOptions(), (arg_0, arg_1) -> ((ServerBootstrap)sb).option(arg_0, arg_1));
                this.processOptions(this.serverConfiguration.getChildOptions(), (arg_0, arg_1) -> ((ServerBootstrap)sb).childOption(arg_0, arg_1));
                sb.group(this.parentGroup, this.workerGroup);
                return sb;
            });
            Supplier udpBootstrap = SupplierUtil.memoized(() -> {
                Bootstrap ub = new Bootstrap();
                this.processOptions(this.serverConfiguration.getOptions(), (arg_0, arg_1) -> ((Bootstrap)ub).option(arg_0, arg_1));
                ub.group(this.workerGroup);
                return ub;
            });
            Supplier acceptedBootstrap = SupplierUtil.memoized(() -> {
                Bootstrap ub = new Bootstrap();
                this.processOptions(this.serverConfiguration.getChildOptions(), (arg_0, arg_1) -> ((Bootstrap)ub).option(arg_0, arg_1));
                ub.group(this.workerGroup);
                return ub;
            });
            ArrayList<Listener> listeners = new ArrayList<Listener>();
            for (NettyHttpServerConfiguration.NettyListenerConfiguration listenerConfiguration : this.listenerConfigurations) {
                listeners.add(this.bind(serverBootstrap, udpBootstrap, acceptedBootstrap, listenerConfiguration, workerConfig));
            }
            this.activeListeners = Collections.unmodifiableList(listeners);
            if (this.isDefault && CollectionUtils.isNotEmpty((Collection)(exposedPorts = (router = this.nettyEmbeddedServices.getRouter()).getExposedPorts()))) {
                router.applyDefaultPorts(listeners.stream().filter(l -> l.config.isExposeDefaultRoutes()).map(l -> l.serverChannel.localAddress()).filter(InetSocketAddress.class::isInstance).map(addr -> ((InetSocketAddress)addr).getPort()).toList());
            }
            this.fireStartupEvents();
            this.running.set(true);
        }
        return this;
    }

    private EventLoopGroupConfiguration resolveWorkerConfiguration() {
        NettyHttpServerConfiguration.Worker workerConfig = this.serverConfiguration.getWorker();
        if (workerConfig == null) {
            workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration("default").orElse(null);
        } else {
            String eventLoopGroupName = workerConfig.getName();
            if (!"default".equals(eventLoopGroupName)) {
                workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration(eventLoopGroupName).orElse(workerConfig);
            }
        }
        return workerConfig;
    }

    @Override
    @NonNull
    public synchronized NettyEmbeddedServer stop() {
        return this.stop(false);
    }

    @Override
    @NonNull
    public NettyEmbeddedServer stopServerOnly() {
        return this.stop(true);
    }

    @NonNull
    private NettyEmbeddedServer stop(boolean stopServerOnly) {
        if (this.isRunning() && this.workerGroup != null && this.running.compareAndSet(true, false)) {
            this.stopInternal(stopServerOnly);
        }
        return this;
    }

    @Override
    public void register(@NonNull NettyServerCustomizer customizer) {
        Objects.requireNonNull(customizer, "customizer");
        this.rootCustomizer.add(customizer);
    }

    public int getPort() {
        List<Listener> listenersLocal = this.activeListeners;
        boolean hasRandom = false;
        boolean hasUnix = false;
        if (listenersLocal == null) {
            for (NettyHttpServerConfiguration.NettyListenerConfiguration listenerCfg : this.listenerConfigurations) {
                switch (listenerCfg.getFamily()) {
                    case TCP: 
                    case QUIC: {
                        if (listenerCfg.getPort() == -1) {
                            hasRandom = true;
                            break;
                        }
                        return listenerCfg.getPort();
                    }
                    case UNIX: {
                        hasUnix = true;
                        break;
                    }
                }
            }
        } else {
            for (Listener listener : listenersLocal) {
                SocketAddress localAddress = listener.serverChannel.localAddress();
                if (localAddress instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)localAddress;
                    return address.getPort();
                }
                hasUnix = true;
            }
        }
        if (hasRandom) {
            throw new UnsupportedOperationException("Retrieving the port from the server before it has started is not supported when binding to a random port");
        }
        if (hasUnix) {
            throw new UnsupportedOperationException("Retrieving the port from the server is not supported for unix domain sockets");
        }
        throw new UnsupportedOperationException("Could not retrieve server port");
    }

    public String getHost() {
        return this.serverConfiguration.getHost().orElseGet(() -> Optional.ofNullable(CachedEnvironment.getenv((String)"HOSTNAME")).orElse("localhost"));
    }

    public String getScheme() {
        return this.sslConfiguration != null && this.sslConfiguration.isEnabled() ? "https" : "http";
    }

    public URL getURL() {
        try {
            return new URL(this.getScheme() + "://" + this.getHost() + ":" + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        try {
            return new URI(this.getScheme() + "://" + this.getHost() + ":" + this.getPort());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI getContextURI() {
        try {
            String contextPath = this.serverConfiguration.getContextPath();
            if (contextPath == null) {
                return this.getURI();
            }
            return new URI(this.getScheme() + "://" + this.getHost() + ":" + this.getPort() + contextPath);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.serverConfiguration.getApplicationConfiguration();
    }

    @Override
    public final Set<Integer> getBoundPorts() {
        List<Listener> listeners = this.activeListeners;
        if (listeners == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(listeners.stream().map(l -> l.serverChannel.localAddress()).filter(InetSocketAddress.class::isInstance).map(addr -> ((InetSocketAddress)addr).getPort()).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    protected EventLoopGroup createParentEventLoopGroup() {
        NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(parent != null ? parent.getName() : "parent").orElseGet(() -> {
            EventLoopGroup newGroup = this.newEventLoopGroup(parent);
            this.shutdownParent = true;
            return newGroup;
        });
    }

    protected EventLoopGroup createWorkerEventLoopGroup(@Nullable EventLoopGroupConfiguration workerConfig) {
        String configName = workerConfig != null ? workerConfig.getName() : "default";
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(configName).orElseGet(() -> {
            LOG.warn("The configuration for 'micronaut.server.netty.worker.{}' is deprecated. Use 'micronaut.netty.event-loops.default' configuration instead.", (Object)configName);
            EventLoopGroup newGroup = this.newEventLoopGroup(workerConfig);
            this.shutdownWorker = true;
            return newGroup;
        });
    }

    protected ServerBootstrap createServerBootstrap() {
        return new ServerBootstrap();
    }

    private Listener bind(Supplier<ServerBootstrap> serverBootstrap, Supplier<Bootstrap> udpBootstrap, Supplier<Bootstrap> acceptedBootstrap, NettyHttpServerConfiguration.NettyListenerConfiguration cfg, EventLoopGroupConfiguration workerConfig) {
        this.logBind(cfg);
        try {
            Listener listener;
            Integer fd = cfg.getFd();
            if (cfg.getFamily() == NettyHttpServerConfiguration.NettyListenerConfiguration.Family.QUIC) {
                listener = new UdpListener(cfg);
                Bootstrap listenerBootstrap = (Bootstrap)((Bootstrap)udpBootstrap.get().clone().handler((ChannelHandler)listener)).channelFactory(() -> {
                    if (fd != null) {
                        return this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.DATAGRAM_SOCKET, workerConfig, null, fd);
                    }
                    return this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.DATAGRAM_SOCKET, workerConfig);
                });
                int port = cfg.getPort();
                if (port == -1) {
                    port = 0;
                }
                ChannelFuture future = cfg.isBind() ? (cfg.getHost() == null ? listenerBootstrap.bind(port) : listenerBootstrap.bind(cfg.getHost(), port)) : listenerBootstrap.register();
                future.syncUninterruptibly();
            } else {
                Channel parent;
                listener = new Listener(cfg);
                if (cfg.isServerSocket()) {
                    ServerBootstrap listenerBootstrap = ((ServerBootstrap)serverBootstrap.get().clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                        protected void initChannel(@NonNull Channel ch) {
                            listener.setServerChannel(ch);
                        }
                    })).childHandler((ChannelHandler)listener);
                    ChannelFuture future = switch (cfg.getFamily()) {
                        case NettyHttpServerConfiguration.NettyListenerConfiguration.Family.TCP -> {
                            listenerBootstrap.channelFactory(() -> {
                                if (fd != null) {
                                    return (ServerSocketChannel)this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.SERVER_SOCKET, workerConfig, null, fd);
                                }
                                return (ServerSocketChannel)this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.SERVER_SOCKET, workerConfig);
                            });
                            int port = cfg.getPort();
                            if (port == -1) {
                                port = 0;
                            }
                            if (cfg.isBind()) {
                                if (cfg.getHost() == null) {
                                    yield listenerBootstrap.bind(port);
                                }
                                yield listenerBootstrap.bind(cfg.getHost(), port);
                            }
                            yield listenerBootstrap.register();
                        }
                        case NettyHttpServerConfiguration.NettyListenerConfiguration.Family.UNIX -> {
                            listenerBootstrap.channelFactory(() -> {
                                if (fd != null) {
                                    return (ServerChannel)this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.DOMAIN_SERVER_SOCKET, workerConfig, null, fd);
                                }
                                return (ServerChannel)this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.DOMAIN_SERVER_SOCKET, workerConfig);
                            });
                            if (cfg.isBind()) {
                                if (listenerBootstrap.config().group() instanceof NioEventLoopGroup) {
                                    yield listenerBootstrap.bind((SocketAddress)UnixDomainSocketAddress.of(cfg.getPath()));
                                }
                                yield listenerBootstrap.bind(DomainSocketHolder.makeDomainSocketAddress(cfg.getPath()));
                            }
                            yield listenerBootstrap.register();
                        }
                        default -> throw new UnsupportedOperationException("Unsupported family: " + String.valueOf((Object)cfg.getFamily()));
                    };
                    future.syncUninterruptibly();
                    parent = future.channel();
                } else {
                    parent = null;
                }
                Integer acceptedFd = cfg.getAcceptedFd();
                if (acceptedFd != null) {
                    ChannelFactory cf = switch (cfg.getFamily()) {
                        case NettyHttpServerConfiguration.NettyListenerConfiguration.Family.TCP -> () -> this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.CLIENT_SOCKET, workerConfig, parent, acceptedFd);
                        case NettyHttpServerConfiguration.NettyListenerConfiguration.Family.UNIX -> () -> this.nettyEmbeddedServices.getChannelInstance(NettyChannelType.DOMAIN_SOCKET, workerConfig, parent, acceptedFd);
                        default -> throw new UnsupportedOperationException("Unsupported family: " + String.valueOf((Object)cfg.getFamily()));
                    };
                    if (parent == null) {
                        ChannelFactory innerFactory = cf;
                        cf = () -> {
                            Channel ch = innerFactory.newChannel();
                            listener.setServerChannel(ch);
                            return ch;
                        };
                    }
                    ((Bootstrap)((Bootstrap)acceptedBootstrap.get().clone().handler((ChannelHandler)listener)).channelFactory(cf)).register().syncUninterruptibly();
                }
            }
            return listener;
        }
        catch (Exception e) {
            boolean isBindError = e instanceof BindException;
            if (LOG.isErrorEnabled()) {
                if (isBindError) {
                    LOG.error("Unable to start server. Port {} already in use.", (Object)NettyHttpServer.displayAddress(cfg));
                } else {
                    LOG.error("Error starting Micronaut server: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            this.stopInternal(false);
            throw new ServerStartupException("Unable to start Micronaut server on " + NettyHttpServer.displayAddress(cfg), (Throwable)e);
        }
    }

    private void logBind(NettyHttpServerConfiguration.NettyListenerConfiguration cfg) {
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        if (applicationName.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding {} server to {}", applicationName.get(), (Object)NettyHttpServer.displayAddress(cfg));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Binding server to {}", (Object)NettyHttpServer.displayAddress(cfg));
        }
    }

    private static String displayAddress(NettyHttpServerConfiguration.NettyListenerConfiguration cfg) {
        return switch (cfg.getFamily()) {
            default -> throw new IncompatibleClassChangeError();
            case NettyHttpServerConfiguration.NettyListenerConfiguration.Family.TCP, NettyHttpServerConfiguration.NettyListenerConfiguration.Family.QUIC -> {
                if (cfg.getHost() == null) {
                    yield "*:" + cfg.getPort();
                }
                yield cfg.getHost() + ":" + cfg.getPort();
            }
            case NettyHttpServerConfiguration.NettyListenerConfiguration.Family.UNIX -> {
                if (cfg.getPath() == null) {
                    if (cfg.getFd() == null) {
                        yield "unix:accepted-fd:" + cfg.getAcceptedFd();
                    }
                    yield "unix:fd:" + cfg.getFd();
                }
                yield cfg.getPath().startsWith("\u0000") ? "unix:@" + cfg.getPath().substring(1) : "unix:" + cfg.getPath();
            }
        };
    }

    private void fireStartupEvents() {
        this.applicationContext.getEventPublisher(ServerStartupEvent.class).publishEvent((Object)new ServerStartupEvent((EmbeddedServer)this));
    }

    private void logShutdownErrorIfNecessary(Future<?> future) {
        if (!future.isSuccess() && LOG.isWarnEnabled()) {
            Throwable e = future.cause();
            LOG.warn("Error stopping Micronaut server: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void stopInternal(boolean stopServerOnly) {
        block13: {
            ArrayList<Future> futures = new ArrayList<Future>(2);
            try {
                if (this.shutdownParent) {
                    NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
                    if (parent != null) {
                        long quietPeriod = parent.getShutdownQuietPeriod().toMillis();
                        long timeout = parent.getShutdownTimeout().toMillis();
                        futures.add(this.parentGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS).addListener(this::logShutdownErrorIfNecessary));
                    } else {
                        futures.add(this.parentGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary));
                    }
                }
                if (this.shutdownWorker) {
                    futures.add(this.workerGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary));
                }
                this.webSocketSessions.close();
                this.applicationContext.getEventPublisher(ServerShutdownEvent.class).publishEvent((Object)new ServerShutdownEvent((EmbeddedServer)this));
                if (this.isDefault && this.applicationContext.isRunning() && !stopServerOnly) {
                    this.applicationContext.stop();
                }
                this.serverConfiguration.getMultipart().getLocation().ifPresent(dir -> {
                    DiskFileUpload.baseDirectory = null;
                });
                if (this.activeListeners != null) {
                    for (Listener listener : this.activeListeners) {
                        if (listener.httpPipelineBuilder == null) continue;
                        listener.httpPipelineBuilder.close();
                        listener.httpPipelineBuilder = null;
                    }
                }
                this.activeListeners = null;
                if (stopServerOnly) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Waiting for graceful shutdown to complete");
                    }
                    for (Future future : futures) {
                        future.awaitUninterruptibly();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Done...");
                    }
                }
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block13;
                LOG.error("Error stopping Micronaut server: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private EventLoopGroup newEventLoopGroup(EventLoopGroupConfiguration config) {
        if (config != null) {
            ExecutorService executorService = config.getExecutorName().flatMap(name -> this.applicationContext.findBean(ExecutorService.class, Qualifiers.byName((String)name))).orElse(null);
            if (executorService != null) {
                return this.nettyEmbeddedServices.createEventLoopGroup(config.getNumThreads(), executorService, config.getIoRatio().orElse(null));
            }
            return this.nettyEmbeddedServices.createEventLoopGroup(config);
        }
        return this.nettyEmbeddedServices.createEventLoopGroup((EventLoopGroupConfiguration)new DefaultEventLoopGroupConfiguration());
    }

    private void processOptions(Map<ChannelOption, Object> options, BiConsumer<ChannelOption, Object> biConsumer) {
        ChannelOptionFactory channelOptionFactory = this.nettyEmbeddedServices.getChannelOptionFactory();
        options.forEach((option, value) -> biConsumer.accept((ChannelOption)option, channelOptionFactory.convertValue(option, value, this.environment)));
    }

    public void addChannel(Channel channel) {
        this.webSocketSessions.add((Object)channel);
    }

    public void removeChannel(Channel channel) {
        this.webSocketSessions.remove((Object)channel);
    }

    public ChannelGroup getChannelGroup() {
        return this.webSocketSessions;
    }

    public WebSocketSessionRepository getWebSocketSessionRepository() {
        return this;
    }

    public boolean isClientChannel() {
        return false;
    }

    public void doOnConnect(@NonNull ChannelPipelineListener listener) {
        this.pipelineListeners.add(Objects.requireNonNull(listener, "The listener cannot be null"));
    }

    public Set<String> getObservedConfigurationPrefixes() {
        return Set.of("micronaut.server", "micronaut.ssl");
    }

    public void onApplicationEvent(RefreshEvent event) {
        List<Listener> listeners = this.activeListeners;
        if (listeners != null) {
            for (Listener listener : listeners) {
                listener.refresh();
            }
        }
    }

    final void triggerPipelineListeners(ChannelPipeline pipeline) {
        for (ChannelPipelineListener pipelineListener : this.pipelineListeners) {
            pipelineListener.onConnect(pipeline);
        }
    }

    private HttpPipelineBuilder createPipelineBuilder(NettyServerCustomizer customizer, boolean quic) {
        Objects.requireNonNull(customizer, "customizer");
        return new HttpPipelineBuilder(this, this.nettyEmbeddedServices, this.sslConfiguration, this.routingHandler, this.hostResolver, customizer, quic);
    }

    @Internal
    public EmbeddedChannel buildEmbeddedChannel(boolean ssl) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelDuplexHandler(){
            boolean reading = false;
            ChannelPromise closePromise;

            public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
                this.reading = true;
                ctx.fireChannelRead(msg);
                this.reading = false;
                ChannelPromise closePromise = this.closePromise;
                if (closePromise != null) {
                    this.closePromise = null;
                    ctx.close(closePromise);
                }
            }

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                if (this.reading) {
                    this.closePromise = promise;
                } else {
                    ctx.close(promise);
                }
            }
        }});
        this.buildEmbeddedChannel(channel, ssl);
        return channel;
    }

    @Internal
    public void buildEmbeddedChannel(EmbeddedChannel prototype, boolean ssl) {
        try (HttpPipelineBuilder builder = this.createPipelineBuilder(this.rootCustomizer, false);){
            HttpPipelineBuilder httpPipelineBuilder = builder;
            Objects.requireNonNull(httpPipelineBuilder);
            httpPipelineBuilder.new HttpPipelineBuilder.ConnectionPipeline((Channel)prototype, ssl).initChannel();
        }
    }

    static Predicate<String> inclusionPredicate(NettyHttpServerConfiguration.AccessLogger config) {
        List<String> exclusions = config.getExclusions();
        if (CollectionUtils.isEmpty(exclusions)) {
            return null;
        }
        List patterns = exclusions.stream().map(Pattern::compile).collect(Collectors.toList());
        return uri -> patterns.stream().noneMatch(pattern -> pattern.matcher((CharSequence)uri).matches());
    }

    private class Listener
    extends ChannelInitializer<Channel> {
        Channel serverChannel;
        NettyServerCustomizer listenerCustomizer;
        NettyHttpServerConfiguration.NettyListenerConfiguration config;
        volatile HttpPipelineBuilder httpPipelineBuilder;

        Listener(NettyHttpServerConfiguration.NettyListenerConfiguration config) {
            this.config = config;
        }

        void refresh() {
            HttpPipelineBuilder oldBuilder = this.httpPipelineBuilder;
            this.httpPipelineBuilder = NettyHttpServer.this.createPipelineBuilder(this.listenerCustomizer, this.config.getFamily() == NettyHttpServerConfiguration.NettyListenerConfiguration.Family.QUIC);
            if (oldBuilder != null) {
                oldBuilder.close();
            }
            if (this.config.isSsl() && !this.httpPipelineBuilder.supportsSsl()) {
                throw new IllegalStateException("Listener configured for SSL, but no SSL context available");
            }
        }

        void setServerChannel(Channel serverChannel) {
            this.serverChannel = serverChannel;
            this.listenerCustomizer = (NettyServerCustomizer)NettyHttpServer.this.rootCustomizer.specializeForChannel(serverChannel, (Object)NettyServerCustomizer.ChannelRole.LISTENER);
            this.refresh();
        }

        protected void initChannel(@NonNull Channel ch) throws Exception {
            HttpPipelineBuilder httpPipelineBuilder = this.httpPipelineBuilder;
            Objects.requireNonNull(httpPipelineBuilder);
            httpPipelineBuilder.new HttpPipelineBuilder.ConnectionPipeline(ch, this.config.isSsl()).initChannel();
        }
    }

    private class UdpListener
    extends Listener {
        UdpListener(NettyHttpServerConfiguration.NettyListenerConfiguration config) {
            super(config);
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            this.setServerChannel(ch);
            HttpPipelineBuilder httpPipelineBuilder = this.httpPipelineBuilder;
            Objects.requireNonNull(httpPipelineBuilder);
            httpPipelineBuilder.new HttpPipelineBuilder.ConnectionPipeline(ch, true).initHttp3Channel();
        }
    }

    private static class DomainSocketHolder {
        private DomainSocketHolder() {
        }

        @NonNull
        private static SocketAddress makeDomainSocketAddress(String path) {
            try {
                return new DomainSocketAddress(path);
            }
            catch (NoClassDefFoundError e) {
                throw new UnsupportedOperationException("Netty domain socket support not on classpath", e);
            }
        }
    }
}

