/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

@Internal
public class ByteBufDelegate
extends ByteBuf {
    private final ByteBuf byteBuf;

    public ByteBufDelegate(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public final boolean hasMemoryAddress() {
        return this.byteBuf.hasMemoryAddress();
    }

    public final long memoryAddress() {
        return this.byteBuf.memoryAddress();
    }

    public final int capacity() {
        return this.byteBuf.capacity();
    }

    public ByteBuf capacity(int newCapacity) {
        this.byteBuf.capacity(newCapacity);
        return this;
    }

    public final int maxCapacity() {
        return this.byteBuf.maxCapacity();
    }

    public final ByteBufAllocator alloc() {
        return this.byteBuf.alloc();
    }

    @Deprecated
    public final ByteOrder order() {
        return this.byteBuf.order();
    }

    @Deprecated
    public ByteBuf order(ByteOrder endianness) {
        return this.byteBuf.order(endianness);
    }

    public final ByteBuf unwrap() {
        return this.byteBuf;
    }

    public ByteBuf asReadOnly() {
        return this.byteBuf.asReadOnly();
    }

    public boolean isReadOnly() {
        return this.byteBuf.isReadOnly();
    }

    public final boolean isDirect() {
        return this.byteBuf.isDirect();
    }

    public final int readerIndex() {
        return this.byteBuf.readerIndex();
    }

    public final ByteBuf readerIndex(int readerIndex) {
        this.byteBuf.readerIndex(readerIndex);
        return this;
    }

    public final int writerIndex() {
        return this.byteBuf.writerIndex();
    }

    public final ByteBuf writerIndex(int writerIndex) {
        this.byteBuf.writerIndex(writerIndex);
        return this;
    }

    public ByteBuf setIndex(int readerIndex, int writerIndex) {
        this.byteBuf.setIndex(readerIndex, writerIndex);
        return this;
    }

    public final int readableBytes() {
        return this.byteBuf.readableBytes();
    }

    public final int writableBytes() {
        return this.byteBuf.writableBytes();
    }

    public final int maxWritableBytes() {
        return this.byteBuf.maxWritableBytes();
    }

    public final boolean isReadable() {
        return this.byteBuf.isReadable();
    }

    public final boolean isWritable() {
        return this.byteBuf.isWritable();
    }

    public final ByteBuf clear() {
        this.byteBuf.clear();
        return this;
    }

    public final ByteBuf markReaderIndex() {
        this.byteBuf.markReaderIndex();
        return this;
    }

    public final ByteBuf resetReaderIndex() {
        this.byteBuf.resetReaderIndex();
        return this;
    }

    public final ByteBuf markWriterIndex() {
        this.byteBuf.markWriterIndex();
        return this;
    }

    public final ByteBuf resetWriterIndex() {
        this.byteBuf.resetWriterIndex();
        return this;
    }

    public ByteBuf discardReadBytes() {
        this.byteBuf.discardReadBytes();
        return this;
    }

    public ByteBuf discardSomeReadBytes() {
        this.byteBuf.discardSomeReadBytes();
        return this;
    }

    public ByteBuf ensureWritable(int minWritableBytes) {
        this.byteBuf.ensureWritable(minWritableBytes);
        return this;
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        return this.byteBuf.ensureWritable(minWritableBytes, force);
    }

    public boolean getBoolean(int index) {
        return this.byteBuf.getBoolean(index);
    }

    public byte getByte(int index) {
        return this.byteBuf.getByte(index);
    }

    public short getUnsignedByte(int index) {
        return this.byteBuf.getUnsignedByte(index);
    }

    public short getShort(int index) {
        return this.byteBuf.getShort(index);
    }

    public short getShortLE(int index) {
        return this.byteBuf.getShortLE(index);
    }

    public int getUnsignedShort(int index) {
        return this.byteBuf.getUnsignedShort(index);
    }

    public int getUnsignedShortLE(int index) {
        return this.byteBuf.getUnsignedShortLE(index);
    }

    public int getMedium(int index) {
        return this.byteBuf.getMedium(index);
    }

    public int getMediumLE(int index) {
        return this.byteBuf.getMediumLE(index);
    }

    public int getUnsignedMedium(int index) {
        return this.byteBuf.getUnsignedMedium(index);
    }

    public int getUnsignedMediumLE(int index) {
        return this.byteBuf.getUnsignedMediumLE(index);
    }

    public int getInt(int index) {
        return this.byteBuf.getInt(index);
    }

    public int getIntLE(int index) {
        return this.byteBuf.getIntLE(index);
    }

    public long getUnsignedInt(int index) {
        return this.byteBuf.getUnsignedInt(index);
    }

    public long getUnsignedIntLE(int index) {
        return this.byteBuf.getUnsignedIntLE(index);
    }

    public long getLong(int index) {
        return this.byteBuf.getLong(index);
    }

    public long getLongLE(int index) {
        return this.byteBuf.getLongLE(index);
    }

    public char getChar(int index) {
        return this.byteBuf.getChar(index);
    }

    public float getFloat(int index) {
        return this.byteBuf.getFloat(index);
    }

    public double getDouble(int index) {
        return this.byteBuf.getDouble(index);
    }

    public ByteBuf getBytes(int index, ByteBuf dst) {
        this.byteBuf.getBytes(index, dst);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int length) {
        this.byteBuf.getBytes(index, dst, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.byteBuf.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst) {
        this.byteBuf.getBytes(index, dst);
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.byteBuf.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.byteBuf.getBytes(index, dst);
        return this;
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.byteBuf.getBytes(index, out, length);
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.byteBuf.getBytes(index, out, length);
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        return this.byteBuf.getBytes(index, out, position, length);
    }

    public CharSequence getCharSequence(int index, int length, Charset charset) {
        return this.byteBuf.getCharSequence(index, length, charset);
    }

    public ByteBuf setBoolean(int index, boolean value) {
        this.byteBuf.setBoolean(index, value);
        return this;
    }

    public ByteBuf setByte(int index, int value) {
        this.byteBuf.setByte(index, value);
        return this;
    }

    public ByteBuf setShort(int index, int value) {
        this.byteBuf.setShort(index, value);
        return this;
    }

    public ByteBuf setShortLE(int index, int value) {
        this.byteBuf.setShortLE(index, value);
        return this;
    }

    public ByteBuf setMedium(int index, int value) {
        this.byteBuf.setMedium(index, value);
        return this;
    }

    public ByteBuf setMediumLE(int index, int value) {
        this.byteBuf.setMediumLE(index, value);
        return this;
    }

    public ByteBuf setInt(int index, int value) {
        this.byteBuf.setInt(index, value);
        return this;
    }

    public ByteBuf setIntLE(int index, int value) {
        this.byteBuf.setIntLE(index, value);
        return this;
    }

    public ByteBuf setLong(int index, long value) {
        this.byteBuf.setLong(index, value);
        return this;
    }

    public ByteBuf setLongLE(int index, long value) {
        this.byteBuf.setLongLE(index, value);
        return this;
    }

    public ByteBuf setChar(int index, int value) {
        this.byteBuf.setChar(index, value);
        return this;
    }

    public ByteBuf setFloat(int index, float value) {
        this.byteBuf.setFloat(index, value);
        return this;
    }

    public ByteBuf setDouble(int index, double value) {
        this.byteBuf.setDouble(index, value);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src) {
        this.byteBuf.setBytes(index, src);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src, int length) {
        this.byteBuf.setBytes(index, src, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.byteBuf.setBytes(index, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src) {
        this.byteBuf.setBytes(index, src);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.byteBuf.setBytes(index, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.byteBuf.setBytes(index, src);
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.byteBuf.setBytes(index, in, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.byteBuf.setBytes(index, in, length);
    }

    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return this.byteBuf.setBytes(index, in, position, length);
    }

    public ByteBuf setZero(int index, int length) {
        this.byteBuf.setZero(index, length);
        return this;
    }

    public int setCharSequence(int index, CharSequence sequence, Charset charset) {
        return this.byteBuf.setCharSequence(index, sequence, charset);
    }

    public boolean readBoolean() {
        return this.byteBuf.readBoolean();
    }

    public byte readByte() {
        return this.byteBuf.readByte();
    }

    public short readUnsignedByte() {
        return this.byteBuf.readUnsignedByte();
    }

    public short readShort() {
        return this.byteBuf.readShort();
    }

    public short readShortLE() {
        return this.byteBuf.readShortLE();
    }

    public int readUnsignedShort() {
        return this.byteBuf.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.byteBuf.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.byteBuf.readMedium();
    }

    public int readMediumLE() {
        return this.byteBuf.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.byteBuf.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.byteBuf.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.byteBuf.readInt();
    }

    public int readIntLE() {
        return this.byteBuf.readIntLE();
    }

    public long readUnsignedInt() {
        return this.byteBuf.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.byteBuf.readUnsignedIntLE();
    }

    public long readLong() {
        return this.byteBuf.readLong();
    }

    public long readLongLE() {
        return this.byteBuf.readLongLE();
    }

    public char readChar() {
        return this.byteBuf.readChar();
    }

    public float readFloat() {
        return this.byteBuf.readFloat();
    }

    public double readDouble() {
        return this.byteBuf.readDouble();
    }

    public ByteBuf readBytes(int length) {
        return this.byteBuf.readBytes(length);
    }

    public ByteBuf readSlice(int length) {
        return this.byteBuf.readSlice(length);
    }

    public ByteBuf readRetainedSlice(int length) {
        return this.byteBuf.readRetainedSlice(length);
    }

    public ByteBuf readBytes(ByteBuf dst) {
        this.byteBuf.readBytes(dst);
        return this;
    }

    public ByteBuf readBytes(ByteBuf dst, int length) {
        this.byteBuf.readBytes(dst, length);
        return this;
    }

    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.byteBuf.readBytes(dst, dstIndex, length);
        return this;
    }

    public ByteBuf readBytes(byte[] dst) {
        this.byteBuf.readBytes(dst);
        return this;
    }

    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.byteBuf.readBytes(dst, dstIndex, length);
        return this;
    }

    public ByteBuf readBytes(ByteBuffer dst) {
        this.byteBuf.readBytes(dst);
        return this;
    }

    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        this.byteBuf.readBytes(out, length);
        return this;
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.byteBuf.readBytes(out, length);
    }

    public int readBytes(FileChannel out, long position, int length) throws IOException {
        return this.byteBuf.readBytes(out, position, length);
    }

    public CharSequence readCharSequence(int length, Charset charset) {
        return this.byteBuf.readCharSequence(length, charset);
    }

    public ByteBuf skipBytes(int length) {
        this.byteBuf.skipBytes(length);
        return this;
    }

    public ByteBuf writeBoolean(boolean value) {
        this.byteBuf.writeBoolean(value);
        return this;
    }

    public ByteBuf writeByte(int value) {
        this.byteBuf.writeByte(value);
        return this;
    }

    public ByteBuf writeShort(int value) {
        this.byteBuf.writeShort(value);
        return this;
    }

    public ByteBuf writeShortLE(int value) {
        this.byteBuf.writeShortLE(value);
        return this;
    }

    public ByteBuf writeMedium(int value) {
        this.byteBuf.writeMedium(value);
        return this;
    }

    public ByteBuf writeMediumLE(int value) {
        this.byteBuf.writeMediumLE(value);
        return this;
    }

    public ByteBuf writeInt(int value) {
        this.byteBuf.writeInt(value);
        return this;
    }

    public ByteBuf writeIntLE(int value) {
        this.byteBuf.writeIntLE(value);
        return this;
    }

    public ByteBuf writeLong(long value) {
        this.byteBuf.writeLong(value);
        return this;
    }

    public ByteBuf writeLongLE(long value) {
        this.byteBuf.writeLongLE(value);
        return this;
    }

    public ByteBuf writeChar(int value) {
        this.byteBuf.writeChar(value);
        return this;
    }

    public ByteBuf writeFloat(float value) {
        this.byteBuf.writeFloat(value);
        return this;
    }

    public ByteBuf writeDouble(double value) {
        this.byteBuf.writeDouble(value);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src) {
        this.byteBuf.writeBytes(src);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src, int length) {
        this.byteBuf.writeBytes(src, length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.byteBuf.writeBytes(src, srcIndex, length);
        return this;
    }

    public ByteBuf writeBytes(byte[] src) {
        this.byteBuf.writeBytes(src);
        return this;
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.byteBuf.writeBytes(src, srcIndex, length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuffer src) {
        this.byteBuf.writeBytes(src);
        return this;
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        return this.byteBuf.writeBytes(in, length);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.byteBuf.writeBytes(in, length);
    }

    public int writeBytes(FileChannel in, long position, int length) throws IOException {
        return this.byteBuf.writeBytes(in, position, length);
    }

    public ByteBuf writeZero(int length) {
        this.byteBuf.writeZero(length);
        return this;
    }

    public int writeCharSequence(CharSequence sequence, Charset charset) {
        return this.byteBuf.writeCharSequence(sequence, charset);
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.byteBuf.indexOf(fromIndex, toIndex, value);
    }

    public int bytesBefore(byte value) {
        return this.byteBuf.bytesBefore(value);
    }

    public int bytesBefore(int length, byte value) {
        return this.byteBuf.bytesBefore(length, value);
    }

    public int bytesBefore(int index, int length, byte value) {
        return this.byteBuf.bytesBefore(index, length, value);
    }

    public int forEachByte(ByteProcessor processor) {
        return this.byteBuf.forEachByte(processor);
    }

    public int forEachByte(int index, int length, ByteProcessor processor) {
        return this.byteBuf.forEachByte(index, length, processor);
    }

    public int forEachByteDesc(ByteProcessor processor) {
        return this.byteBuf.forEachByteDesc(processor);
    }

    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.byteBuf.forEachByteDesc(index, length, processor);
    }

    public ByteBuf copy() {
        return this.byteBuf.copy();
    }

    public ByteBuf copy(int index, int length) {
        return this.byteBuf.copy(index, length);
    }

    public ByteBuf slice() {
        return this.byteBuf.slice();
    }

    public ByteBuf retainedSlice() {
        return this.byteBuf.retainedSlice();
    }

    public ByteBuf slice(int index, int length) {
        return this.byteBuf.slice(index, length);
    }

    public ByteBuf retainedSlice(int index, int length) {
        return this.byteBuf.retainedSlice(index, length);
    }

    public ByteBuf duplicate() {
        return this.byteBuf.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.byteBuf.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.byteBuf.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.byteBuf.nioBuffer();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return this.byteBuf.nioBuffer(index, length);
    }

    public ByteBuffer[] nioBuffers() {
        return this.byteBuf.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return this.byteBuf.nioBuffers(index, length);
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.byteBuf.internalNioBuffer(index, length);
    }

    public boolean hasArray() {
        return this.byteBuf.hasArray();
    }

    public byte[] array() {
        return this.byteBuf.array();
    }

    public int arrayOffset() {
        return this.byteBuf.arrayOffset();
    }

    public String toString(Charset charset) {
        return this.byteBuf.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.byteBuf.toString(index, length, charset);
    }

    public int hashCode() {
        return this.byteBuf.hashCode();
    }

    public boolean equals(Object obj) {
        return this.byteBuf.equals(obj);
    }

    public int compareTo(ByteBuf buffer) {
        return this.byteBuf.compareTo(buffer);
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)((Object)this)) + "(" + this.byteBuf.toString() + ")";
    }

    public ByteBuf retain(int increment) {
        this.byteBuf.retain(increment);
        return this;
    }

    public ByteBuf retain() {
        this.byteBuf.retain();
        return this;
    }

    public ByteBuf touch() {
        this.byteBuf.touch();
        return this;
    }

    public ByteBuf touch(Object hint) {
        this.byteBuf.touch(hint);
        return this;
    }

    public final boolean isReadable(int size) {
        return this.byteBuf.isReadable(size);
    }

    public final boolean isWritable(int size) {
        return this.byteBuf.isWritable(size);
    }

    public final int refCnt() {
        return this.byteBuf.refCnt();
    }

    public boolean release() {
        return this.byteBuf.release();
    }

    public boolean release(int decrement) {
        return this.byteBuf.release(decrement);
    }
}

