/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.context.event.HttpRequestReceivedEvent;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyRequestLifecycle;
import io.micronaut.http.server.netty.NettyResponseLifecycle;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.OutboundAccess;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@ChannelHandler.Sharable
public final class RoutingInBoundHandler
implements RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    final StaticResourceResolver staticResourceResolver;
    final NettyHttpServerConfiguration serverConfiguration;
    final RequestArgumentSatisfier requestArgumentSatisfier;
    final Supplier<ExecutorService> ioExecutorSupplier;
    final boolean multipartEnabled;
    final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    ExecutorService ioExecutor;
    final ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher;
    final ApplicationEventPublisher<HttpRequestReceivedEvent> receivedPublisher;
    final RouteExecutor routeExecutor;
    final ConversionService conversionService;
    boolean supportLoggingHandler = false;

    RoutingInBoundHandler(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices embeddedServerContext, Supplier<ExecutorService> ioExecutor, ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher, ApplicationEventPublisher<HttpRequestReceivedEvent> receivedPublisher, ConversionService conversionService) {
        this.staticResourceResolver = embeddedServerContext.getStaticResourceResolver();
        this.messageBodyHandlerRegistry = embeddedServerContext.getMessageBodyHandlerRegistry();
        this.ioExecutorSupplier = ioExecutor;
        this.requestArgumentSatisfier = embeddedServerContext.getRequestArgumentSatisfier();
        this.serverConfiguration = serverConfiguration;
        this.terminateEventPublisher = terminateEventPublisher;
        this.receivedPublisher = receivedPublisher;
        Optional isMultiPartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || (Boolean)isMultiPartEnabled.get() != false;
        this.routeExecutor = embeddedServerContext.getRouteExecutor();
        this.conversionService = conversionService;
    }

    private void cleanupRequest(NettyHttpRequest<?> request) {
        try {
            request.release();
        }
        finally {
            block9: {
                if (!this.terminateEventPublisher.isEmpty()) {
                    try {
                        this.terminateEventPublisher.publishEvent((Object)new HttpRequestTerminatedEvent(request));
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error("Error publishing request terminated event: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
    }

    @Override
    public void responseWritten(Object attachment) {
        if (attachment != null) {
            this.cleanupRequest((NettyHttpRequest)((Object)attachment));
        }
    }

    @Override
    public void handleUnboundError(Throwable cause) {
        if (this.isIgnorable(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: {}", (Object)cause.getMessage(), (Object)cause);
            }
            return;
        }
        if (cause instanceof SSLException || cause.getCause() instanceof SSLException || cause instanceof DecompressionException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Micronaut Server Error - No request state present. Cause: {}", (Object)cause.getMessage(), (Object)cause);
            }
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Micronaut Server Error - No request state present. Cause: {}", (Object)cause.getMessage(), (Object)cause);
        }
    }

    @Override
    public void accept(ChannelHandlerContext ctx, io.netty.handler.codec.http.HttpRequest request, CloseableByteBody body, OutboundAccess outboundAccess) {
        NettyHttpRequest mnRequest = new NettyHttpRequest(request, body, ctx, this.conversionService, this.serverConfiguration);
        if (this.receivedPublisher != ApplicationEventPublisher.NO_OP) {
            this.receivedPublisher.publishEvent((Object)new HttpRequestReceivedEvent(mnRequest));
        }
        if (this.serverConfiguration.isValidateUrl()) {
            try {
                mnRequest.getUri();
            }
            catch (IllegalArgumentException e) {
                body.close();
                NettyHttpRequest errorRequest = new NettyHttpRequest((io.netty.handler.codec.http.HttpRequest)new DefaultHttpRequest(request.protocolVersion(), request.method(), "/"), (CloseableByteBody)AvailableNettyByteBody.empty(), ctx, this.conversionService, this.serverConfiguration);
                outboundAccess.attachment((Object)errorRequest);
                try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(errorRequest)).propagate();){
                    new NettyRequestLifecycle(this, outboundAccess).handleException(errorRequest, e.getCause() == null ? e : e.getCause());
                }
                return;
            }
        }
        if (this.supportLoggingHandler && ctx.pipeline().get("http-access-logger") != null) {
            AttributeKey key = AttributeKey.valueOf((String)NettyHttpRequest.class.getSimpleName());
            ctx.channel().attr(key).set(mnRequest);
        }
        outboundAccess.attachment((Object)mnRequest);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(mnRequest)).propagate();){
            new NettyRequestLifecycle(this, outboundAccess).handleNormal(mnRequest);
        }
    }

    public void writeResponse(OutboundAccess outboundAccess, NettyHttpRequest<?> nettyHttpRequest, HttpResponse<?> response, Throwable throwable) {
        if (throwable != null) {
            response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, throwable);
        }
        if (response != null) {
            ExecutionFlow finalResponse = new NettyResponseLifecycle(this, nettyHttpRequest).encodeHttpResponseSafe(nettyHttpRequest, (HttpResponse)response);
            finalResponse.onComplete((r, t) -> {
                ByteBodyHttpResponse encodedResponse;
                if (t != null) {
                    encodedResponse = ByteBodyHttpResponseWrapper.wrap((HttpResponse)HttpResponse.serverError(), (CloseableByteBody)AvailableNettyByteBody.empty());
                    try {
                        outboundAccess.closeAfterWrite();
                    }
                    catch (Throwable g) {
                        t.addSuppressed(g);
                    }
                    LOG.warn("Failed to encode error response", t);
                } else {
                    encodedResponse = r;
                }
                try (ByteBodyHttpResponse g = encodedResponse;){
                    this.closeConnectionIfError((HttpResponse<?>)encodedResponse, nettyHttpRequest, outboundAccess);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Response {} - {} {}", new Object[]{encodedResponse.code(), nettyHttpRequest.getMethodName(), nettyHttpRequest.getUri()});
                    }
                    io.netty.handler.codec.http.HttpResponse noBodyResponse = NettyMutableHttpResponse.toNoBodyResponse((HttpResponse)encodedResponse);
                    if (nettyHttpRequest.getMethod() == HttpMethod.HEAD) {
                        outboundAccess.writeHeadResponse((io.netty.handler.codec.http.HttpResponse)new DefaultHttpResponse(noBodyResponse.protocolVersion(), noBodyResponse.status(), noBodyResponse.headers()));
                    } else {
                        outboundAccess.write(noBodyResponse, encodedResponse.byteBody());
                    }
                }
                catch (Throwable u) {
                    if (t != null) {
                        u.addSuppressed((Throwable)t);
                    }
                    t = u;
                }
                if (t != null) {
                    LOG.warn("Failed to build error response", t);
                }
            });
        } else {
            outboundAccess.closeAfterWrite();
            outboundAccess.write((io.netty.handler.codec.http.HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE), (ByteBody)AvailableNettyByteBody.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private void closeConnectionIfError(HttpResponse<?> message, HttpRequest<?> request, OutboundAccess outboundAccess) {
        NettyHttpRequest nettyRequest;
        boolean decodeError;
        boolean bl = decodeError = request instanceof NettyHttpRequest && (nettyRequest = (NettyHttpRequest)request).getNativeRequest().decoderResult().isFailure();
        if (decodeError || message.code() >= 500 && !this.serverConfiguration.isKeepAliveOnServerError()) {
            outboundAccess.closeAfterWrite();
        }
    }

    boolean isIgnorable(Throwable cause) {
        if (cause instanceof ClosedChannelException || cause.getCause() instanceof ClosedChannelException) {
            return true;
        }
        if (cause instanceof PrematureChannelClosureException && "Channel closed while still aggregating message".equals(cause.getMessage())) {
            return true;
        }
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }
}

