/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpResponseFactory;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

@Internal
public class NettyHttpResponseFactory
implements HttpResponseFactory {
    public <T> MutableHttpResponse<T> ok(T body) {
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, body, ConversionService.SHARED);
    }

    public <T> MutableHttpResponse<T> status(HttpStatus status, T body) {
        return this.ok(body).status(status);
    }

    public <T> MutableHttpResponse<T> status(HttpStatus status, String reason) {
        HttpResponseStatus nettyStatus = reason == null ? HttpResponseStatus.valueOf((int)status.getCode()) : HttpResponseStatus.valueOf((int)status.getCode(), (String)reason);
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, ConversionService.SHARED);
    }

    public <T> MutableHttpResponse<T> status(int status, String reason) {
        HttpResponseStatus nettyStatus = reason == null ? HttpResponseStatus.valueOf((int)status) : HttpResponseStatus.valueOf((int)status, (String)reason);
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, ConversionService.SHARED);
    }
}

